/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.jacc;

import javax.security.jacc.PolicyContextException;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.logging.Loggable;
import weblogic.security.SecurityLogger;
import weblogic.security.jacc.RoleMapper;

public abstract class RoleMapperFactory {
    private static String ROLEMAPPERFACTORY_NAME = "weblogic.security.jacc.RoleMapperFactory.provider";
    private static RoleMapperFactory rmFactory;
    private static DebugLogger jaccDebugLogger;

    public RoleMapperFactory() {
        if (jaccDebugLogger.isDebugEnabled()) {
            jaccDebugLogger.debug("RoleMapperFactory noarg constructor");
        }
    }

    public static RoleMapperFactory getRoleMapperFactory() throws ClassNotFoundException, PolicyContextException {
        if (rmFactory != null) {
            return rmFactory;
        }
        String[] stringArray = new String[]{null};
        String string = null;
        try {
            Class<?> clazz = null;
            stringArray[0] = System.getProperty(ROLEMAPPERFACTORY_NAME);
            string = stringArray[0];
            if (string == null) {
                throw new ClassNotFoundException(SecurityLogger.getJACCPropertyNotSet((String)ROLEMAPPERFACTORY_NAME));
            }
            clazz = Class.forName(string, true, ClassLoader.getSystemClassLoader());
            Object obj = clazz.newInstance();
            rmFactory = (RoleMapperFactory)obj;
        }
        catch (ClassNotFoundException classNotFoundException) {
            Loggable loggable = SecurityLogger.logJACCRoleMapperFactoryProviderClassNotFoundLoggable(string, (Exception)classNotFoundException);
            throw new ClassNotFoundException(loggable.getMessageText(), classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Loggable loggable = SecurityLogger.logJACCRoleMapperFactoryProviderClassNotFoundLoggable(string, (Exception)illegalAccessException);
            throw new PolicyContextException(loggable.getMessageText(), (Throwable)illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            Loggable loggable = SecurityLogger.logJACCRoleMapperFactoryProviderClassNotFoundLoggable(string, (Exception)instantiationException);
            throw new PolicyContextException(loggable.getMessageText(), (Throwable)instantiationException);
        }
        catch (ClassCastException classCastException) {
            Loggable loggable = SecurityLogger.logJACCRoleMapperFactoryProviderClassNotFoundLoggable(string, (Exception)classCastException);
            throw new PolicyContextException(loggable.getMessageText(), (Throwable)classCastException);
        }
        return rmFactory;
    }

    public abstract RoleMapper getRoleMapper(String var1, boolean var2);

    public abstract RoleMapper getRoleMapper(String var1, String var2, boolean var3);

    public abstract RoleMapper getRoleMapperForContextID(String var1);

    public abstract void removeRoleMapper(String var1);

    static {
        jaccDebugLogger = DebugLogger.getDebugLogger((String)"DebugSecurityJACCNonPolicy");
    }
}

