/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.jacc.simpleprovider;

import java.security.Permission;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import weblogic.diagnostics.debug.DebugLogger;

class GrantGenerator {
    private static GrantGenerator SINGLETON = null;
    private static final String defaultPrincipalClassName;
    private static final String PRINCIPALCLASSNAMEPROP = "weblogic.jaccprovider.principalclass";
    private static String DEFAULTPRINCIPALCLASSNAME;
    private static String HEADER;
    private static DebugLogger jaccDebugLogger;
    private static String principalClassName;

    private GrantGenerator() {
    }

    protected static String generateHeader() {
        return HEADER;
    }

    protected static String generateUncheckedGrants(String string, Permissions permissions) {
        if (permissions == null || !permissions.elements().hasMoreElements()) {
            if (jaccDebugLogger.isDebugEnabled()) {
                jaccDebugLogger.debug("GrantGenerator:generateUncheckedGrants uncheckedPermissions is null or empty. Returning an empty String.");
            }
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer("grant {\n\t//granted and unchecked resources - full access allowed\n");
        Enumeration<Permission> enumeration = permissions.elements();
        while (enumeration.hasMoreElements()) {
            Permission permission = enumeration.nextElement();
            stringBuffer.append(GrantGenerator.permLine(permission));
        }
        stringBuffer.append("};\n\n");
        return stringBuffer.toString();
    }

    protected static String generateExcludedGrants(String string, Permissions permissions) {
        if (permissions == null || !permissions.elements().hasMoreElements()) {
            if (jaccDebugLogger.isDebugEnabled()) {
                jaccDebugLogger.debug("GrantGenerator:generateExcludedGrants excludedPermissions is null or empty. Returning an empty String.");
            }
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer("grant {\n\t//excluded resources\n");
        Enumeration<Permission> enumeration = permissions.elements();
        while (enumeration.hasMoreElements()) {
            Permission permission = enumeration.nextElement();
            stringBuffer.append(GrantGenerator.permLine(permission));
        }
        stringBuffer.append("};\n\n");
        return stringBuffer.toString();
    }

    private static String permLine(Permission permission) {
        String string;
        StringBuffer stringBuffer = new StringBuffer("\tpermission " + permission.getClass().getName());
        String string2 = permission.getName();
        if (string2 != null) {
            stringBuffer.append(" \"" + string2 + "\"");
        }
        if ((string = permission.getActions()) != null) {
            stringBuffer.append(" , \"" + string + "\"");
        }
        stringBuffer.append(";\n");
        return stringBuffer.toString();
    }

    protected static String generateRoleGrants(String string, Map map, Map map2) {
        if (string == null || map == null || map.isEmpty() || map2 == null || map2.isEmpty()) {
            if (jaccDebugLogger.isDebugEnabled()) {
                jaccDebugLogger.debug("GrantGenerator:generateRoleGrants appRolesToPrincipalNames and/or roleToPermissions is null or empty. Returning an empty String.");
            }
            return "";
        }
        HashMap hashMap = (HashMap)GrantGenerator.getUserToRoleMap(map);
        if (hashMap.isEmpty()) {
            if (jaccDebugLogger.isDebugEnabled()) {
                jaccDebugLogger.debug("GrantGenerator:generateRoleGrants userToRoleMap is null or empty. Returning an empty String.");
            }
            return "";
        }
        Set set = hashMap.keySet();
        Iterator iterator = set.iterator();
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (string2 == null) {
                if (!jaccDebugLogger.isDebugEnabled()) continue;
                jaccDebugLogger.debug("GrantGenerator:generateRoleGrants userName in userToRoleMap is null or empty. Ignoring and continuing.");
                continue;
            }
            stringBuffer.append("grant principal " + principalClassName + " \"" + string2 + "\" {\n");
            ArrayList arrayList = (ArrayList)hashMap.get(string2);
            if (arrayList == null || arrayList.isEmpty()) {
                if (!jaccDebugLogger.isDebugEnabled()) continue;
                jaccDebugLogger.debug("GrantGenerator:generateRoleGrants the RoleNameList for userName " + string2 + " in userToRoleMap is null or empty. Ignoring and continuing.");
                continue;
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                String string3 = (String)arrayList.get(i);
                if (string3 == null) {
                    if (!jaccDebugLogger.isDebugEnabled()) continue;
                    jaccDebugLogger.debug("GrantGenerator:generateRoleGrants roleName in roleNameList(" + i + ") " + "is null. Ignoring and continuing.");
                    continue;
                }
                ArrayList arrayList2 = (ArrayList)map2.get(string3);
                if (arrayList2 == null) {
                    if (!jaccDebugLogger.isDebugEnabled()) continue;
                    jaccDebugLogger.debug("GrantGenerator:generateRoleGrants permList for roleName " + string3 + " in roleToPermissions is null. Ignoring and continuing.");
                    continue;
                }
                for (Permission permission : arrayList2) {
                    if (permission == null) {
                        if (!jaccDebugLogger.isDebugEnabled()) continue;
                        jaccDebugLogger.debug("GrantGenerator:generateRoleGrants perm in permList is null. Ignoring and continuing.");
                        continue;
                    }
                    stringBuffer.append("\t// Mapping this permission for Role: " + string3 + "\n");
                    stringBuffer.append(GrantGenerator.permLine(permission) + "\n");
                }
            }
            stringBuffer.append("};\n\n");
        }
        return stringBuffer.toString();
    }

    private static Map getUserToRoleMap(Map map) {
        HashMap<String, ArrayList<String>> hashMap = new HashMap<String, ArrayList<String>>();
        Set set = map.keySet();
        for (String string : set) {
            if (string == null) {
                if (!jaccDebugLogger.isDebugEnabled()) continue;
                jaccDebugLogger.debug("GrantGenerator:getUserToRoleMap roleName in appRolesToPrincipalNames is null. Ignoring and continuing.");
                continue;
            }
            String[] stringArray = (String[])map.get(string);
            if (stringArray == null || stringArray.length == 0) {
                if (!jaccDebugLogger.isDebugEnabled()) continue;
                jaccDebugLogger.debug("GrantGenerator:getUserToRoleMap userGroupNames for roleName " + string + "in appRolesToPrincipalNames " + "is null or empty. Ignoring and continuing.");
                continue;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                if (string2 == null) {
                    if (!jaccDebugLogger.isDebugEnabled()) continue;
                    jaccDebugLogger.debug("GrantGenerator:getUserToRoleMap userName in userGroupNames[" + i + "] " + "is null. Ignoring and continuing.");
                    continue;
                }
                ArrayList<String> arrayList = (ArrayList<String>)hashMap.get(string2);
                if (arrayList == null) {
                    arrayList = new ArrayList<String>(1);
                }
                arrayList.add(string);
                if (jaccDebugLogger.isDebugEnabled()) {
                    jaccDebugLogger.debug("GrantGenerator:getUserToRoleMap for user " + string2 + " added role " + string);
                }
                hashMap.put(string2, arrayList);
            }
        }
        return hashMap;
    }

    static {
        DEFAULTPRINCIPALCLASSNAME = "weblogic.security.jacc.simpleprovider.WLSJACCPrincipalImpl";
        HEADER = "//Automatically generated\n//Do not edit!\n\n";
        jaccDebugLogger = DebugLogger.getDebugLogger((String)"DebugSecurityJACCNonPolicy");
        principalClassName = null;
        defaultPrincipalClassName = DEFAULTPRINCIPALCLASSNAME;
        principalClassName = System.getProperty(PRINCIPALCLASSNAMEPROP, defaultPrincipalClassName);
        if (jaccDebugLogger.isDebugEnabled()) {
            jaccDebugLogger.debug("GrantGenerator:PrincipalClassName: " + principalClassName);
        }
    }
}

