/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.jacc.simpleprovider;

import java.security.SecurityPermission;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyConfigurationFactory;
import javax.security.jacc.PolicyContextException;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.security.jacc.simpleprovider.PolicyConfigurationImpl;

public class PolicyConfigurationFactoryImpl
extends PolicyConfigurationFactory {
    private static Map polConfMap = new HashMap();
    private static DebugLogger jaccDebugLogger = DebugLogger.getDebugLogger((String)"DebugSecurityJACCNonPolicy");

    public PolicyConfigurationFactoryImpl() {
        if (jaccDebugLogger.isDebugEnabled()) {
            jaccDebugLogger.debug("PolicyConfigurationFactoryImpl noarg constructor");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PolicyConfiguration getPolicyConfiguration(String string, boolean bl) throws PolicyContextException {
        SecurityManager securityManager;
        if (jaccDebugLogger.isDebugEnabled()) {
            jaccDebugLogger.debug("PolicyConfigurationFactoryImpl.getPolicyConfiguration contextID: " + (string == null ? "null" : string) + " remove: " + bl);
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(new SecurityPermission("setPolicy"));
        }
        PolicyConfiguration policyConfiguration = null;
        Map map = polConfMap;
        synchronized (map) {
            policyConfiguration = (PolicyConfiguration)polConfMap.get(string);
            if (policyConfiguration == null) {
                if (jaccDebugLogger.isDebugEnabled()) {
                    jaccDebugLogger.debug("creating a new PolicyConfigurationImpl");
                }
                policyConfiguration = new PolicyConfigurationImpl(string, this);
                polConfMap.put(string, policyConfiguration);
            } else if (bl) {
                if (jaccDebugLogger.isDebugEnabled()) {
                    jaccDebugLogger.debug("calling delete on the policy configuration");
                }
                policyConfiguration.delete();
            } else {
                ((PolicyConfigurationImpl)policyConfiguration).setStateOpen();
                if (jaccDebugLogger.isDebugEnabled()) {
                    jaccDebugLogger.debug("set the state to open on the policy configuration");
                }
            }
        }
        return policyConfiguration;
    }

    protected static PolicyConfigurationImpl getPolicyConfigurationImpl(String string) {
        return (PolicyConfigurationImpl)polConfMap.get(string);
    }

    protected static Collection getPolicyConfigurationImpls() {
        return polConfMap.values();
    }

    public boolean inService(String string) throws PolicyContextException {
        PolicyConfiguration policyConfiguration;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SecurityPermission("setPolicy"));
        }
        if ((policyConfiguration = (PolicyConfiguration)polConfMap.get(string)) == null) {
            if (jaccDebugLogger.isDebugEnabled()) {
                jaccDebugLogger.debug("inService didn't find the pc");
            }
            return false;
        }
        return policyConfiguration.inService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void removePolicyConfiguration(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SecurityPermission("setPolicy"));
        }
        Map map = polConfMap;
        synchronized (map) {
            if (jaccDebugLogger.isDebugEnabled()) {
                jaccDebugLogger.debug("removing the PolicyConfiguration for contextID: " + (string == null ? "null" : string));
            }
            polConfMap.remove(string);
        }
    }
}

