/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.jacc.simpleprovider;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Security;
import java.security.SecurityPermission;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyContextException;
import sun.security.provider.PolicyFile;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.logging.Loggable;
import weblogic.security.SecurityLogger;
import weblogic.security.jacc.RoleMapperFactory;
import weblogic.security.jacc.simpleprovider.GrantGenerator;
import weblogic.security.jacc.simpleprovider.PolicyConfigurationFactoryImpl;
import weblogic.security.jacc.simpleprovider.PolicyWriter;
import weblogic.security.jacc.simpleprovider.RoleMapperImpl;
import weblogic.security.jacc.simpleprovider.State;
import weblogic.utils.AssertionError;

public class PolicyConfigurationImpl
implements PolicyConfiguration {
    private PolicyConfiguration nextPC;
    private PolicyConfigurationFactoryImpl pcFactoryImpl;
    private State state;
    private Permissions excludedPermissions = null;
    private Permissions uncheckedPermissions = null;
    private Map rolesToPermissions;
    private String contextId;
    private String contextIdNoNPE;
    private static DebugLogger jaccDebugLogger = DebugLogger.getDebugLogger((String)"DebugSecurityJACCNonPolicy");
    private String appSpecificPolicyDirectory = null;
    private PolicyFile policy = null;
    private boolean policyChanged = false;
    private boolean needRefreshing = false;
    private static String POLICY_URL = "policy.url.";
    private static Object refreshLock = new Object();
    private static Object mapperLock = new Object();
    private String policyFileName;
    private String urlForPolicyFile;
    private static RoleMapperFactory roleMapperFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PolicyConfigurationImpl(String string, PolicyConfigurationFactoryImpl policyConfigurationFactoryImpl) {
        Object object;
        this.pcFactoryImpl = policyConfigurationFactoryImpl;
        this.contextId = string;
        this.state = State.OPEN;
        this.nextPC = null;
        this.excludedPermissions = new Permissions();
        this.uncheckedPermissions = new Permissions();
        this.rolesToPermissions = new HashMap();
        this.contextIdNoNPE = this.contextId == null ? "null" : this.contextId;
        PolicyWriter.createRepositoryDirectory();
        this.appSpecificPolicyDirectory = PolicyWriter.generateAppDirectoryFileName(this.contextIdNoNPE);
        if (this.appSpecificPolicyDirectory == null) {
            throw new AssertionError(SecurityLogger.getUnexpectedNullVariable((String)"appSpecificPolicyDirectory"));
        }
        try {
            this.policyFileName = this.appSpecificPolicyDirectory + File.separator + "granted.policy";
            object = new File(this.policyFileName);
            object = ((File)object).getAbsoluteFile();
            URI uRI = ((File)object).toURI();
            URL uRL = uRI.toURL();
            this.urlForPolicyFile = uRL.toExternalForm();
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(SecurityLogger.getUnableToConvertFiletoURL((String)this.policyFileName, (Exception)malformedURLException), malformedURLException);
        }
        object = mapperLock;
        synchronized (object) {
            if (roleMapperFactory == null) {
                try {
                    roleMapperFactory = RoleMapperFactory.getRoleMapperFactory();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new RuntimeException(SecurityLogger.logRoleMapperFactoryProblemLoggable().getMessageText(), classNotFoundException);
                }
                catch (PolicyContextException policyContextException) {
                    throw new RuntimeException(SecurityLogger.logRoleMapperFactoryProblemLoggable().getMessageText(), policyContextException);
                }
            }
        }
        if (jaccDebugLogger.isDebugEnabled()) {
            jaccDebugLogger.debug("PolicyConfigurationImpl constructor contextId: " + this.contextIdNoNPE + " appSpecificPolicyDirectory of: " + this.appSpecificPolicyDirectory);
        }
    }

    public void addToExcludedPolicy(Permission permission) throws PolicyContextException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SecurityPermission("setPolicy"));
        }
        if (State.OPEN != this.state) {
            if (jaccDebugLogger.isDebugEnabled()) {
                jaccDebugLogger.debug("PolicyConfigurationImpl: addToExcludedPolicy called on a non-open PolicyConfiguration.");
            }
            throw new UnsupportedOperationException(SecurityLogger.getPolicyContextNotOpen((String)this.contextIdNoNPE));
        }
        if (null == permission) {
            if (jaccDebugLogger.isDebugEnabled()) {
                jaccDebugLogger.debug("PolicyConfigurationImpl: addToExcludedPolicy was passed a null Permission, ignoring.");
            }
            return;
        }
        this.excludedPermissions.add(permission);
        this.policyChanged = true;
        if (jaccDebugLogger.isDebugEnabled()) {
            jaccDebugLogger.debug("PolicyConfigurationImpl: addToExcludedPolicy contextId: " + this.contextIdNoNPE + " added " + permission);
        }
    }

    public void addToExcludedPolicy(PermissionCollection permissionCollection) throws PolicyContextException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SecurityPermission("setPolicy"));
        }
        if (State.OPEN != this.state) {
            if (jaccDebugLogger.isDebugEnabled()) {
                jaccDebugLogger.debug("PolicyConfigurationImpl: addToExcludedPolicy called on a non-open PolicyConfiguration.");
            }
            throw new UnsupportedOperationException(SecurityLogger.getPolicyContextNotOpen((String)this.contextIdNoNPE));
        }
        if (null == permissionCollection || !permissionCollection.elements().hasMoreElements()) {
            if (jaccDebugLogger.isDebugEnabled()) {
                jaccDebugLogger.debug("PolicyConfigurationImpl: addToExcludedPolicy was passed a null or empty PermissionCollection, ignoring.");
            }
            return;
        }
        Enumeration<Permission> enumeration = permissionCollection.elements();
        while (enumeration.hasMoreElements()) {
            Permission permission = enumeration.nextElement();
            if (permission != null) {
                this.excludedPermissions.add(permission);
                this.policyChanged = true;
                if (!jaccDebugLogger.isDebugEnabled()) continue;
                jaccDebugLogger.debug("PolicyConfigurationImpl: addToExcludedPolicy(s) contextId: " + this.contextIdNoNPE + " added " + permission);
                continue;
            }
            if (!jaccDebugLogger.isDebugEnabled()) continue;
            jaccDebugLogger.debug("PolicyConfigurationImpl: addToExcludedPolicy(s) contains a null Permission, ignoring.");
        }
    }

    protected Permissions getExcludedPermissions() {
        return this.state != State.INSERVICE ? null : this.excludedPermissions;
    }

    public void addToRole(String string, Permission permission) throws PolicyContextException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SecurityPermission("setPolicy"));
        }
        if (State.OPEN != this.state) {
            if (jaccDebugLogger.isDebugEnabled()) {
                jaccDebugLogger.debug("PolicyConfigurationImpl: addToRole called on a non-open PolicyConfiguration.");
            }
            throw new UnsupportedOperationException(SecurityLogger.getPolicyContextNotOpen((String)this.contextIdNoNPE));
        }
        if (null == string) {
            if (jaccDebugLogger.isDebugEnabled()) {
                jaccDebugLogger.debug("PolicyConfigurationImpl: addToRole was passed a null roleName, ignoring.");
            }
            return;
        }
        if (null == permission) {
            if (jaccDebugLogger.isDebugEnabled()) {
                jaccDebugLogger.debug("PolicyConfigurationImpl: addToRole was passed a null Permission, ignoring.");
            }
            return;
        }
        ArrayList<Permission> arrayList = (ArrayList<Permission>)this.rolesToPermissions.get(string);
        if (null == arrayList) {
            arrayList = new ArrayList<Permission>();
        }
        arrayList.add(permission);
        this.rolesToPermissions.put(string, arrayList);
        this.policyChanged = true;
        if (jaccDebugLogger.isDebugEnabled()) {
            jaccDebugLogger.debug("PolicyConfigurationImpl: addToRole contextId: " + this.contextIdNoNPE + " added " + permission + " for role " + string);
            StringBuffer stringBuffer = new StringBuffer("PolicyConfigurationImpl: addToRole contextId: " + this.contextIdNoNPE + " role " + string + " has the following permissions:\n");
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append((Permission)iterator.next() + "\n");
            }
            jaccDebugLogger.debug(stringBuffer.toString());
        }
    }

    public void addToRole(String string, PermissionCollection permissionCollection) throws PolicyContextException {
        Object object;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SecurityPermission("setPolicy"));
        }
        if (State.OPEN != this.state) {
            if (jaccDebugLogger.isDebugEnabled()) {
                jaccDebugLogger.debug("PolicyConfigurationImpl: addToRole called on a non-open PolicyConfiguration.");
            }
            throw new UnsupportedOperationException(SecurityLogger.getPolicyContextNotOpen((String)this.contextIdNoNPE));
        }
        if (null == string) {
            if (jaccDebugLogger.isDebugEnabled()) {
                jaccDebugLogger.debug("PolicyConfigurationImpl: addToRole was passed a null roleName, ignoring.");
            }
            return;
        }
        if (null == permissionCollection || !permissionCollection.elements().hasMoreElements()) {
            if (jaccDebugLogger.isDebugEnabled()) {
                jaccDebugLogger.debug("PolicyConfigurationImpl: addToRole was passed a null or empty PermissionCollection, ignoring.");
            }
            return;
        }
        ArrayList<Permission> arrayList = (ArrayList<Permission>)this.rolesToPermissions.get(string);
        if (null == arrayList) {
            arrayList = new ArrayList<Permission>();
        }
        Object object2 = permissionCollection.elements();
        while (object2.hasMoreElements()) {
            object = object2.nextElement();
            if (object != null) {
                arrayList.add((Permission)object);
                if (!jaccDebugLogger.isDebugEnabled()) continue;
                jaccDebugLogger.debug("PolicyConfigurationImpl: addToRole(s) contextId: " + this.contextIdNoNPE + " added " + object + " for role " + string);
                continue;
            }
            if (!jaccDebugLogger.isDebugEnabled()) continue;
            jaccDebugLogger.debug("PolicyConfigurationImpl: addToRole(s) contains a null Permission, ignoring.");
        }
        this.rolesToPermissions.put(string, arrayList);
        this.policyChanged = true;
        if (jaccDebugLogger.isDebugEnabled()) {
            object2 = new StringBuffer("PolicyConfigurationImpl: addToRole contextId: " + this.contextIdNoNPE + " role " + string + " has the following permissions:\n");
            object = arrayList.iterator();
            while (object.hasNext()) {
                ((StringBuffer)object2).append((Permission)object.next() + "\n");
            }
            jaccDebugLogger.debug(((StringBuffer)object2).toString());
        }
    }

    public void addToUncheckedPolicy(Permission permission) throws PolicyContextException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SecurityPermission("setPolicy"));
        }
        if (State.OPEN != this.state) {
            if (jaccDebugLogger.isDebugEnabled()) {
                jaccDebugLogger.debug("PolicyConfigurationImpl: addToUncheckedPolicy called on a non-open PolicyConfiguration.");
            }
            throw new UnsupportedOperationException(SecurityLogger.getPolicyContextNotOpen((String)this.contextIdNoNPE));
        }
        if (null == permission) {
            if (jaccDebugLogger.isDebugEnabled()) {
                jaccDebugLogger.debug("PolicyConfigurationImpl: addToUncheckedPolicy was passed a null Permission, ignoring.");
            }
            return;
        }
        this.uncheckedPermissions.add(permission);
        this.policyChanged = true;
        if (jaccDebugLogger.isDebugEnabled()) {
            jaccDebugLogger.debug("PolicyConfigurationImpl: addToUncheckedPolicy contextId: " + this.contextIdNoNPE + " added " + permission);
        }
    }

    public void addToUncheckedPolicy(PermissionCollection permissionCollection) throws PolicyContextException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SecurityPermission("setPolicy"));
        }
        if (State.OPEN != this.state) {
            if (jaccDebugLogger.isDebugEnabled()) {
                jaccDebugLogger.debug("PolicyConfigurationImpl: addToUncheckedPolicy called on a non-open PolicyConfiguration.");
            }
            throw new UnsupportedOperationException(SecurityLogger.getPolicyContextNotOpen((String)this.contextIdNoNPE));
        }
        if (null == permissionCollection || !permissionCollection.elements().hasMoreElements()) {
            if (jaccDebugLogger.isDebugEnabled()) {
                jaccDebugLogger.debug("PolicyConfigurationImpl: addToUncheckedPolicy was passed a null or empty PermissionCollection, ignoring.");
            }
            return;
        }
        Enumeration<Permission> enumeration = permissionCollection.elements();
        while (enumeration.hasMoreElements()) {
            Permission permission = enumeration.nextElement();
            if (permission != null) {
                this.uncheckedPermissions.add(permission);
                this.policyChanged = true;
                if (!jaccDebugLogger.isDebugEnabled()) continue;
                jaccDebugLogger.debug("PolicyConfigurationImpl: addToUncheckedPolicy(s) contextId: " + this.contextIdNoNPE + " added " + permission);
                continue;
            }
            if (!jaccDebugLogger.isDebugEnabled()) continue;
            jaccDebugLogger.debug("PolicyConfigurationImpl: addToUncheckedPolicy(s) contains a null Permission, ignoring.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws PolicyContextException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SecurityPermission("setPolicy"));
        }
        Object object = refreshLock;
        synchronized (object) {
            Object object2;
            if (jaccDebugLogger.isDebugEnabled()) {
                jaccDebugLogger.debug("PolicyConfigurationImpl:commit contextId: " + this.contextIdNoNPE);
            }
            if (State.DELETED == this.state) {
                if (jaccDebugLogger.isDebugEnabled()) {
                    jaccDebugLogger.debug("PolicyConfigurationImpl:commit policy context in deleted state, unable to commit. contextId: " + this.contextIdNoNPE);
                }
                Loggable loggable = SecurityLogger.getPolicyContextNotOpenLoggable((String)this.contextIdNoNPE);
                throw new UnsupportedOperationException(loggable.getMessageText());
            }
            RoleMapperImpl roleMapperImpl = (RoleMapperImpl)roleMapperFactory.getRoleMapperForContextID(this.contextId);
            if (roleMapperImpl == null) {
                if (jaccDebugLogger.isDebugEnabled()) {
                    jaccDebugLogger.debug("PolicyConfigurationImpl:commit no rolemapper exists for contextId: " + this.contextIdNoNPE + ". This may be OK.");
                }
            } else {
                object2 = (HashMap)roleMapperImpl.getRolesToPrincipalNames();
                if (jaccDebugLogger.isDebugEnabled() && (object2 == null || ((HashMap)object2).size() == 0)) {
                    jaccDebugLogger.debug("PolicyConfigurationImpl:commit no role to principal mappings have been defined for contextId: " + this.contextIdNoNPE + ". This may be OK.");
                }
            }
            object2 = this.excludedToString();
            String string = this.uncheckedGrantedToString();
            if (this.policyChanged) {
                if (jaccDebugLogger.isDebugEnabled()) {
                    jaccDebugLogger.debug("PolicyConfigurationImpl:commit policy changed writing out statements");
                }
                PolicyWriter.createAppDirectory(this.appSpecificPolicyDirectory);
                PolicyWriter.writeGrantStatements(this.appSpecificPolicyDirectory, "excluded", (String)object2);
                PolicyWriter.writeGrantStatements(this.appSpecificPolicyDirectory, "granted", string);
                this.policyChanged = false;
            } else if (jaccDebugLogger.isDebugEnabled()) {
                jaccDebugLogger.debug("PolicyConfigurationImpl:commit policy did not change. No statements will be written.");
            }
            if (jaccDebugLogger.isDebugEnabled()) {
                jaccDebugLogger.debug("PolicyConfigurationImpl:commit contextId: " + this.contextIdNoNPE + " transitioned from " + this.state + " to " + State.INSERVICE);
            }
            this.state = State.INSERVICE;
            this.needRefreshing = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() throws PolicyContextException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SecurityPermission("setPolicy"));
        }
        Object object = refreshLock;
        synchronized (object) {
            if (jaccDebugLogger.isDebugEnabled()) {
                jaccDebugLogger.debug("PolicyConfigurationImpl: delete contextId: " + this.contextIdNoNPE);
            }
            this.internalRemoveExcludedPolicy();
            this.internalRemoveUncheckedPolicy();
            this.rolesToPermissions.clear();
            PolicyConfigurationFactoryImpl.removePolicyConfiguration(this.contextId);
            this.nextPC = null;
            try {
                PolicyWriter.deletePolicyFiles(this.appSpecificPolicyDirectory);
            }
            catch (IOException iOException) {
                if (jaccDebugLogger.isDebugEnabled()) {
                    jaccDebugLogger.debug(" Caught an IOException while trying to delete " + this.appSpecificPolicyDirectory + " and the .policy files in it");
                }
                throw new PolicyContextException(SecurityLogger.getUnableToDeletePolicyDirectory((Exception)iOException, (String)this.appSpecificPolicyDirectory));
            }
            this.policy = null;
            State state = this.state;
            this.state = State.DELETED;
            this.policyChanged = false;
            if (jaccDebugLogger.isDebugEnabled()) {
                jaccDebugLogger.debug("PolicyConfigurationImpl: delete contextId: " + this.contextIdNoNPE + " transitioned from " + state + " to " + this.state);
            }
        }
    }

    public String getContextID() throws PolicyContextException {
        return this.contextId;
    }

    public boolean inService() throws PolicyContextException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SecurityPermission("setPolicy"));
        }
        return this.state == State.INSERVICE;
    }

    public void linkConfiguration(PolicyConfiguration policyConfiguration) throws PolicyContextException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SecurityPermission("setPolicy"));
        }
        if (jaccDebugLogger.isDebugEnabled()) {
            jaccDebugLogger.debug("PolicyConfigurationImpl: linkConfiguration for PC with contextId: " + this.contextIdNoNPE);
        }
        if (State.OPEN != this.state) {
            if (jaccDebugLogger.isDebugEnabled()) {
                jaccDebugLogger.debug("PolicyConfigurationImpl: addToUncheckedPolicy called on a non-open PolicyConfiguration.");
            }
            throw new UnsupportedOperationException(SecurityLogger.getPolicyContextNotOpen((String)this.contextIdNoNPE));
        }
        if (policyConfiguration == null) {
            if (jaccDebugLogger.isDebugEnabled()) {
                jaccDebugLogger.debug("PolicyConfigurationImpl: linkConfiguration received a null link, ignoring.");
            }
            return;
        }
        if (policyConfiguration == this) {
            if (jaccDebugLogger.isDebugEnabled()) {
                jaccDebugLogger.debug("PolicyConfigurationImpl: linkConfiguration Cannot link to self");
            }
            throw new IllegalArgumentException(SecurityLogger.getCannotLinkPolicyConfigurationToSelf());
        }
        if (policyConfiguration instanceof PolicyConfigurationImpl) {
            PolicyConfiguration policyConfiguration2 = ((PolicyConfigurationImpl)policyConfiguration).getLink();
            while (policyConfiguration2 != null) {
                if (jaccDebugLogger.isDebugEnabled()) {
                    jaccDebugLogger.debug("PolicyConfigurationImpl: linkConfiguration following link to: " + policyConfiguration.getContextID());
                }
                if (policyConfiguration2 == this || policyConfiguration2 == policyConfiguration) {
                    throw new PolicyContextException(SecurityLogger.getCannotHaveCircularPolicyConfigurationLinks());
                }
                if (!(policyConfiguration2 instanceof PolicyConfigurationImpl)) continue;
                policyConfiguration2 = ((PolicyConfigurationImpl)policyConfiguration2).getLink();
            }
        }
        this.nextPC = policyConfiguration;
        this.policyChanged = true;
        if (jaccDebugLogger.isDebugEnabled()) {
            jaccDebugLogger.debug("PolicyConfigurationImpl: linkConfiguration for PC with contextId: " + this.contextIdNoNPE + " linked to contextId " + (policyConfiguration.getContextID() == null ? "null" : policyConfiguration.getContextID()));
        }
    }

    private void internalRemoveExcludedPolicy() throws PolicyContextException {
        this.excludedPermissions = new Permissions();
        this.policyChanged = true;
        if (jaccDebugLogger.isDebugEnabled()) {
            jaccDebugLogger.debug("PolicyConfigurationImpl: internalRemoveExcludedPolicy contextId: " + this.contextIdNoNPE);
        }
    }

    public void removeExcludedPolicy() throws PolicyContextException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SecurityPermission("setPolicy"));
        }
        if (State.OPEN != this.state) {
            if (jaccDebugLogger.isDebugEnabled()) {
                jaccDebugLogger.debug("PolicyConfigurationImpl: removeExcludedPolicy called on a non-open PolicyConfiguration.");
            }
            throw new UnsupportedOperationException(SecurityLogger.getPolicyContextNotOpen((String)this.contextIdNoNPE));
        }
        this.excludedPermissions = new Permissions();
        this.policyChanged = true;
        if (jaccDebugLogger.isDebugEnabled()) {
            jaccDebugLogger.debug("PolicyConfigurationImpl: removeExcludedPolicy contextId: " + this.contextIdNoNPE);
        }
    }

    public void removeRole(String string) throws PolicyContextException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SecurityPermission("setPolicy"));
        }
        if (State.OPEN != this.state) {
            if (jaccDebugLogger.isDebugEnabled()) {
                jaccDebugLogger.debug("PolicyConfigurationImpl: removeRole called on a non-open PolicyConfiguration.");
            }
            throw new UnsupportedOperationException(SecurityLogger.getPolicyContextNotOpen((String)this.contextIdNoNPE));
        }
        if (string == null) {
            if (jaccDebugLogger.isDebugEnabled()) {
                jaccDebugLogger.debug("PolicyConfigurationImpl: removeRole received a null roleName, ignoring.");
            }
            return;
        }
        if (this.rolesToPermissions.containsKey(string)) {
            this.rolesToPermissions.remove(string);
            this.policyChanged = true;
        }
        if (jaccDebugLogger.isDebugEnabled()) {
            jaccDebugLogger.debug("PolicyConfigurationImpl: removeRole completed contextId: " + this.contextIdNoNPE + " roleName: " + string);
        }
    }

    private void internalRemoveUncheckedPolicy() throws PolicyContextException {
        this.uncheckedPermissions = new Permissions();
        this.policyChanged = true;
        if (jaccDebugLogger.isDebugEnabled()) {
            jaccDebugLogger.debug("PolicyConfigurationImpl: internalRemoveUncheckedPolicy contextId: " + this.contextIdNoNPE);
        }
    }

    public void removeUncheckedPolicy() throws PolicyContextException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SecurityPermission("setPolicy"));
        }
        if (State.OPEN != this.state) {
            if (jaccDebugLogger.isDebugEnabled()) {
                jaccDebugLogger.debug("PolicyConfigurationImpl: removeUncheckedPolicy called on a non-open PolicyConfiguration.");
            }
            throw new UnsupportedOperationException(SecurityLogger.getPolicyContextNotOpen((String)this.contextIdNoNPE));
        }
        this.uncheckedPermissions = new Permissions();
        this.policyChanged = true;
        if (jaccDebugLogger.isDebugEnabled()) {
            jaccDebugLogger.debug("PolicyConfigurationImpl: removeUncheckedPolicy contextId: " + this.contextIdNoNPE);
        }
    }

    private String uncheckedGrantedToString() {
        String string = null;
        if (this.uncheckedPermissions != null && this.uncheckedPermissions.elements().hasMoreElements() || this.rolesToPermissions != null && !this.rolesToPermissions.isEmpty()) {
            StringBuffer stringBuffer = new StringBuffer(GrantGenerator.generateHeader());
            stringBuffer.append(GrantGenerator.generateUncheckedGrants(this.contextId, this.uncheckedPermissions));
            Map map = this.getRolesToPrincipalMapping();
            if (map != null && !map.isEmpty()) {
                HashMap hashMap = new HashMap(map);
                Set set = map.keySet();
                for (String string2 : set) {
                    if (this.rolesToPermissions.containsKey(string2)) continue;
                    if (jaccDebugLogger.isDebugEnabled()) {
                        jaccDebugLogger.debug("PolicyConfigurationImpl: uncheckedGrantedToString contextId: " + this.contextIdNoNPE + " role: " + string2 + " isn't in rolesToPermissions, removing.");
                    }
                    hashMap.remove(string2);
                }
                stringBuffer.append(GrantGenerator.generateRoleGrants(this.contextId, hashMap, this.rolesToPermissions));
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    private String excludedToString() {
        String string = null;
        if (this.excludedPermissions != null && this.excludedPermissions.elements().hasMoreElements()) {
            StringBuffer stringBuffer = new StringBuffer(GrantGenerator.generateHeader());
            stringBuffer.append(GrantGenerator.generateExcludedGrants(this.contextId, this.excludedPermissions));
            string = stringBuffer.toString();
        }
        return string;
    }

    private Map getRolesToPrincipalMapping() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SecurityPermission("setPolicy"));
        }
        RoleMapperImpl roleMapperImpl = null;
        Map map = new HashMap();
        roleMapperImpl = (RoleMapperImpl)roleMapperFactory.getRoleMapperForContextID(this.contextId);
        if (roleMapperImpl != null) {
            if (jaccDebugLogger.isDebugEnabled()) {
                jaccDebugLogger.debug("PolicyConfigurationImpl:getRolesToPrincipalMapping found a mapping for contextID: " + this.contextIdNoNPE);
            }
            map = roleMapperImpl.getRolesToPrincipalNames();
        } else if (jaccDebugLogger.isDebugEnabled()) {
            jaccDebugLogger.debug("PolicyConfigurationImpl:getRolesToPrincipalMapping finds no mappings for contextID: " + this.contextIdNoNPE);
        }
        return map;
    }

    PolicyConfiguration getLink() {
        return this.nextPC;
    }

    public State getState() {
        return this.state;
    }

    void setStateOpen() {
        this.state = State.OPEN;
    }

    public String getAppSpecificPolicyDirectoryName() {
        return new String(this.appSpecificPolicyDirectory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Object object = refreshLock;
        synchronized (object) {
            if (this.needRefreshing) {
                if (this.state == State.INSERVICE) {
                    int n = 0;
                    String string = null;
                    String string2 = null;
                    while ((string = Security.getProperty(string2 = POLICY_URL + ++n)) != null && !string.equals("")) {
                    }
                    try {
                        Security.setProperty(string2, this.urlForPolicyFile);
                        if (jaccDebugLogger.isDebugEnabled()) {
                            jaccDebugLogger.debug("PolicyConfigurationImpl:refresh add url: " + string2 + ": " + this.urlForPolicyFile);
                        }
                        if (this.policy == null) {
                            this.policy = new PolicyFile();
                        } else {
                            this.policy.refresh();
                            if (jaccDebugLogger.isDebugEnabled()) {
                                jaccDebugLogger.debug("PolicyConfigurationImpl:refresh for ContextID: " + this.contextIdNoNPE);
                            }
                        }
                        this.needRefreshing = false;
                    }
                    finally {
                        Security.setProperty(string2, "");
                        if (jaccDebugLogger.isDebugEnabled()) {
                            jaccDebugLogger.debug("PolicyConfigurationImpl:refresh url: " + string2 + " reset to \"\" ");
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PolicyFile getPolicy() {
        Object object = refreshLock;
        synchronized (object) {
            return this.state == State.INSERVICE ? this.policy : null;
        }
    }

    public String toString() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nPolicyConfiguration for context: " + this.contextIdNoNPE);
        stringBuffer.append("\nState: " + this.state);
        stringBuffer.append("\nAppSpecificPolicyDirectory: " + this.appSpecificPolicyDirectory);
        try {
            stringBuffer.append("\nLinked to PolicyConfiguration with contextId: " + (this.nextPC == null ? "null" : this.nextPC.getContextID()));
        }
        catch (PolicyContextException policyContextException) {
            stringBuffer.append("\nLinked to PolicyConfiguration with contextId: Got an exception attempting to access!");
        }
        String string2 = this.excludedToString();
        if (string2 != null) {
            stringBuffer.append("\n" + string2);
        }
        if ((string = this.uncheckedGrantedToString()) != null) {
            stringBuffer.append("\n" + string);
        }
        stringBuffer.append("\n\n");
        return stringBuffer.toString();
    }
}

