/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.jacc.simpleprovider;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import javax.security.jacc.PolicyContextException;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.management.DomainDir;
import weblogic.management.provider.ManagementService;
import weblogic.security.SecurityLogger;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

class PolicyWriter {
    private static DebugLogger jaccDebugLogger = DebugLogger.getDebugLogger((String)"DebugSecurityJACCNonPolicy");
    private static final String defaultRepository;
    private static final String REPOSITORY = "weblogic.jaccprovider.repository";
    private static final String REPOSITORY_DIR_NAME = "jacc";
    private static String repository;
    private static final AuthenticatedSubject kernelId;

    private PolicyWriter() {
    }

    protected static void createRepositoryDirectory() {
        File file = new File(repository);
        if (!(file = new File(file.getAbsolutePath())).exists()) {
            if (!file.mkdirs()) {
                if (jaccDebugLogger.isDebugEnabled()) {
                    jaccDebugLogger.debug("PolicyWriter unable to create: " + file.toString());
                }
                throw new RuntimeException(SecurityLogger.getUnableToCreatePolicyWriterDirectory((String)file.toString()));
            }
            File file2 = new File(repository);
            if (jaccDebugLogger.isDebugEnabled()) {
                jaccDebugLogger.debug("PolicyWriter created JACC repository directory: " + file.toString());
            }
        } else if (!file.isDirectory()) {
            if (jaccDebugLogger.isDebugEnabled()) {
                jaccDebugLogger.debug("PolicyWriter Cannot create " + file.toString() + ". Non directory file already exists with the same name. Please remove it");
            }
            throw new RuntimeException(SecurityLogger.getFileInTheWayOfDirectory((String)file.toString()));
        }
    }

    protected static void createAppDirectory(String string) {
        if (string == null) {
            if (jaccDebugLogger.isDebugEnabled()) {
                jaccDebugLogger.debug("PolicyWriter Cannot create app directory because a null directory name was passed");
            }
            throw new AssertionError((Object)SecurityLogger.getUnexpectedNullVariable((String)"dirPath"));
        }
        File file = new File(string);
        if (!(file = new File(file.getAbsolutePath())).exists()) {
            if (!file.mkdirs()) {
                if (jaccDebugLogger.isDebugEnabled()) {
                    jaccDebugLogger.debug("PolicyWriter unable to create: " + file.toString());
                }
                throw new RuntimeException(SecurityLogger.getUnableToCreatePolicyWriterDirectory((String)file.toString()));
            }
            File file2 = new File(repository);
            if (jaccDebugLogger.isDebugEnabled()) {
                jaccDebugLogger.debug("PolicyWriter created JACC repository directory: " + file.toString());
            }
        } else {
            String string2;
            File file3;
            if (!file.isDirectory()) {
                if (jaccDebugLogger.isDebugEnabled()) {
                    jaccDebugLogger.debug("PolicyWriter Cannot create " + file.toString() + ". Non directory file already exists with the same name. Please remove it");
                }
                throw new RuntimeException(SecurityLogger.getFileInTheWayOfDirectory((String)file.toString()));
            }
            String string3 = new String(string + File.separator + "granted.policy");
            File file4 = new File(string3);
            if (file4.exists()) {
                if (!file4.delete()) {
                    if (jaccDebugLogger.isDebugEnabled()) {
                        jaccDebugLogger.debug("PolicyWriter.createAppDirectory unable to delete old: " + string3);
                    }
                    throw new RuntimeException("Unable to delete policy file: " + string3);
                }
                if (jaccDebugLogger.isDebugEnabled()) {
                    jaccDebugLogger.debug("PolicyWriter.createAppDirectory removed old " + string3);
                }
            }
            if ((file3 = new File(string2 = new String(string + File.separator + "excluded.policy"))).exists()) {
                if (!file3.delete()) {
                    if (jaccDebugLogger.isDebugEnabled()) {
                        jaccDebugLogger.debug("PolicyWriter.createAppDirectory unable to delete old: " + string2);
                    }
                    throw new RuntimeException("Unable to delete policy file: " + string2);
                }
                if (jaccDebugLogger.isDebugEnabled()) {
                    jaccDebugLogger.debug("PolicyWriter.createAppDirectory removed old " + string2);
                }
            }
        }
    }

    protected static void writeGrantStatements(String string, String string2, String string3) throws PolicyContextException {
        if (string == null) {
            if (jaccDebugLogger.isDebugEnabled()) {
                jaccDebugLogger.debug("PolicyWriter:writeGrantStatements null appDirName");
            }
            return;
        }
        if (string2 == null) {
            if (jaccDebugLogger.isDebugEnabled()) {
                jaccDebugLogger.debug("PolicyWriter:writeGrantStatements null fileType");
            }
            return;
        }
        if (string3 == null) {
            if (jaccDebugLogger.isDebugEnabled()) {
                jaccDebugLogger.debug("PolicyWriter:writeGrantStatements null grantStatements");
            }
            return;
        }
        FileOutputStream fileOutputStream = null;
        String string4 = string + File.separator + string2 + ".policy";
        try {
            fileOutputStream = new FileOutputStream(string4);
            if (jaccDebugLogger.isDebugEnabled()) {
                jaccDebugLogger.debug("PolicyWriter:writeGrantStatements opened: " + string4);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (jaccDebugLogger.isDebugEnabled()) {
                jaccDebugLogger.debug("PolicyWriter:policy file can't be be found (filename may be too long): " + string4 + " " + fileNotFoundException);
            }
            throw new PolicyContextException(SecurityLogger.getCannotOpenPolicyFile((String)string4, (Exception)fileNotFoundException));
        }
        try {
            PolicyWriter.writeStatements(string4, fileOutputStream, string3);
        }
        catch (IOException iOException) {
            if (jaccDebugLogger.isDebugEnabled()) {
                jaccDebugLogger.debug("PolicyWriter:cannot write to policy file: " + string4 + " " + iOException);
            }
            throw new PolicyContextException(SecurityLogger.getCannotWriteToPolicyFile((String)string4, (Exception)iOException));
        }
        finally {
            block22: {
                try {
                    fileOutputStream.close();
                    if (jaccDebugLogger.isDebugEnabled()) {
                        jaccDebugLogger.debug("PolicyWriter:writeGrantStatements closed:" + string4);
                    }
                    fileOutputStream = null;
                }
                catch (IOException iOException) {
                    if (!jaccDebugLogger.isDebugEnabled()) break block22;
                    jaccDebugLogger.debug("PolicyWriter:writeGrantStatements Caught an IOException while trying to close " + string4 + " after an earlier exception.");
                }
            }
        }
    }

    private static void writeStatements(String string, FileOutputStream fileOutputStream, String string2) throws IOException {
        fileOutputStream.write(string2.getBytes());
        if (jaccDebugLogger.isDebugEnabled()) {
            jaccDebugLogger.debug("PolicyWriter:writeStatements wrote to : " + string + " the following grant statements: " + string2);
        }
    }

    protected static String generateAppDirectoryFileName(String string) {
        StringBuffer stringBuffer = new StringBuffer(repository + File.separator + string);
        if (jaccDebugLogger.isDebugEnabled()) {
            jaccDebugLogger.debug("PolicyWriter generated app directory file name: " + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    protected static void deletePolicyFiles(String string) throws IOException {
        if (string == null) {
            return;
        }
        File file = new File(string + File.separator + "excluded.policy");
        URL uRL = file.toURL();
        File file2 = new File(string + File.separator + "granted.policy");
        URL uRL2 = file2.toURL();
        if (file.exists()) {
            file.delete();
            if (jaccDebugLogger.isDebugEnabled()) {
                jaccDebugLogger.debug("PolicyWriter delete removed policy file " + file.getAbsolutePath());
            }
        }
        file2.delete();
        if (jaccDebugLogger.isDebugEnabled()) {
            jaccDebugLogger.debug("PolicyWriter delete removed policy file " + file2.getAbsolutePath());
        }
        PolicyWriter.deleteFile(string);
    }

    protected static void deleteFile(String string) throws IOException {
        if (string == null) {
            return;
        }
        File file = new File(string);
        if (file.exists()) {
            file.delete();
            if (jaccDebugLogger.isDebugEnabled()) {
                jaccDebugLogger.debug("PolicyWriter delete removed file " + file.getAbsolutePath());
            }
        }
    }

    static {
        repository = null;
        kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        defaultRepository = DomainDir.getTempDirForServer((String)ManagementService.getRuntimeAccess(kernelId).getServerName()) + File.separator + REPOSITORY_DIR_NAME;
        repository = System.getProperty(REPOSITORY, defaultRepository);
    }
}

