/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.jacc.simpleprovider;

import java.security.SecurityPermission;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.security.jacc.RoleMapper;
import weblogic.security.jacc.RoleMapperFactory;
import weblogic.security.jacc.simpleprovider.RoleMapperImpl;

public class RoleMapperFactoryImpl
extends RoleMapperFactory {
    private static Map rmMap = new HashMap();
    private static Map acMap = new HashMap();
    private static Map caMap = new HashMap();
    private static DebugLogger jaccDebugLogger = DebugLogger.getDebugLogger((String)"DebugSecurityJACCNonPolicy");

    public RoleMapperFactoryImpl() {
        if (jaccDebugLogger.isDebugEnabled()) {
            jaccDebugLogger.debug("RoleMapperFactoryImpl noarg constructor");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RoleMapper getRoleMapper(String string, boolean bl) {
        if (jaccDebugLogger.isDebugEnabled()) {
            jaccDebugLogger.debug("RoleMapperFactoryImpl.getRoleMapper appID: " + (string == null ? "null" : string) + " remove: " + bl);
        }
        RoleMapperImpl roleMapperImpl = null;
        Map map = rmMap;
        synchronized (map) {
            roleMapperImpl = (RoleMapperImpl)rmMap.get(string);
            if (roleMapperImpl == null) {
                if (jaccDebugLogger.isDebugEnabled()) {
                    jaccDebugLogger.debug("creating a new RoleMapperImpl");
                }
                roleMapperImpl = new RoleMapperImpl(string, this);
                rmMap.put(string, roleMapperImpl);
            } else if (bl) {
                if (jaccDebugLogger.isDebugEnabled()) {
                    jaccDebugLogger.debug("calling delete on the role mapper");
                }
                roleMapperImpl.clear();
            }
        }
        return roleMapperImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RoleMapper getRoleMapper(String string, String string2, boolean bl) {
        if (jaccDebugLogger.isDebugEnabled()) {
            jaccDebugLogger.debug("RoleMapperFactoryImpl.getRoleMapper appID: " + (string == null ? "null" : string) + " contextID: " + (string2 == null ? "null" : string2) + " remove: " + bl);
        }
        RoleMapperImpl roleMapperImpl = null;
        Map map = rmMap;
        synchronized (map) {
            roleMapperImpl = (RoleMapperImpl)rmMap.get(string);
            if (roleMapperImpl == null) {
                if (jaccDebugLogger.isDebugEnabled()) {
                    jaccDebugLogger.debug("creating a new RoleMapperImpl");
                }
                roleMapperImpl = new RoleMapperImpl(string, this);
                rmMap.put(string, roleMapperImpl);
            } else if (bl) {
                if (jaccDebugLogger.isDebugEnabled()) {
                    jaccDebugLogger.debug("calling delete on the role mapper");
                }
                roleMapperImpl.clear();
            }
            if (string2 != null && !string2.equals("")) {
                caMap.put(string2, string);
                ArrayList<String> arrayList = (ArrayList<String>)acMap.get(string);
                if (arrayList == null) {
                    arrayList = new ArrayList<String>(1);
                    if (jaccDebugLogger.isDebugEnabled()) {
                        jaccDebugLogger.debug("creating a new appIDtoContextID map for appID: " + (string == null ? "null" : string) + " and adding contextID: " + (string2 == null ? "null" : string2));
                    }
                    arrayList.add(string2);
                    acMap.put(string, arrayList);
                } else if (!arrayList.contains(string2)) {
                    jaccDebugLogger.debug("adding contextID: " + (string2 == null ? "null" : string2) + " to appID: " + (string == null ? "null" : string));
                    arrayList.add(string2);
                    acMap.put(string, arrayList);
                }
            }
        }
        return roleMapperImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RoleMapper getRoleMapperForContextID(String string) {
        if (jaccDebugLogger.isDebugEnabled()) {
            jaccDebugLogger.debug("RoleMapperFactoryImpl.getRoleMapperForContextID contextID: " + (string == null ? "null" : string));
        }
        RoleMapperImpl roleMapperImpl = null;
        Map map = rmMap;
        synchronized (map) {
            String string2 = (String)caMap.get(string);
            if (string2 == null) {
                if (jaccDebugLogger.isDebugEnabled()) {
                    jaccDebugLogger.debug("RoleMapperImpl for appID: " + (string2 == null ? "null" : string2) + " does not have a map from ContextID: " + (string == null ? "null" : string));
                }
            } else {
                roleMapperImpl = (RoleMapperImpl)rmMap.get(string2);
                if (roleMapperImpl == null && jaccDebugLogger.isDebugEnabled()) {
                    jaccDebugLogger.debug("RoleMapperImpl for appID: " + (string2 == null ? "null" : string2) + " does not exist");
                }
            }
        }
        return roleMapperImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRoleMapper(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SecurityPermission("setPolicy"));
        }
        Map map = rmMap;
        synchronized (map) {
            if (jaccDebugLogger.isDebugEnabled()) {
                jaccDebugLogger.debug("RoleMapperFactoryImpl.getRoleMapper removing the RoleMapper for appID: " + (string == null ? "null" : string));
            }
            rmMap.remove(string);
            String[] stringArray = (String[])((ArrayList)acMap.get(string)).toArray();
            if (jaccDebugLogger.isDebugEnabled() && stringArray.length > 0) {
                jaccDebugLogger.debug("RoleMapperFactoryImpl.getRoleMapper removing mapping of contextIDs to appID: " + (string == null ? "null" : string));
            }
            for (int i = 0; i < stringArray.length; ++i) {
                caMap.remove(stringArray[i]);
            }
            if (jaccDebugLogger.isDebugEnabled()) {
                jaccDebugLogger.debug("RoleMapperFactoryImpl.getRoleMapper removing the mapping from appID: " + (string == null ? "null" : string) + " to contextIDs");
            }
            acMap.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getAppId(String string) {
        String string2 = null;
        Map map = caMap;
        synchronized (map) {
            string2 = (String)caMap.get(string);
        }
        if (jaccDebugLogger.isDebugEnabled()) {
            jaccDebugLogger.debug("RoleMapperFactoryImpl.getAppID contextID: " + (string == null ? "null" : string) + " maps to appID: " + (string2 == null ? "null" : string2));
        }
        return string2;
    }
}

