/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.jacc.simpleprovider;

import java.security.SecurityPermission;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.security.SecurityLogger;
import weblogic.security.jacc.RoleMapper;
import weblogic.security.jacc.simpleprovider.RoleMapperFactoryImpl;

public class RoleMapperImpl
implements RoleMapper {
    private static DebugLogger jaccDebugLogger = DebugLogger.getDebugLogger((String)"DebugSecurityJACCNonPolicy");
    private RoleMapperFactoryImpl rmFactoryImpl;
    private String contextId;
    private String contextIdNoNPE;
    private Map rolesToPrincipalNames;
    private boolean policyChanged = false;

    public RoleMapperImpl(String string, RoleMapperFactoryImpl roleMapperFactoryImpl) {
        this.rmFactoryImpl = roleMapperFactoryImpl;
        this.contextId = string;
        this.rolesToPrincipalNames = new HashMap();
        String string2 = this.contextIdNoNPE = this.contextId == null ? "null" : this.contextId;
        if (jaccDebugLogger.isDebugEnabled()) {
            jaccDebugLogger.debug("RoleMapperImpl constructor contextId: " + this.contextIdNoNPE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAppRolesToPrincipalMap(Map map) throws IllegalArgumentException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SecurityPermission("setPolicy"));
        }
        if (map == null || map.isEmpty()) {
            if (jaccDebugLogger.isDebugEnabled()) {
                jaccDebugLogger.debug("RoleMapperImpl: addAppRolesToPrincipalMap contextId: " + this.contextIdNoNPE + " map is null or empty.");
            }
            return;
        }
        try {
            Object object = this.rolesToPrincipalNames;
            synchronized (object) {
                if (jaccDebugLogger.isDebugEnabled()) {
                    jaccDebugLogger.debug("RoleMapperImpl: addAppRolesToPrincipalMap contextId: " + this.contextIdNoNPE + " map has " + map.size() + " roles in it.");
                }
                if (this.rolesToPrincipalNames == null || this.rolesToPrincipalNames.isEmpty()) {
                    this.rolesToPrincipalNames = new HashMap(map);
                    if (jaccDebugLogger.isDebugEnabled()) {
                        jaccDebugLogger.debug("RoleMapperImpl: addAppRolesToPrincipalMap contextId: " + this.contextIdNoNPE + " created new map.");
                    }
                } else {
                    this.rolesToPrincipalNames = RoleMapperImpl.mergeMap(this.rolesToPrincipalNames, map);
                    if (jaccDebugLogger.isDebugEnabled()) {
                        jaccDebugLogger.debug("RoleMapperImpl: addAppRolesToPrincipalMap contextId: " + this.contextIdNoNPE + " map merged with existing role to pricipal names map.");
                    }
                }
                this.policyChanged = true;
            }
            object = this.rolesToPrincipalNames.keySet();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                String[] stringArray;
                String string;
                String string2 = (String)iterator.next();
                String string3 = string = string2 == null ? "null" : string2;
                if (jaccDebugLogger.isDebugEnabled()) {
                    jaccDebugLogger.debug("RoleMapperImpl: addAppRolesToPrincipalMap roleName: " + string);
                }
                if ((stringArray = (String[])this.rolesToPrincipalNames.get(string2)) == null || stringArray.length == 0) {
                    if (!jaccDebugLogger.isDebugEnabled()) continue;
                    jaccDebugLogger.debug("RoleMapperImpl: addAppRolesToPrincipalMap contextId: " + this.contextIdNoNPE + " roleName: " + string2 + " no user or group names");
                    continue;
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!jaccDebugLogger.isDebugEnabled()) continue;
                    jaccDebugLogger.debug("RoleMapperImpl: addAppRolesToPrincipalMap contextId: " + this.contextIdNoNPE + " roleName: " + string2 + " user/group name: " + (stringArray[i] != null ? stringArray[i] : "null"));
                }
            }
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(SecurityLogger.getBadRoleToPrincipalMap((Exception)exception, (String)this.contextId));
        }
    }

    public synchronized Map getRolesToPrincipalNames() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SecurityPermission("setPolicy"));
        }
        if (jaccDebugLogger.isDebugEnabled()) {
            jaccDebugLogger.debug("RoleMapperImpl: getRolesToPrincipalNames contextId: " + this.contextIdNoNPE + " map has " + this.rolesToPrincipalNames.size() + " roles in it.");
        }
        return new HashMap(this.rolesToPrincipalNames);
    }

    synchronized void clear() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SecurityPermission("setPolicy"));
        }
        if (jaccDebugLogger.isDebugEnabled()) {
            jaccDebugLogger.debug("RoleMapperImpl: clear contextId: " + this.contextIdNoNPE);
        }
        this.rolesToPrincipalNames = new HashMap();
    }

    private static HashMap mergeMap(Map map, Map map2) {
        Set set = map2.keySet();
        for (String string : set) {
            if (!map.containsKey(string)) {
                map.put(string, map2.get(string));
                continue;
            }
            String[] stringArray = (String[])map.get(string);
            String[] stringArray2 = (String[])map2.get(string);
            String[] stringArray3 = RoleMapperImpl.mergeArray(stringArray2, stringArray);
            map.put(string, stringArray3);
        }
        return new HashMap(map);
    }

    private static String[] mergeArray(String[] stringArray, String[] stringArray2) {
        int n;
        int n2 = 0;
        int n3 = 0;
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length + stringArray2.length);
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n] == null) continue;
            ++n2;
            arrayList.add(stringArray[n]);
        }
        for (n = 0; n < stringArray2.length; ++n) {
            if (stringArray2[n] == null) continue;
            ++n3;
            arrayList.add(stringArray2[n]);
        }
        arrayList.trimToSize();
        TreeSet treeSet = new TreeSet(arrayList);
        String[] stringArray3 = treeSet.toArray(new String[treeSet.size()]);
        return stringArray3;
    }
}

