/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.jacc.simpleprovider;

import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.Enumeration;
import javax.security.jacc.PolicyContext;
import sun.security.provider.PolicyFile;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.security.jacc.simpleprovider.PolicyConfigurationFactoryImpl;
import weblogic.security.jacc.simpleprovider.PolicyConfigurationImpl;

public final class SimpleJACCPolicy
extends Policy {
    private PolicyFile defaultPolicy;
    private static DebugLogger jaccDebugLogger = DebugLogger.getDebugLogger((String)"DebugSecurityJACCPolicy");

    public SimpleJACCPolicy() {
        if (jaccDebugLogger.isDebugEnabled()) {
            this.log("SimpleJACCPolicy no arg constructor");
        }
        this.defaultPolicy = new PolicyFile();
    }

    public PermissionCollection getPermissions(CodeSource codeSource) {
        PermissionCollection permissionCollection = null;
        PolicyFile policyFile = null;
        String string = PolicyContext.getContextID();
        policyFile = this.getPolicyConfigurationPolicyForContext(string);
        PermissionCollection permissionCollection2 = policyFile.getPermissions(codeSource);
        permissionCollection = this.removeExcludedPermissions(string, permissionCollection2);
        return permissionCollection;
    }

    public PermissionCollection getPermissions(ProtectionDomain protectionDomain) {
        PermissionCollection permissionCollection = null;
        PolicyFile policyFile = null;
        String string = PolicyContext.getContextID();
        policyFile = this.getPolicyConfigurationPolicyForContext(string);
        PermissionCollection permissionCollection2 = policyFile.getPermissions(protectionDomain);
        permissionCollection = this.removeExcludedPermissions(string, permissionCollection2);
        return permissionCollection;
    }

    public boolean implies(ProtectionDomain protectionDomain, Permission permission) {
        if (jaccDebugLogger.isDebugEnabled()) {
            this.log("SimpleJACCPolicy.implies " + permission);
        }
        String string = PolicyContext.getContextID();
        PolicyFile policyFile = this.getPolicyConfigurationPolicyForContext(string);
        Permissions permissions = this.getExcludedPermissionsForContext(string);
        boolean bl = policyFile.implies(protectionDomain, permission);
        if (jaccDebugLogger.isDebugEnabled()) {
            this.log("SimpleJACCPolicy.implies " + (!bl ? "denied " : "granted") + " policy: " + (policyFile == this.defaultPolicy ? "default" : (string == null ? " null" : string)) + " " + permission);
        }
        if (bl && permissions != null) {
            if (this.shouldExclude(permission, permissions)) {
                bl = false;
            }
            if (jaccDebugLogger.isDebugEnabled()) {
                this.log("SimpleJACCPolicy.implies " + (!bl ? "denied " : "granted") + permission + " after applying excluded Permissions");
            }
        }
        return bl;
    }

    public void refresh() {
        if (jaccDebugLogger.isDebugEnabled()) {
            this.log("SimpleJACCPolicy.refresh");
        }
        this.defaultPolicy.refresh();
        Collection collection = PolicyConfigurationFactoryImpl.getPolicyConfigurationImpls();
        if (collection != null) {
            for (PolicyConfigurationImpl policyConfigurationImpl : collection) {
                if (policyConfigurationImpl == null) continue;
                policyConfigurationImpl.refresh();
            }
        }
    }

    private PolicyFile getPolicyConfigurationPolicyForContext(String string) {
        PolicyConfigurationImpl policyConfigurationImpl;
        PolicyFile policyFile = null;
        if (string != null && (policyConfigurationImpl = PolicyConfigurationFactoryImpl.getPolicyConfigurationImpl(string)) != null) {
            policyFile = policyConfigurationImpl.getPolicy();
        }
        if (policyFile == null) {
            policyFile = this.defaultPolicy;
        }
        return policyFile;
    }

    private Permissions getExcludedPermissionsForContext(String string) {
        PolicyConfigurationImpl policyConfigurationImpl;
        Permissions permissions = null;
        if (string != null && (policyConfigurationImpl = PolicyConfigurationFactoryImpl.getPolicyConfigurationImpl(string)) != null) {
            permissions = policyConfigurationImpl.getExcludedPermissions();
        }
        return permissions;
    }

    private PermissionCollection removeExcludedPermissions(String string, PermissionCollection permissionCollection) {
        boolean bl = false;
        Permissions permissions = this.getExcludedPermissionsForContext(string);
        PermissionCollection permissionCollection2 = null;
        Permission permission = null;
        if (permissions != null && permissions.elements().hasMoreElements()) {
            Enumeration<Permission> enumeration = permissionCollection.elements();
            while (enumeration.hasMoreElements()) {
                permission = enumeration.nextElement();
                if (!this.shouldExclude(permission, permissions)) {
                    if (permissionCollection2 == null) {
                        permissionCollection2 = new Permissions();
                    }
                    permissionCollection2.add(permission);
                    continue;
                }
                bl = true;
            }
        }
        if (!bl) {
            permissionCollection2 = permissionCollection;
        }
        return permissionCollection2;
    }

    private boolean shouldExclude(Permission permission, Permissions permissions) {
        boolean bl = false;
        if (permissions != null && permissions.elements().hasMoreElements()) {
            if (!permissions.implies(permission)) {
                Enumeration<Permission> enumeration = permissions.elements();
                while (enumeration.hasMoreElements() || bl) {
                    Permission permission2 = enumeration.nextElement();
                    if (!permission.implies(permission2)) continue;
                    bl = true;
                    this.log("SimpleJACCPolicy excluding granted: " + permission + " implies: " + permission2);
                    break;
                }
            } else {
                bl = true;
                this.log("SimpleJACCPolicy excluding excludedPermissions implies: " + permission);
            }
        }
        return bl;
    }

    private void log(String string) {
        System.out.println(string);
    }
}

