/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.ldaprealmv1;

import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.CommunicationException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NamingSecurityException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import weblogic.logging.LogOutputStream;
import weblogic.management.configuration.LDAPRealmMBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.SecurityLogger;
import weblogic.security.acl.ClosableEnumeration;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.ldaprealmv1.LDAPException;
import weblogic.security.ldaprealmv1.LDAPGroup;
import weblogic.security.ldaprealmv1.LDAPRealm;
import weblogic.security.ldaprealmv1.LDAPUser;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.utils.Factory;
import weblogic.security.utils.Pool;
import weblogic.utils.encoders.BASE64Encoder;
import weblogic.utils.enumerations.EnumerationUtils;

class LDAPDelegate {
    private static final int POOL_SIZE = 6;
    private static String url;
    private static String auth;
    private static boolean ssl;
    private static String factory;
    private static final AuthenticatedSubject kernelId;
    private static String userDN;
    private static String ndresu;
    private static String userNameAttr;
    private static String userPwdAttr;
    private static boolean authUsingBind;
    private static String groupDN;
    private static String groupNameAttr;
    private static String groupUserAttr;
    private static boolean groupIsContext;
    private Pool ctxPool;
    private LDAPRealm owner;
    LogOutputStream log;

    static Properties configureProps() {
        LDAPRealmMBean lDAPRealmMBean = (LDAPRealmMBean)ManagementService.getRuntimeAccess(kernelId).getDomain().getSecurity().getRealm().getCachingRealm().getBasicRealm();
        url = lDAPRealmMBean.getLDAPURL();
        auth = lDAPRealmMBean.getAuthProtocol();
        ssl = lDAPRealmMBean.getSSLEnable();
        factory = lDAPRealmMBean.getLdapProvider();
        userDN = lDAPRealmMBean.getUserDN();
        userNameAttr = lDAPRealmMBean.getUserNameAttribute();
        ndresu = LDAPDelegate.reverseDN(userDN);
        String string = lDAPRealmMBean.getUserAuthentication();
        if (string.equals("local")) {
            userPwdAttr = lDAPRealmMBean.getUserPasswordAttribute();
            authUsingBind = false;
        } else if (string.equals("bind")) {
            authUsingBind = true;
        } else {
            throw new LDAPException("invalid user authentication mechanism \"" + string + "\"");
        }
        groupDN = lDAPRealmMBean.getGroupDN();
        groupNameAttr = lDAPRealmMBean.getGroupNameAttribute();
        groupUserAttr = lDAPRealmMBean.getGroupUsernameAttribute();
        groupIsContext = lDAPRealmMBean.getGroupIsContext();
        if (auth.equals("none")) {
            return LDAPDelegate.makeProperties();
        }
        if (auth.equals("EXTERNAL")) {
            if (!ssl) {
                throw new LDAPException("must use SSL if specifying external authentication");
            }
            return LDAPDelegate.makeProperties();
        }
        if (auth.equals("simple") || auth.equals("CRAM-MD5")) {
            String string2 = lDAPRealmMBean.getPrincipal();
            String string3 = lDAPRealmMBean.getCredential();
            return LDAPDelegate.makeProperties(string2, string3);
        }
        throw new LDAPException("authentication mechanism \"" + auth + "\" is unknown or unsupported");
    }

    private static String reverseDN(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            vector.insertElementAt(stringTokenizer.nextToken().trim(), 0);
        }
        return EnumerationUtils.toString(vector.elements(), (String)",");
    }

    private static Properties makeProperties() {
        Properties properties = new Properties();
        properties.put("java.naming.security.authentication", auth);
        properties.put("java.naming.factory.initial", factory);
        properties.put("java.naming.provider.url", url);
        if (ssl) {
            properties.put("java.naming.ldap.factory.socket", "weblogic.security.SSL.SSLSocketFactory");
        }
        return properties;
    }

    private static Properties makeProperties(String string, Object object) {
        Properties properties = LDAPDelegate.makeProperties();
        if (string == null || object == null) {
            throw new LDAPException("missing properties for simple authentication");
        }
        properties.put("java.naming.security.principal", string);
        properties.put("java.naming.security.credentials", object);
        return properties;
    }

    LDAPDelegate(LDAPRealm lDAPRealm) {
        this.owner = lDAPRealm;
        this.log = lDAPRealm.log;
        this.ctxPool = new Pool((Factory)new DFactory(LDAPDelegate.configureProps(), this), 6);
    }

    private DirContext getContext() {
        try {
            return (DirContext)this.ctxPool.getInstance();
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new LDAPException("could not get context", invocationTargetException);
        }
    }

    private void returnContext(DirContext dirContext) {
        if (dirContext != null) {
            this.ctxPool.returnInstance((Object)dirContext);
        }
    }

    private DirContext lookup(String string) throws NamingException {
        if (this.log != null) {
            this.log.debug("lookup(\"" + string + "\")");
        }
        DirContext dirContext = this.getContext();
        try {
            DirContext dirContext2;
            String string2 = LDAPDelegate.reverseDN(string);
            DirContext dirContext3 = dirContext2 = (DirContext)dirContext.lookup(string2);
            return dirContext3;
        }
        catch (CommunicationException communicationException) {
            dirContext = null;
            throw new LDAPException("communication failed", communicationException);
        }
        finally {
            this.returnContext(dirContext);
        }
    }

    private Stack reverseMatchDNs(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        StringTokenizer stringTokenizer2 = new StringTokenizer(string, ",");
        Stack<String> stack = new Stack<String>();
        while (stringTokenizer2.hasMoreTokens()) {
            stack.push(stringTokenizer2.nextToken().trim());
        }
        while (stringTokenizer.hasMoreTokens() && !stack.empty()) {
            String string3 = stringTokenizer.nextToken().trim();
            String string4 = (String)stack.pop();
            if (string4.equalsIgnoreCase(string3)) continue;
            return null;
        }
        return stringTokenizer.hasMoreTokens() ? null : stack;
    }

    private String getAttributeFromDN(String string, Stack stack) {
        int n;
        String string2 = (String)stack.pop();
        if (!stack.empty()) {
            String string3 = "unexpectedly long DN: " + string2;
            while (!stack.empty() && string3.length() < 128) {
                string3 = string3 + ", " + (String)stack.pop();
            }
            throw new LDAPException(string3);
        }
        String string4 = string + "=";
        if (!string2.regionMatches(true, 0, string4, 0, n = string4.length())) {
            String string5 = "unexpected DN head \"" + string2 + "\" on DN: " + string2;
            while (!stack.empty() && string5.length() < 128) {
                string5 = string5 + ", " + (String)stack.pop();
            }
            throw new LDAPException(string5);
        }
        return string2.substring(n);
    }

    private NamingEnumeration search(String string, String string2, String string3) throws NamingException {
        if (this.log != null) {
            this.log.debug("search(\"" + string + "\", \"" + string2 + "\", \"" + string3 + "\")");
        }
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(1);
        DirContext dirContext = this.lookup(string);
        return dirContext.search("", "(" + string2 + "=" + string3 + ")", searchControls);
    }

    private NamingEnumeration search(String string, String string2) throws NamingException {
        return this.search(string, string2, "*");
    }

    private Attributes getUserAttrs(String string) {
        try {
            DirContext dirContext = this.lookup(userDN);
            if (dirContext == null) {
                if (this.log != null) {
                    this.log.debug("user: UNPERSON " + string);
                }
                return null;
            }
            return dirContext.getAttributes(userNameAttr + "=" + string);
        }
        catch (NameNotFoundException nameNotFoundException) {
            if (this.log != null) {
                this.log.debug("user: UNPERSON " + string);
            }
            return null;
        }
        catch (NamingException namingException) {
            throw new LDAPException("search error: user " + string, namingException);
        }
    }

    boolean userExists(String string) {
        return this.getUserAttrs(string) != null;
    }

    boolean authenticate(String string, String string2) {
        return authUsingBind ? this.authBind(string, string2) : this.authLocal(string, string2);
    }

    private boolean authBind(String string, String string2) {
        String string3 = userNameAttr + "=" + string + "," + ndresu;
        Properties properties = LDAPDelegate.makeProperties(string3, string2);
        InitialDirContext initialDirContext = null;
        try {
            initialDirContext = new InitialDirContext(properties);
        }
        catch (NamingSecurityException namingSecurityException) {
            boolean bl = false;
            return bl;
        }
        catch (NamingException namingException) {
            throw new LDAPException("unexpected naming exception", namingException);
        }
        finally {
            if (initialDirContext != null) {
                try {
                    initialDirContext.close();
                }
                catch (NamingException namingException) {}
            }
        }
        return true;
    }

    private boolean authLocal(String string, String string2) {
        Attributes attributes = this.getUserAttrs(string);
        if (attributes == null) {
            if (this.log != null) {
                this.log.debug("auth: UNPERSON " + string);
            }
            return false;
        }
        Attribute attribute = attributes.get(userPwdAttr);
        if (attribute == null) {
            throw new SecurityException("no password found for " + string);
        }
        String string3 = null;
        try {
            string3 = new String((byte[])attribute.get()).trim();
        }
        catch (NamingException namingException) {
            throw new LDAPException("password get failed", namingException);
        }
        Attribute attribute2 = attributes.get(userNameAttr);
        try {
            return string.equals(((String)attribute2.get()).trim()) && this.checkPassword(string3, string2);
        }
        catch (NamingException namingException) {
            return false;
        }
    }

    protected boolean checkPassword(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        int n = string.indexOf("}");
        if (string.charAt(0) == '{' && n > 0) {
            String string3 = string.substring(1, n);
            String string4 = this.hash(string3, string2);
            String string5 = string.substring(n + 1);
            return string5.equals(string4);
        }
        return string.equals(string2);
    }

    protected String hash(String string, String string2) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(string.toUpperCase(Locale.ENGLISH));
            BASE64Encoder bASE64Encoder = new BASE64Encoder();
            return bASE64Encoder.encodeBuffer(messageDigest.digest(string2.getBytes()));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return new String(string2);
        }
    }

    Group getGroup(String string) {
        return this.getGroup(string, new Stack());
    }

    public Hashtable getGroupMembers(String string) {
        return this.getGroupMembers(string, new Stack());
    }

    Group getGroup(String string, Stack stack) {
        Hashtable hashtable = this.getGroupMembers(string, stack);
        return hashtable != null ? new LDAPGroup(string, this.owner, hashtable) : null;
    }

    Hashtable getGroupMembers(String string, Stack stack) {
        Hashtable hashtable = new Hashtable();
        try {
            if (groupIsContext) {
                NamingEnumeration namingEnumeration = this.search(groupDN + ", " + groupNameAttr + "=" + string, groupNameAttr);
                if (namingEnumeration == null) {
                    if (this.log != null) {
                        this.log.debug("group: UNGROUP " + string);
                    }
                    return null;
                }
                while (namingEnumeration.hasMore()) {
                    SearchResult searchResult = (SearchResult)namingEnumeration.next();
                    Attribute attribute = searchResult.getAttributes().get(groupUserAttr);
                    if (attribute == null) continue;
                    this.addGroupMember(string, ((String)attribute.get()).trim(), hashtable, stack);
                }
            } else {
                NamingEnumeration<?> namingEnumeration;
                DirContext dirContext = this.lookup(groupDN);
                Attributes attributes = dirContext.getAttributes(groupNameAttr + "=" + string);
                Attribute attribute = attributes.get(groupUserAttr);
                if (attribute != null && (namingEnumeration = attribute.getAll()) != null) {
                    while (namingEnumeration.hasMore()) {
                        this.addGroupMember(string, (String)namingEnumeration.next(), hashtable, stack);
                    }
                }
            }
        }
        catch (NameNotFoundException nameNotFoundException) {
            if (this.log != null) {
                this.log.debug("group: UNGROUP " + string);
            }
            return null;
        }
        catch (NamingException namingException) {
            throw new LDAPException("group lookup failed", namingException);
        }
        if (this.log != null) {
            this.log.debug("group: FOUND " + string);
        }
        return hashtable;
    }

    private void addGroupMember(String string, String string2, Hashtable hashtable, Stack stack) {
        Stack stack2 = this.reverseMatchDNs(string2, userDN);
        if (stack2 != null) {
            String string3 = this.getAttributeFromDN(userNameAttr, stack2);
            hashtable.put(string3, new LDAPUser(string3, this.owner));
        } else {
            stack2 = this.reverseMatchDNs(string2, groupDN);
            if (stack2 == null) {
                return;
            }
            String string4 = this.getAttributeFromDN(groupNameAttr, stack2);
            stack.push(string);
            if (stack.contains(string4)) {
                if (this.log != null) {
                    SecurityLogger.logUnsupportedCircularGroup((String)string4);
                }
                StringBuffer stringBuffer = new StringBuffer("unsupported circular group definition: ");
                stringBuffer.append(string4);
                while (!stack.empty()) {
                    stringBuffer.append(" -> " + stack.pop());
                }
                throw new LDAPException(stringBuffer.toString());
            }
            hashtable.put(string4, this.getGroup(string4, stack));
            stack.pop();
        }
    }

    Enumeration getGroups() {
        try {
            NamingEnumeration namingEnumeration = this.search(groupDN, groupNameAttr);
            if (namingEnumeration == null) {
                throw new LDAPException("could not get group list");
            }
            return new LDAPEnumeration(namingEnumeration, new LDAPNextHandler(){

                public Object handle(Object object) throws NamingException {
                    SearchResult searchResult = (SearchResult)object;
                    Attributes attributes = searchResult.getAttributes();
                    String string = ((String)attributes.get(groupNameAttr).get()).trim();
                    return new LDAPGroup(string, LDAPDelegate.this.owner);
                }
            });
        }
        catch (NamingException namingException) {
            throw new LDAPException("could not get group list", namingException);
        }
    }

    Enumeration getUsers() {
        try {
            NamingEnumeration namingEnumeration = this.search(userDN, userNameAttr);
            if (namingEnumeration == null) {
                throw new LDAPException("could not get user list");
            }
            return new LDAPEnumeration(namingEnumeration, new LDAPNextHandler(){

                public Object handle(Object object) throws NamingException {
                    SearchResult searchResult = (SearchResult)object;
                    Attributes attributes = searchResult.getAttributes();
                    String string = ((String)attributes.get(userNameAttr).get()).trim();
                    return new LDAPUser(string, LDAPDelegate.this.owner);
                }
            });
        }
        catch (NamingException namingException) {
            throw new LDAPException("could not get user list", namingException);
        }
    }

    void close() {
        this.ctxPool.close();
        this.ctxPool = null;
    }

    public void setDebugLog(LogOutputStream logOutputStream) {
        this.log = logOutputStream;
    }

    public LogOutputStream getDebugLog() {
        return this.log;
    }

    static {
        kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    }

    private class LDAPEnumeration
    implements ClosableEnumeration {
        boolean closed = false;
        NamingEnumeration list;
        LDAPNextHandler handler;

        LDAPEnumeration(NamingEnumeration namingEnumeration, LDAPNextHandler lDAPNextHandler) {
            this.list = namingEnumeration;
            this.handler = lDAPNextHandler;
        }

        public boolean hasMoreElements() {
            if (this.closed) {
                return false;
            }
            try {
                if (this.list.hasMore()) {
                    return true;
                }
                this.close();
                return false;
            }
            catch (NamingException namingException) {
                throw new LDAPException("LDAPEnumeration.hasMoreElements failed", namingException);
            }
        }

        public Object nextElement() {
            if (this.closed) {
                throw new NoSuchElementException("LDAPEnumeration.nextElement");
            }
            try {
                Object object = this.handler.handle(this.list.next());
                if (!this.list.hasMore()) {
                    this.close();
                }
                return object;
            }
            catch (NamingException namingException) {
                throw new LDAPException("LDAPEnumeration.nextElement failed", namingException);
            }
        }

        public void close() {
            if (this.closed) {
                return;
            }
            try {
                this.closed = true;
                this.list.close();
            }
            catch (NamingException namingException) {
                throw new LDAPException("LDAPEnumeration.close failed", namingException);
            }
        }
    }

    private static interface LDAPNextHandler {
        public Object handle(Object var1) throws NamingException;
    }

    static class DFactory
    implements Factory {
        private Properties props;
        private LDAPDelegate owner;

        DFactory(Properties properties, LDAPDelegate lDAPDelegate) {
            this.props = properties;
            this.owner = lDAPDelegate;
        }

        public Object newInstance() throws InvocationTargetException {
            try {
                if (this.owner.log != null) {
                    this.owner.log.debug("new JNDI context");
                }
                return new InitialDirContext(this.props);
            }
            catch (NamingException namingException) {
                throw new InvocationTargetException(namingException);
            }
        }

        public void destroyInstance(Object object) {
            try {
                if (this.owner.log != null) {
                    this.owner.log.debug("destroy JNDI context");
                }
                ((DirContext)object).close();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
    }
}

