/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.ldaprealmv1;

import java.security.AccessController;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.Hashtable;
import weblogic.logging.LogOutputStream;
import weblogic.management.configuration.LDAPRealmMBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.SecurityLogger;
import weblogic.security.acl.AbstractListableRealm;
import weblogic.security.acl.DebuggableRealm;
import weblogic.security.acl.User;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.ldaprealmv1.LDAPDelegate;
import weblogic.security.ldaprealmv1.LDAPUser;
import weblogic.security.service.PrivilegedActions;

public final class LDAPRealm
extends AbstractListableRealm
implements DebuggableRealm,
weblogic.security.ldaprealm.LDAPRealm {
    private static final int POOL_SIZE = 8;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private LDAPDelegate delegate = new LDAPDelegate(this);
    LogOutputStream log;

    public LDAPRealm() {
        super("LDAP Realm");
        LDAPRealmMBean lDAPRealmMBean = (LDAPRealmMBean)ManagementService.getRuntimeAccess(kernelId).getDomain().getSecurity().getRealm().getCachingRealm().getBasicRealm();
        this.setDebug(ManagementService.getRuntimeAccess(kernelId).getServer().getServerDebug().getDebugSecurityRealm());
        SecurityLogger.logLDAPRealmV1DeprecatedWarning();
    }

    public User getUser(String string) {
        if (this.log != null) {
            this.log.debug("getUser(\"" + string + "\")");
        }
        return this.delegate.userExists(string) ? new LDAPUser(string, this) : null;
    }

    protected User authUserPassword(String string, String string2) {
        if (this.log != null) {
            this.log.debug("authUserPassword(\"" + string + "\")");
        }
        return this.delegate.authenticate(string, string2) ? new LDAPUser(string, this) : null;
    }

    public Group getGroup(String string) {
        if (this.log != null) {
            this.log.debug("getGroup(\"" + string + "\")");
        }
        return this.delegate.getGroup(string);
    }

    protected Hashtable getGroupMembersInternal(String string) {
        return this.delegate.getGroupMembers(string);
    }

    public Enumeration getUsers() {
        if (this.log != null) {
            this.log.debug("getUsers()");
        }
        return this.delegate.getUsers();
    }

    public Enumeration getGroups() {
        if (this.log != null) {
            this.log.debug("getGroups()");
        }
        return this.delegate.getGroups();
    }

    public void setDebug(boolean bl) {
        if (bl && this.log == null) {
            this.log = new LogOutputStream("LDAPRealm");
        }
        if (!bl) {
            this.log = null;
        }
        this.delegate.setDebugLog(this.log);
    }

    public LogOutputStream getDebugLog() {
        return this.log;
    }
}

