/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.ldaprealmv2;

import com.oroinc.text.regex.MalformedPatternException;
import com.oroinc.text.regex.MatchResult;
import com.oroinc.text.regex.Pattern;
import com.oroinc.text.regex.PatternMatcherInput;
import com.oroinc.text.regex.Perl5Compiler;
import com.oroinc.text.regex.Perl5Matcher;
import java.lang.reflect.InvocationTargetException;
import java.net.Socket;
import java.security.AccessController;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.Stack;
import java.util.Vector;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPCache;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPDN;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.LDAPSocketFactory;
import weblogic.logging.LogOutputStream;
import weblogic.management.configuration.CachingRealmMBean;
import weblogic.management.configuration.CustomRealmMBean;
import weblogic.management.configuration.RealmMBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.ldaprealmv2.LDAPEntity;
import weblogic.security.ldaprealmv2.LDAPGroup;
import weblogic.security.ldaprealmv2.LDAPRealm;
import weblogic.security.ldaprealmv2.LDAPRealmException;
import weblogic.security.ldaprealmv2.LDAPUser;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.utils.Factory;
import weblogic.security.utils.Pool;
import weblogic.security.utils.SSLContextManager;
import weblogic.utils.enumerations.MappingEnumerator;
import weblogic.utils.enumerations.SequencingEnumerator;

class LDAPDelegate {
    private static final int LDAP_VERSION = 3;
    private static final int POOL_SIZE = 6;
    private static final String LDAP_PREFIX = "";
    private static final int DEFAULT_SSL_PORT = 636;
    private static final int DEFAULT_CACHE_TTL = 60;
    private static final int DEFAULT_CACHE_SIZE = 32;
    private static final int MAX_RESULTS_ENUM = 100;
    private static boolean useSSL;
    private static String serverHost;
    private static int serverPort;
    private static int cacheTTL;
    private static int cacheSize;
    private static String serverPrincipal;
    private static String serverCredential;
    private static final String[] USER_ATTRS;
    private static String[] userBaseDNs;
    private static int[] userScopes;
    private static String[] userFilters;
    private static String[][] userNameAttributes;
    private static LDAPSearchConstraints userConstraints;
    private static LDAPSearchConstraints getUserConstraints;
    private static final String[] GROUP_ATTRS;
    private static String[] groupBaseDNs;
    private static int[] groupScopes;
    private static String[] groupFilters;
    private static String[][] groupNameAttributes;
    private static LDAPSearchConstraints groupConstraints;
    private static LDAPSearchConstraints getGroupConstraints;
    private static final String[] MEMBER_ATTRS;
    private static int[] memberScopes;
    private static String[] memberFilters;
    private static String[][] memberAttributes;
    private static boolean membershipSearch;
    private static boolean directMembershipOnly;
    private static int groupScopeDepth;
    private static LDAPSearchConstraints memberConstraints;
    private static boolean allowEnumeration;
    private Pool connPool;
    private LDAPRealm owner;
    LogOutputStream log;
    private static boolean caseSensitive;
    private static final boolean membershipDebug = false;
    private static LDAPSocketFactory boxOfSocks;

    private static void setupProperties() {
        int n;
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        RealmMBean realmMBean = ManagementService.getRuntimeAccess(authenticatedSubject).getDomain().getSecurity().getRealm();
        allowEnumeration = realmMBean.isEnumerationAllowed();
        CachingRealmMBean cachingRealmMBean = realmMBean.getCachingRealm();
        caseSensitive = cachingRealmMBean.getCacheCaseSensitive();
        Properties properties = null;
        CustomRealmMBean customRealmMBean = (CustomRealmMBean)cachingRealmMBean.getBasicRealm();
        properties = customRealmMBean.getConfigurationData();
        String string = null;
        String string2 = properties.getProperty("server.alias");
        string = string2 == null ? LDAP_PREFIX : string2 + ".";
        serverHost = properties.getProperty(string + "server.host", "ldapserver");
        useSSL = LDAPDelegate.getBoolean(properties, string + "useSSL", false);
        serverPort = LDAPDelegate.getInteger(properties, string + "server.port", useSSL ? 636 : 389);
        cacheTTL = LDAPDelegate.getInteger(properties, string + "cache.ttl", 60);
        cacheSize = LDAPDelegate.getInteger(properties, string + "cache.size", 32);
        membershipSearch = LDAPDelegate.getBoolean(properties, string + "membership.search", false);
        directMembershipOnly = LDAPDelegate.getBoolean(properties, string + "membership.directmembershiponly", false);
        directMembershipOnly = LDAPDelegate.getBoolean(properties, string + "membership.directmembershiponly", false);
        serverPrincipal = properties.getProperty(string + "server.principal");
        serverCredential = customRealmMBean.getPassword();
        if (serverCredential == null) {
            serverCredential = properties.getProperty(string + "server.credential");
        }
        if ((userBaseDNs = LDAPDelegate.getProperties(properties, string + "user.dn")).length == 0) {
            throw new LDAPRealmException("no base DNs specified for finding users!");
        }
        for (int i = 0; i < userBaseDNs.length; ++i) {
            LDAPDelegate.userBaseDNs[i] = LDAPDN.normalize((String)userBaseDNs[i]);
        }
        String[] stringArray = LDAPDelegate.getProperties(properties, string + "user.scope");
        userFilters = LDAPDelegate.getProperties(properties, string + "user.filter");
        if (userFilters.length == 0) {
            throw new LDAPRealmException("no search filters specified for finding users!");
        }
        if (userFilters.length > 1 && userBaseDNs.length > 1 && userFilters.length != userBaseDNs.length) {
            throw new LDAPRealmException("number of user search filters (" + userFilters.length + ") does not match " + "number of user base DNs (" + userBaseDNs.length + "), but both are > 1");
        }
        userScopes = LDAPDelegate.makeScopes("user", LDAPDelegate.getProperties(properties, string + "user.scope"));
        if (userFilters.length > 1 && userScopes.length > 1 && userFilters.length != userScopes.length) {
            throw new LDAPRealmException("number of user search filters (" + userFilters.length + ") does not match " + "number of user search scopes (" + userScopes.length + "), but both are > 1");
        }
        for (n = 0; n < userFilters.length; ++n) {
            if (userFilters[n].indexOf("%u") != -1) continue;
            throw new LDAPRealmException("user search filter " + (n + 1) + " doesn't contain a '%u' clause");
        }
        userNameAttributes = LDAPDelegate.makeAttributes('u', userFilters);
        groupBaseDNs = LDAPDelegate.getProperties(properties, string + "group.dn");
        if (groupBaseDNs.length == 0) {
            throw new LDAPRealmException("no base DNs specified for finding groups!");
        }
        for (n = 0; n < groupBaseDNs.length; ++n) {
            LDAPDelegate.groupBaseDNs[n] = LDAPDN.normalize((String)groupBaseDNs[n]);
        }
        groupFilters = LDAPDelegate.getProperties(properties, string + "group.filter");
        if (groupFilters.length == 0) {
            throw new LDAPRealmException("no search filters specified for finding groups!");
        }
        groupNameAttributes = LDAPDelegate.makeAttributes('g', groupFilters);
        groupScopes = LDAPDelegate.makeScopes("group", LDAPDelegate.getProperties(properties, string + "group.scope"));
        if (groupFilters.length > 1 && groupScopes.length > 1 && groupFilters.length != groupScopes.length) {
            throw new LDAPRealmException("number of group search filters (" + groupFilters.length + ") does not match " + "number of group search scopes (" + groupScopes.length + "), but both are > 1");
        }
        if (groupFilters.length > 1 && groupBaseDNs.length > 1 && groupFilters.length != groupBaseDNs.length) {
            throw new LDAPRealmException("number of group search filters (" + groupFilters.length + ") does not match " + "number of group base DNs (" + groupBaseDNs.length + "), but both are > 1");
        }
        for (n = 0; n < groupFilters.length; ++n) {
            if (groupFilters[n].indexOf("%g") != -1) continue;
            throw new LDAPRealmException("group search filter " + (n + 1) + " doesn't contain a '%g' clause");
        }
        groupScopeDepth = LDAPDelegate.getInteger(properties, string + "membership.scope.depth", -1);
        memberFilters = LDAPDelegate.getProperties(properties, string + "membership.filter");
        if (memberFilters.length == 0) {
            throw new LDAPRealmException("no search filters specified for finding group memberships!");
        }
        memberAttributes = LDAPDelegate.makeAttributes('M', memberFilters);
        memberScopes = LDAPDelegate.makeScopes("membership", LDAPDelegate.getProperties(properties, string + "membership.scope"));
        if (memberFilters.length > 1 && groupBaseDNs.length > 1 && memberFilters.length != groupBaseDNs.length) {
            throw new LDAPRealmException("number of membership search filters (" + memberFilters.length + ") does not match " + "number of group base DNs (" + groupBaseDNs.length + "), but both are > 1");
        }
        if (memberFilters.length > 1 && memberScopes.length > 1 && memberFilters.length != memberScopes.length) {
            throw new LDAPRealmException("number of membership search filters (" + memberFilters.length + ") does not match " + "number of membership search scopes (" + memberScopes.length + "), but both are > 1");
        }
        for (n = 0; n < memberFilters.length; ++n) {
            if (memberFilters[n].indexOf("%M") != -1 || memberFilters[n].indexOf("%G") != -1) continue;
            throw new LDAPRealmException("membership search filter " + (n + 1) + " contains neither a '%M' nor a '%G' clause");
        }
    }

    private static int[] makeScopes(String string, String[] stringArray) {
        int[] nArray;
        if (stringArray.length > 0) {
            nArray = new int[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i].toLowerCase(Locale.ENGLISH);
                if (string2.startsWith("sub")) {
                    nArray[i] = 2;
                    continue;
                }
                if (string2.startsWith("one")) {
                    nArray[i] = 1;
                    continue;
                }
                if (string2.startsWith("base")) {
                    nArray[i] = 0;
                    continue;
                }
                throw new LDAPRealmException(string + " search scope " + (i + 1) + " (" + stringArray[i] + ")  not recognized");
            }
        } else {
            nArray = new int[]{2};
        }
        return nArray;
    }

    private static String[][] makeAttributes(char c, String[] stringArray) {
        Perl5Compiler perl5Compiler = new Perl5Compiler();
        Perl5Matcher perl5Matcher = new Perl5Matcher();
        String[][] stringArray2 = new String[stringArray.length][];
        Pattern pattern = null;
        try {
            pattern = perl5Compiler.compile("\\(\\s*(\\w+)\\s*[>~<=]+([^)]*%" + c + "[^)]*)\\)");
        }
        catch (MalformedPatternException malformedPatternException) {
            throw new LDAPRealmException("internal LDAPRealm bug", malformedPatternException);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            PatternMatcherInput patternMatcherInput = new PatternMatcherInput(stringArray[i]);
            Vector<String> vector = new Vector<String>();
            while (perl5Matcher.contains(patternMatcherInput, pattern)) {
                MatchResult matchResult = perl5Matcher.getMatch();
                String string = matchResult.group(1);
                vector.addElement(string);
            }
            stringArray2[i] = new String[vector.size()];
            vector.copyInto(stringArray2[i]);
        }
        return stringArray2;
    }

    private static String scopeToString(int n) {
        switch (n) {
            case 2: {
                return "base DN & below";
            }
            case 0: {
                return "base DN only";
            }
            case 1: {
                return "base DN + 1";
            }
        }
        return "unknown or invalid scope";
    }

    static int getInteger(Properties properties, String string, int n) {
        String string2 = properties.getProperty(string);
        if (string2 == null) {
            return n;
        }
        return Integer.parseInt(string2);
    }

    static boolean getBoolean(Properties properties, String string, boolean bl) {
        String string2 = properties.getProperty(string);
        if (string2 == null) {
            return bl;
        }
        return Boolean.valueOf(string2);
    }

    static String[] getProperties(Properties properties, String string) {
        Vector<String> vector = new Vector<String>();
        String string2 = properties.getProperty(string);
        if (string2 != null) {
            vector.addElement(string2);
        }
        int n = 1;
        while ((string2 = properties.getProperty(string + "." + n)) != null) {
            vector.addElement(string2);
            ++n;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    boolean getAllowEnumeration() {
        return allowEnumeration;
    }

    LDAPDelegate(LDAPRealm lDAPRealm) {
        this.owner = lDAPRealm;
        this.log = lDAPRealm.log;
        this.connPool = new Pool((Factory)new LDAPFactory(), 6);
        LDAPDelegate.setupProperties();
        userConstraints = new LDAPSearchConstraints();
        userConstraints.setMaxResults(1);
        groupConstraints = new LDAPSearchConstraints();
        groupConstraints.setMaxResults(1);
        getUserConstraints = new LDAPSearchConstraints();
        getUserConstraints.setMaxResults(0);
        getUserConstraints.setBatchSize(1);
        getGroupConstraints = new LDAPSearchConstraints();
        getGroupConstraints.setMaxResults(0);
        getGroupConstraints.setBatchSize(1);
        memberConstraints = new LDAPSearchConstraints();
        memberConstraints.setMaxResults(0);
        memberConstraints.setBatchSize(1);
    }

    LDAPConnection getConnection() {
        try {
            return (LDAPConnection)this.connPool.getInstance();
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new LDAPRealmException("could not get connection", invocationTargetException);
        }
    }

    void returnConnection(LDAPConnection lDAPConnection) {
        if (lDAPConnection != null) {
            this.connPool.returnInstance((Object)lDAPConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LDAPUser authenticate(String string, String string2) {
        LDAPUser lDAPUser = this.getUser(string = this.replaceChar(string, "*", LDAP_PREFIX));
        if (lDAPUser == null || string2 == null || LDAP_PREFIX.equals(string2)) {
            return null;
        }
        LDAPConnection lDAPConnection = this.getConnection();
        LDAPUser lDAPUser2 = null;
        try {
            try {
                if (this.log != null) {
                    this.log.debug("bind(" + lDAPUser.getDN() + ")");
                }
                lDAPConnection.bind(3, lDAPUser.getDN(), string2);
                lDAPUser2 = lDAPUser;
            }
            catch (LDAPException lDAPException) {
                switch (lDAPException.getLDAPResultCode()) {
                    case 19: {
                        if (lDAPConnection != null) {
                            this.connPool.destroyInstance((Object)lDAPConnection);
                        }
                        lDAPConnection = this.getConnection();
                        break;
                    }
                    case 48: 
                    case 49: {
                        break;
                    }
                    case 53: {
                        if (lDAPConnection != null) {
                            this.connPool.destroyInstance((Object)lDAPConnection);
                        }
                        lDAPConnection = this.getConnection();
                        throw new LDAPRealmException(lDAPException.getLDAPErrorMessage(), lDAPException);
                    }
                    default: {
                        this.handleException((Exception)((Object)lDAPException));
                    }
                }
            }
            if (lDAPConnection != null) {
                lDAPConnection.bind(3, serverPrincipal, serverCredential);
            }
        }
        catch (LDAPException lDAPException) {
            this.handleException((Exception)((Object)lDAPException));
        }
        finally {
            this.returnConnection(lDAPConnection);
        }
        return lDAPUser2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    LDAPUser getUser(String string) {
        try {
            int n = userBaseDNs.length > userFilters.length ? userBaseDNs.length : userFilters.length;
            for (int i = 0; i < n; ++i) {
                String string2;
                LDAPSearchResults lDAPSearchResults;
                String string3 = LDAPDelegate.printf(userFilters[userFilters.length > 1 ? i : 0], 'u', LDAPDelegate.getEncodedStringRepresentation(string));
                String string4 = userBaseDNs[userBaseDNs.length > 1 ? i : 0];
                string4 = LDAPDelegate.getEncodedStringRepresentation(string4);
                int n2 = userScopes[userScopes.length > 1 ? i : 0];
                if (this.log != null) {
                    this.log.debug("search(\"" + string4 + "\", \"" + string3 + "\", " + LDAPDelegate.scopeToString(n2) + ")");
                }
                if (!(lDAPSearchResults = this.search(string4, n2, string3, USER_ATTRS, false, userConstraints)).hasMoreElements()) continue;
                String string5 = lDAPSearchResults.next().getDN();
                String string6 = string2 = string5.indexOf("\\,") > -1 ? this.unescapeCommaForDN(string5) : string5;
                if (caseSensitive && string2.indexOf(string) == -1) {
                    if (this.log == null) return null;
                    if (string5.toLowerCase(Locale.ENGLISH).indexOf(string.toLowerCase(Locale.ENGLISH)) == -1) return null;
                    this.log.debug("incorrect case for user: " + string);
                    return null;
                }
                if (this.log == null) return new LDAPUser(string, string5, this.owner);
                this.log.debug("DN for user " + string + ": " + string5);
                return new LDAPUser(string, string5, this.owner);
            }
        }
        catch (LDAPException lDAPException) {
            this.handleException((Exception)((Object)lDAPException));
        }
        if (this.log == null) return null;
        this.log.debug("User " + string + " not found.");
        return null;
    }

    private static String getEncodedStringRepresentation(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            StringBuffer stringBuffer = new StringBuffer(byArray.length * 3);
            for (int i = 0; i < byArray.length; ++i) {
                stringBuffer.append('\\');
                LDAPDelegate.hexDigit(stringBuffer, byArray[i]);
            }
            return stringBuffer.toString();
        }
        String string = !(object instanceof String) ? object.toString() : (String)object;
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        block8: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '*': {
                    stringBuffer.append("\\2a");
                    continue block8;
                }
                case '(': {
                    stringBuffer.append("\\28");
                    continue block8;
                }
                case ')': {
                    stringBuffer.append("\\29");
                    continue block8;
                }
                case '\\': {
                    stringBuffer.append("\\5c");
                    continue block8;
                }
                case '\u0000': {
                    stringBuffer.append("\\00");
                    continue block8;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    private static void hexDigit(StringBuffer stringBuffer, byte by) {
        char c = (char)(by >> 4 & 0xF);
        c = c > '\t' ? (char)(c - 10 + 65) : (char)(c + 48);
        stringBuffer.append(c);
        c = (char)(by & 0xF);
        c = c > '\t' ? (char)(c - 10 + 65) : (char)(c + 48);
        stringBuffer.append(c);
    }

    private String replaceChar(String string, String string2, String string3) {
        while (string.indexOf(string2) != -1) {
            int n = string.indexOf(string2);
            string = string.substring(0, n) + string3 + string.substring(n + string2.length());
        }
        return string;
    }

    void handleException(Exception exception) {
        throw new LDAPRealmException("caught unexpected exception", exception);
    }

    static String printf(String string, char c, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        boolean bl = false;
        block6: for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (bl) {
                if (c2 == c) {
                    stringBuffer.append(string2);
                } else {
                    switch (c2) {
                        case '%': {
                            stringBuffer.append(c2);
                            break;
                        }
                        default: {
                            stringBuffer.append('%');
                            stringBuffer.append(c2);
                        }
                    }
                }
                bl = false;
                continue;
            }
            switch (c2) {
                case '%': {
                    bl = true;
                    continue block6;
                }
                default: {
                    stringBuffer.append(c2);
                }
            }
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Group getGroup(String string) {
        try {
            int n = groupBaseDNs.length > groupFilters.length ? groupBaseDNs.length : groupFilters.length;
            int n2 = 0;
            while (n2 < n) {
                LDAPSearchResults lDAPSearchResults;
                String string2 = LDAPDelegate.printf(groupFilters[groupFilters.length > 1 ? n2 : 0], 'g', LDAPDelegate.getEncodedStringRepresentation(string));
                String string3 = groupBaseDNs[groupBaseDNs.length > 1 ? n2 : 0];
                string3 = LDAPDelegate.getEncodedStringRepresentation(string3);
                int n3 = groupScopes[groupScopes.length > 1 ? n2 : 0];
                if (this.log != null) {
                    this.log.debug("search(\"" + string3 + "\", \"" + string2 + "\", " + LDAPDelegate.scopeToString(n3) + ")");
                }
                if ((lDAPSearchResults = this.search(string3, n3, string2, GROUP_ATTRS, false, groupConstraints)).hasMoreElements()) {
                    String string4 = lDAPSearchResults.next().getDN();
                    if (this.log == null) return new LDAPGroup(string, string4, this, this.owner);
                    this.log.debug("DN for group " + string + ": " + string4);
                    return new LDAPGroup(string, string4, this, this.owner);
                }
                ++n2;
            }
            return null;
        }
        catch (LDAPException lDAPException) {
            this.handleException((Exception)((Object)lDAPException));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Enumeration groupMembers(String string) {
        Enumeration enumeration = null;
        try {
            enumeration = this.groupMembersInternal(string);
        }
        catch (LDAPException lDAPException) {
            this.handleException((Exception)((Object)lDAPException));
        }
        return enumeration;
    }

    private Enumeration groupMembersInternal(String string) throws LDAPException {
        Vector<LDAPEntity> vector = new Vector<LDAPEntity>();
        string = LDAPDelegate.getEncodedStringRepresentation(string);
        for (int i = 0; i < memberFilters.length; ++i) {
            String string2 = LDAPDelegate.printf(memberFilters[memberFilters.length > 1 ? i : 0], 'G', string);
            string2 = LDAPDelegate.printf(string2, 'M', "*");
            String[] stringArray = memberAttributes[memberFilters.length > 1 ? i : 0];
            int n = memberScopes[memberScopes.length > 1 ? i : 0];
            if (this.log != null) {
                this.log.debug("search(\"" + string + "\", \"" + string2 + "\", " + LDAPDelegate.scopeToString(n) + ")");
            }
            LDAPSearchResults lDAPSearchResults = this.search(string, n, string2, stringArray, false, memberConstraints);
            while (lDAPSearchResults.hasMoreElements()) {
                LDAPEntry lDAPEntry = lDAPSearchResults.next();
                String string3 = lDAPEntry.getDN();
                LDAPAttributeSet lDAPAttributeSet = lDAPEntry.getAttributeSet();
                Enumeration enumeration = lDAPAttributeSet.getAttributes();
                while (enumeration.hasMoreElements()) {
                    LDAPAttribute lDAPAttribute = (LDAPAttribute)enumeration.nextElement();
                    String string4 = lDAPAttribute.getName();
                    Enumeration enumeration2 = lDAPAttribute.getStringValues();
                    while (enumeration2.hasMoreElements()) {
                        LDAPEntity lDAPEntity;
                        String string5 = (String)enumeration2.nextElement();
                        String string6 = LDAPDN.normalize((String)string5);
                        LDAPUser lDAPUser = this.searchDNForUser(string5);
                        boolean bl = false;
                        if (lDAPUser != null) {
                            bl = true;
                            vector.addElement(lDAPUser);
                        } else {
                            lDAPEntity = this.searchDNForGroup(string5);
                            if (lDAPEntity != null) {
                                bl = true;
                                vector.addElement(lDAPEntity);
                            }
                        }
                        if (bl || !membershipSearch || (lDAPEntity = this.readDNForUser(string5)) == null) continue;
                        bl = true;
                        vector.addElement(lDAPEntity);
                    }
                }
            }
        }
        return vector.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private LDAPUser readDNForUser(String string) {
        try {
            LDAPUser lDAPUser;
            LDAPSearchResults lDAPSearchResults;
            block8: {
                String string2 = "(objectclass=*)";
                if (this.log != null) {
                    this.log.debug("search(\"" + string + "\", \"(objectclass=*)\", " + LDAPDelegate.scopeToString(2) + ")");
                }
                lDAPSearchResults = null;
                try {
                    lDAPSearchResults = this.search(string, 2, string2, new String[]{"*"}, false, userConstraints);
                }
                catch (LDAPException lDAPException) {
                    if (this.log == null) break block8;
                    this.log.debug("ignoring " + lDAPException.getMessage());
                }
            }
            if (lDAPSearchResults == null) return null;
            do {
                if (!lDAPSearchResults.hasMoreElements()) return null;
            } while ((lDAPUser = this.checkEntryForUser(lDAPSearchResults.next())) == null);
            return lDAPUser;
        }
        catch (Exception exception) {
            this.handleException(exception);
            return null;
        }
    }

    private LDAPUser checkEntryForUser(LDAPEntry lDAPEntry) {
        Enumeration enumeration = lDAPEntry.getAttributeSet().getAttributes();
        if (!enumeration.hasMoreElements()) {
            return this.searchDNForUser(lDAPEntry.getDN());
        }
        while (enumeration.hasMoreElements()) {
            LDAPAttribute lDAPAttribute = (LDAPAttribute)enumeration.nextElement();
            String string = lDAPAttribute.getBaseName();
            Enumeration enumeration2 = lDAPAttribute.getStringValues();
            for (int i = 0; i < userNameAttributes.length; ++i) {
                for (int j = 0; j < userNameAttributes[i].length; ++j) {
                    if (!enumeration2.hasMoreElements()) continue;
                    String string2 = (String)enumeration2.nextElement();
                    if (!string.equals(userNameAttributes[i][j]) || this.getUser(string2) == null) continue;
                    LDAPUser lDAPUser = new LDAPUser(string2, lDAPEntry.getDN(), this.owner);
                    return lDAPUser;
                }
            }
        }
        return null;
    }

    private LDAPUser searchDNForUser(String string) {
        for (int i = 0; i < userNameAttributes.length; ++i) {
            for (int j = 0; j < userNameAttributes[i].length; ++j) {
                String string2;
                if (string.indexOf(userNameAttributes[i][j]) <= -1 || (string2 = this.getAttributeValue(userNameAttributes[i][j], string)) == null || this.getUser(string2) == null) continue;
                return new LDAPUser(string2, string, this.owner);
            }
        }
        return null;
    }

    private LDAPGroup searchDNForGroup(String string) {
        for (int i = 0; i < groupNameAttributes.length; ++i) {
            for (int j = 0; j < groupNameAttributes[i].length; ++j) {
                String string2;
                if (string.indexOf(groupNameAttributes[i][j]) <= -1 || (string2 = this.getAttributeValue(groupNameAttributes[i][j], string)) == null || this.getGroup(string2) == null) continue;
                return new LDAPGroup(string2, string, this, this.owner);
            }
        }
        return null;
    }

    private String unescapeCommaForDN(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\\') continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private String getAttributeValue(String string, String string2) {
        String string3 = string + "=";
        int n = string2.indexOf(string3);
        if (n == -1) {
            return null;
        }
        int n2 = n + string3.length();
        String string4 = string2.substring(n2);
        if (string4.startsWith("=")) {
            string4 = string4.substring(1);
        }
        int n3 = string4.indexOf(",");
        int n4 = string4.indexOf("\\");
        if (n4 != -1 && n3 - n4 == 1) {
            for (int i = 0; i < string4.length(); ++i) {
                String string5 = string4.substring(0, i);
                if (!string5.endsWith(",") || string5.endsWith("\\,")) continue;
                return this.unescapeCommaForDN(string5.substring(0, string5.length() - 1));
            }
            if (this.log != null) {
                this.log.debug("Could not find an unescaped comma in the following DN - " + string4);
            }
            return null;
        }
        return string4.substring(0, n3).trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean groupContains(String string, String string2) {
        boolean bl = false;
        try {
            bl = this.groupContainsInternal(string, string2, new Stack());
        }
        catch (LDAPException lDAPException) {
            this.handleException((Exception)((Object)lDAPException));
        }
        return bl;
    }

    private boolean groupContainsInternal(String string, String string2, Stack stack) throws LDAPException {
        if (string.equals(string2)) {
            return true;
        }
        LDAPDelegate.checkForCircularity(string, string2, stack);
        stack.push(string2);
        int n = groupBaseDNs.length > memberFilters.length ? groupBaseDNs.length : memberFilters.length;
        for (int i = 0; i < n; ++i) {
            Object object;
            String string3 = LDAPDelegate.printf(memberFilters[memberFilters.length > 1 ? i : 0], 'G', string);
            string3 = LDAPDelegate.printf(string3, 'M', LDAPDelegate.getEncodedStringRepresentation(string2));
            String string4 = groupBaseDNs[groupBaseDNs.length > 1 ? i : 0];
            string4 = LDAPDelegate.getEncodedStringRepresentation(string4);
            int n2 = memberScopes[memberScopes.length > 1 ? i : 0];
            if (this.log != null) {
                this.log.debug("search(\"" + string4 + "\", \"" + string3 + "\", " + LDAPDelegate.scopeToString(n2) + ")");
            }
            LDAPSearchResults lDAPSearchResults = this.search(string4, n2, string3, MEMBER_ATTRS, false, memberConstraints);
            Vector<String> vector = new Vector<String>();
            while (lDAPSearchResults.hasMoreElements()) {
                object = lDAPSearchResults.next();
                String string5 = object.getDN();
                if (groupScopeDepth > 0) {
                    for (int j = groupScopeDepth; j >= 0; --j) {
                        if (j > 0) {
                            int n3 = string5.indexOf(44);
                            if (n3 == -1) {
                                throw new LDAPRealmException("group scope depth is greater than the number of RDNs in '" + string5 + "'");
                            }
                            string5 = string5.substring(n3 + 1).trim();
                        }
                        if (string.equals(string5)) {
                            return true;
                        }
                        vector.add(string5);
                    }
                    continue;
                }
                if (string.equals(string5)) {
                    return true;
                }
                vector.add(string5);
            }
            if (directMembershipOnly) continue;
            object = vector.elements();
            while (object.hasMoreElements()) {
                if (!this.groupContainsInternal(string, (String)object.nextElement(), stack)) continue;
                return true;
            }
        }
        stack.pop();
        return false;
    }

    private static void checkForCircularity(String string, String string2, Stack stack) throws LDAPRealmException {
        if (stack.contains(string2)) {
            String string3;
            StringBuffer stringBuffer = new StringBuffer("circular group: while checking '");
            stringBuffer.append(string);
            stringBuffer.append("', found ");
            stringBuffer.append(string2);
            do {
                stringBuffer.append(" -> ");
                string3 = (String)stack.pop();
                stringBuffer.append(string3);
            } while (!string3.equals(string2) && !stack.empty());
            throw new LDAPRealmException(stringBuffer.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Enumeration getUsers() {
        int n = userBaseDNs.length > userFilters.length ? userBaseDNs.length : userFilters.length;
        Enumeration[] enumerationArray = new Enumeration[n];
        LDAPConnection lDAPConnection = this.getConnection();
        LDAPSearchConstraints lDAPSearchConstraints = lDAPConnection.getSearchConstraints();
        this.returnConnection(lDAPConnection);
        int n2 = lDAPSearchConstraints.getMaxResults();
        lDAPSearchConstraints.setMaxResults(100);
        try {
            for (int i = 0; i < n; ++i) {
                String string = LDAPDelegate.printf(userFilters[userFilters.length > 1 ? i : 0], 'u', "*");
                String[] stringArray = userNameAttributes[userFilters.length > 1 ? i : 0];
                String string2 = userBaseDNs[userBaseDNs.length > 1 ? i : 0];
                string2 = LDAPDelegate.getEncodedStringRepresentation(string2);
                int n3 = userScopes[userScopes.length > 1 ? i : 0];
                enumerationArray[i] = new UserMangler(stringArray, (Enumeration)this.search(string2, n3, string, USER_ATTRS, false, getUserConstraints));
            }
        }
        catch (LDAPException lDAPException) {
            this.handleException((Exception)((Object)lDAPException));
        }
        return new SequencingEnumerator(enumerationArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Enumeration getGroups() {
        int n = groupBaseDNs.length > groupFilters.length ? groupBaseDNs.length : groupFilters.length;
        Enumeration[] enumerationArray = new Enumeration[n];
        try {
            for (int i = 0; i < n; ++i) {
                String string = LDAPDelegate.printf(groupFilters[groupFilters.length > 1 ? i : 0], 'g', "*");
                String[] stringArray = groupNameAttributes[groupFilters.length > 1 ? i : 0];
                String string2 = groupBaseDNs[groupBaseDNs.length > 1 ? i : 0];
                string2 = LDAPDelegate.getEncodedStringRepresentation(string2);
                int n2 = groupScopes[groupScopes.length > 1 ? i : 0];
                if (this.log != null) {
                    this.log.debug("search(\"" + string2 + "\", \"" + string + "\", " + LDAPDelegate.scopeToString(n2) + ", \"" + stringArray[0] + "\")");
                }
                enumerationArray[i] = new GroupMangler(stringArray, (Enumeration)this.search(string2, n2, string, stringArray, false, getGroupConstraints));
            }
        }
        catch (LDAPException lDAPException) {
            this.handleException((Exception)((Object)lDAPException));
        }
        return new SequencingEnumerator(enumerationArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LDAPSearchResults search(String string, int n, String string2, String[] stringArray, boolean bl, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        LDAPSearchResults lDAPSearchResults = null;
        LDAPConnection lDAPConnection = this.getConnection();
        int n2 = 0;
        int n3 = 2;
        while (n2 < n3) {
            try {
                lDAPSearchResults = lDAPConnection.search(string, n, string2, stringArray, bl, lDAPSearchConstraints);
                n2 = 2;
            }
            catch (LDAPException lDAPException) {
                if (lDAPException.getLDAPResultCode() == 80 || lDAPException.getLDAPResultCode() == 81) {
                    ++n2;
                    LDAPDelegate lDAPDelegate = this;
                    synchronized (lDAPDelegate) {
                        this.returnConnection(lDAPConnection);
                        this.connPool.close();
                        this.connPool = new Pool((Factory)new LDAPFactory(), 6);
                        lDAPConnection = this.getConnection();
                        continue;
                    }
                }
                this.returnConnection(lDAPConnection);
                throw lDAPException;
            }
        }
        this.returnConnection(lDAPConnection);
        return lDAPSearchResults;
    }

    void close() {
        this.connPool.close();
        this.connPool = null;
    }

    public void setDebugLog(LogOutputStream logOutputStream) {
        if (logOutputStream != null) {
            this.log = logOutputStream;
        }
    }

    public LogOutputStream getDebugLog() {
        return this.log;
    }

    static {
        USER_ATTRS = new String[]{"1.1"};
        GROUP_ATTRS = new String[]{"1.1"};
        MEMBER_ATTRS = new String[]{"1.1"};
        caseSensitive = true;
        boxOfSocks = new FocketSactory();
    }

    private static class FocketSactory
    implements LDAPSocketFactory {
        private static AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

        private FocketSactory() {
        }

        public Socket makeSocket(String string, int n) throws LDAPException {
            try {
                SSLSocketFactory sSLSocketFactory = SSLContextManager.getDefaultSSLSocketFactory(kernelId);
                SSLSocket sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(string, n);
                sSLSocket.startHandshake();
                return sSLSocket;
            }
            catch (Exception exception) {
                LDAPException lDAPException = new LDAPException(exception.getMessage(), 91);
                lDAPException.initCause((Throwable)exception);
                throw lDAPException;
            }
        }
    }

    class LDAPFactory
    implements Factory {
        LDAPFactory() {
        }

        public Object newInstance() throws InvocationTargetException {
            try {
                if (LDAPDelegate.this.log != null) {
                    LDAPDelegate.this.log.debug("new LDAP connection");
                }
                LDAPConnection lDAPConnection = null;
                lDAPConnection = useSSL ? new LDAPConnection(boxOfSocks) : new LDAPConnection();
                lDAPConnection.connect(serverHost, serverPort);
                lDAPConnection.bind(3, serverPrincipal, serverCredential);
                if (cacheTTL > 0 && cacheSize > 0) {
                    lDAPConnection.setCache(new LDAPCache((long)cacheTTL, (long)(cacheSize * 1024)));
                    if (LDAPDelegate.this.log != null) {
                        LDAPDelegate.this.log.debug("connection succeeded - cacheTTL " + cacheTTL + ", cacheSize " + cacheSize * 1024);
                    }
                } else if (LDAPDelegate.this.log != null) {
                    LDAPDelegate.this.log.debug("connection succeeded");
                }
                return lDAPConnection;
            }
            catch (LDAPException lDAPException) {
                throw new InvocationTargetException(lDAPException);
            }
        }

        public void destroyInstance(Object object) {
            try {
                if (LDAPDelegate.this.log != null) {
                    LDAPDelegate.this.log.debug("destroy LDAP connection");
                }
                ((LDAPConnection)object).disconnect();
            }
            catch (LDAPException lDAPException) {
                // empty catch block
            }
        }
    }

    class GroupMangler
    extends MappingEnumerator {
        String[] attrNames;

        GroupMangler(String[] stringArray, Enumeration enumeration) {
            super(enumeration);
            this.attrNames = stringArray;
        }

        protected Object map(Object object) {
            Object var2_2 = null;
            if (object instanceof LDAPEntry) {
                LDAPEntry lDAPEntry = (LDAPEntry)object;
                String string = lDAPEntry.getDN();
                for (int i = 0; i < this.attrNames.length; ++i) {
                    LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(this.attrNames[i]);
                    if (lDAPAttribute == null) continue;
                    String[] stringArray = lDAPAttribute.getStringValueArray();
                    return new LDAPGroup(stringArray[0], string, LDAPDelegate.this, LDAPDelegate.this.owner);
                }
            } else if (object instanceof Exception) {
                LDAPDelegate.this.handleException((Exception)object);
            }
            throw new LDAPRealmException("ClassCastException: received a " + object.getClass().getName() + "[" + object.toString() + "]" + ", expected a netscape.ldap.LDAPEntry");
        }
    }

    class UserMangler
    extends MappingEnumerator {
        String[] attrNames;

        UserMangler(String[] stringArray, Enumeration enumeration) {
            super(enumeration);
            this.attrNames = stringArray;
        }

        protected Object map(Object object) {
            Object var2_2 = null;
            if (object instanceof LDAPEntry) {
                LDAPEntry lDAPEntry = (LDAPEntry)object;
                String string = lDAPEntry.getDN();
                String string2 = LDAPDelegate.this.getAttributeValue(this.attrNames[0], string);
                if (string2 != null) {
                    return new LDAPUser(string2, string, LDAPDelegate.this.owner);
                }
                if (membershipSearch) {
                    return LDAPDelegate.this.readDNForUser(string);
                }
                return null;
            }
            if (object instanceof Exception) {
                LDAPDelegate.this.handleException((Exception)object);
            }
            throw new LDAPRealmException("ClassCastException: received a " + object.getClass().getName() + "[" + object.toString() + "]" + ", expected an netscape.ldap.LDAPEntry");
        }
    }
}

