/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.ldaprealmv2;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.Hashtable;
import weblogic.logging.LogOutputStream;
import weblogic.security.acl.AbstractListableRealm;
import weblogic.security.acl.DebuggableRealm;
import weblogic.security.acl.FlatGroup;
import weblogic.security.acl.User;
import weblogic.security.ldaprealmv2.LDAPDelegate;
import weblogic.security.ldaprealmv2.LDAPGroup;

public final class LDAPRealm
extends AbstractListableRealm
implements DebuggableRealm,
FlatGroup.Source {
    private static final int POOL_SIZE = 8;
    private LDAPDelegate delegate = new LDAPDelegate(this);
    LogOutputStream log;

    public LDAPRealm() {
        super("LDAP Realm");
        try {
            this.setDebug(Boolean.getBoolean("weblogic.security.ldaprealm.verbose"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public User getUser(String string) {
        if (this.log != null) {
            this.log.debug("getUser(\"" + string + "\")");
        }
        return this.delegate.getUser(string);
    }

    protected User authUserPassword(String string, String string2) {
        if (this.log != null) {
            this.log.debug("authUserPassword(\"" + string + "\")");
        }
        return this.delegate.authenticate(string, string2);
    }

    public Enumeration getUsers() {
        if (this.log != null) {
            this.log.debug("getUsers()");
        }
        if (!this.delegate.getAllowEnumeration()) {
            throw new UnsupportedOperationException("getUsers not supported");
        }
        return this.delegate.getUsers();
    }

    public Group getGroup(String string) {
        if (this.log != null) {
            this.log.debug("getGroup(\"" + string + "\")");
        }
        return this.delegate.getGroup(string);
    }

    public Enumeration getGroups() {
        if (this.log != null) {
            this.log.debug("getGroups()");
        }
        if (!this.delegate.getAllowEnumeration()) {
            throw new UnsupportedOperationException("getGroups not supported");
        }
        return this.delegate.getGroups();
    }

    boolean groupContains(String string, String string2) {
        return this.delegate.groupContains(string, string2);
    }

    public Hashtable getGroupMembersInternal(String string) {
        LDAPGroup lDAPGroup = (LDAPGroup)this.getGroup(string);
        if (lDAPGroup == null) {
            return null;
        }
        Enumeration enumeration = this.delegate.groupMembers(lDAPGroup.getDN());
        Hashtable hashtable = new Hashtable();
        if (enumeration != null && enumeration.hasMoreElements()) {
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                hashtable.put(((Principal)e).getName(), e);
            }
        }
        return hashtable;
    }

    public void setDebug(boolean bl) {
        if (bl && this.log == null) {
            this.log = new LogOutputStream("LDAPRealm");
        }
        if (!bl) {
            this.log = null;
        }
        this.delegate.setDebugLog(this.log);
    }

    public LogOutputStream getDebugLog() {
        return this.log;
    }
}

