/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.net;

import java.net.InetAddress;
import java.net.Socket;
import java.util.EventObject;
import weblogic.security.net.ConnectionFilterImpl;

public final class ConnectionEvent
extends EventObject {
    private static final long serialVersionUID = -8861858081041858122L;
    private InetAddress remAddr;
    private int remPort;
    private InetAddress localAddr;
    private int localPort;
    private String protocol;

    public ConnectionEvent(Socket socket, String string) {
        this(socket.getInetAddress(), socket.getPort(), socket.getLocalAddress(), socket.getLocalPort(), string);
    }

    public ConnectionEvent(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2, String string) {
        super(ConnectionFilterImpl.impl);
        this.remAddr = inetAddress;
        this.remPort = n;
        this.localAddr = inetAddress2;
        this.localPort = n2;
        this.protocol = string;
    }

    public InetAddress getRemoteAddress() {
        return this.remAddr;
    }

    public int getRemotePort() {
        return this.remPort;
    }

    public InetAddress getLocalAddress() {
        return this.localAddr;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public int hashCode() {
        return this.remPort ^ this.localPort ^ this.remAddr.hashCode() ^ this.localAddr.hashCode() ^ (this.protocol != null ? this.protocol.hashCode() : 0);
    }

    public boolean equals(Object object) {
        if (object instanceof ConnectionEvent) {
            ConnectionEvent connectionEvent = (ConnectionEvent)object;
            return this.remPort == connectionEvent.remPort && this.localPort == connectionEvent.localPort && this.remAddr.equals(connectionEvent.remAddr) && this.localAddr.equals(connectionEvent.localAddr) && (this.protocol != null ? this.protocol.equals(connectionEvent.protocol) : connectionEvent.protocol == null);
        }
        return false;
    }
}

