/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.net;

import java.io.IOException;
import java.io.StreamCorruptedException;
import java.net.InetAddress;
import java.text.ParseException;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import weblogic.security.SecurityLogger;
import weblogic.security.SecurityService;
import weblogic.security.net.ConnectionEvent;
import weblogic.security.net.ConnectionFilter;
import weblogic.security.net.ConnectionFilterRulesListener;
import weblogic.security.net.FastFilterEntry;
import weblogic.security.net.FilterEntry;
import weblogic.security.net.FilterException;
import weblogic.security.net.SlowFilterEntry;

public class ConnectionFilterImpl
implements ConnectionFilter,
ConnectionFilterRulesListener {
    static ConnectionFilter impl = new ConnectionFilterImpl();
    private FilterEntry[] rules;

    public void checkRules(String[] stringArray) throws ParseException {
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                int n = string.indexOf(35);
                if (n != -1) {
                    string = string.substring(0, n).trim();
                }
                if (string.length() == 0) continue;
                try {
                    this.parseLine(string, null);
                    continue;
                }
                catch (StreamCorruptedException streamCorruptedException) {
                    throw new ParseException(streamCorruptedException.getMessage(), i + 1);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new ParseException(illegalArgumentException.getMessage(), i + 1);
                }
                catch (IOException iOException) {
                    throw new ParseException(iOException.getMessage(), i + 1);
                }
            }
        }
    }

    protected void checkRules(String[] stringArray, Vector vector) throws ParseException {
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                int n = string.indexOf(35);
                if (n != -1) {
                    string = string.substring(0, n).trim();
                }
                if (string.length() == 0) continue;
                try {
                    this.parseLine(string, vector);
                    continue;
                }
                catch (StreamCorruptedException streamCorruptedException) {
                    throw new ParseException(streamCorruptedException.getMessage(), i + 1);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new ParseException(illegalArgumentException.getMessage(), i + 1);
                }
                catch (IOException iOException) {
                    throw new ParseException(iOException.getMessage(), i + 1);
                }
            }
        }
    }

    public void setRules(String[] stringArray) throws ParseException {
        Vector vector = new Vector();
        this.checkRules(stringArray, vector);
        Object[] objectArray = new FilterEntry[vector.size()];
        vector.copyInto(objectArray);
        this.rules = objectArray;
    }

    public void accept(ConnectionEvent connectionEvent) throws FilterException {
        if (this.rules != null) {
            InetAddress inetAddress = connectionEvent.getRemoteAddress();
            String string = connectionEvent.getProtocol().toLowerCase(Locale.ENGLISH);
            int n = ConnectionFilterImpl.protocolToMaskBit(string);
            InetAddress inetAddress2 = connectionEvent.getLocalAddress();
            int n2 = connectionEvent.getLocalPort();
            int n3 = connectionEvent.getRemotePort();
            if (n == -559038737) {
                n = 0;
            }
            block5: for (int i = 0; i < this.rules.length; ++i) {
                switch (this.rules[i].check(inetAddress, n, inetAddress2, n2)) {
                    case 0: {
                        return;
                    }
                    case 1: {
                        throw new FilterException(SecurityLogger.getRuleDenied((String)("" + (i + 1))));
                    }
                    case 2: {
                        continue block5;
                    }
                    default: {
                        throw new RuntimeException(SecurityLogger.getConnFilterInternalErr());
                    }
                }
            }
        }
    }

    protected void parseLine(String string, Vector vector) throws IOException, IllegalArgumentException {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        int n = ConnectionFilterImpl.parseSingleAddress(string3);
        String string4 = stringTokenizer.nextToken();
        int n2 = string4.equals("*") ? -1 : new Integer(string4);
        boolean bl = ConnectionFilterImpl.parseAction(stringTokenizer.nextToken());
        if (string2.startsWith("*")) {
            SlowFilterEntry slowFilterEntry = new SlowFilterEntry(bl, ConnectionFilterImpl.parseProtocols(stringTokenizer), string2, n, n2);
            if (vector != null) {
                vector.addElement(slowFilterEntry);
            }
        } else {
            int n3 = string2.indexOf(47);
            int[] nArray = null;
            int n4 = -1;
            if (n3 != -1) {
                nArray = ConnectionFilterImpl.parseAddresses(string2.substring(0, n3));
                n4 = ConnectionFilterImpl.parseNetmask(string2.substring(n3 + 1));
            } else {
                nArray = ConnectionFilterImpl.parseAddresses(string2);
            }
            int n5 = ConnectionFilterImpl.parseProtocols(stringTokenizer);
            for (int i = 0; i < nArray.length; ++i) {
                FastFilterEntry fastFilterEntry = new FastFilterEntry(bl, n5, nArray[i], n4, n, n2);
                if (vector == null) continue;
                vector.addElement(fastFilterEntry);
            }
        }
    }

    protected static final int parseProtocols(StringTokenizer stringTokenizer) throws FilterException {
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            int n2 = ConnectionFilterImpl.protocolToMaskBit(string);
            if (n2 == -559038737) {
                throw new IllegalArgumentException(SecurityLogger.getUnknownProtocol((String)string));
            }
            n |= n2;
        }
        return n;
    }

    private static final int protocolToMaskBit(String string) throws FilterException {
        String[] stringArray = new String[]{"http", "t3", "https", "t3s", "iiop", "iiops", "giop", "giops", "com", "dcom", "ldap", "ldaps"};
        if (string == null) {
            return 0;
        }
        string = string.toLowerCase(Locale.ENGLISH);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return 1 << i + 1;
        }
        return -559038737;
    }

    protected static final int[] parseAddresses(String string) throws IOException {
        InetAddress[] inetAddressArray = InetAddress.getAllByName(string);
        int[] nArray = new int[inetAddressArray.length];
        for (int i = 0; i < inetAddressArray.length; ++i) {
            nArray[i] = ConnectionFilterImpl.addressToInt(inetAddressArray[i]);
        }
        return nArray;
    }

    protected static final int parseSingleAddress(String string) throws IOException {
        if (string.equals("*")) {
            return -1;
        }
        InetAddress inetAddress = InetAddress.getByName(string);
        return ConnectionFilterImpl.addressToInt(inetAddress);
    }

    static final int addressToInt(InetAddress inetAddress) {
        byte[] byArray = inetAddress.getAddress();
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            n |= (0xFF & byArray[i]) << 8 * (byArray.length - i - 1);
        }
        return n;
    }

    protected static final int parseNetmask(String string) throws IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n = stringTokenizer.countTokens();
        try {
            if (n == 1) {
                int n2 = Integer.parseInt(stringTokenizer.nextToken());
                if (n2 > 32 || n2 < 0) {
                    throw new StreamCorruptedException(SecurityLogger.getBadNetMaskBits((String)string));
                }
                return ~((1 << 32 - n2) - 1);
            }
            int n3 = 0;
            if (n != 4) {
                throw new StreamCorruptedException(SecurityLogger.getBadNetMaskTokens((String)string));
            }
            int n4 = 24;
            while (stringTokenizer.hasMoreTokens()) {
                int n5 = Integer.parseInt(stringTokenizer.nextToken());
                if (n5 < 0 || n5 > 255) {
                    throw new StreamCorruptedException(SecurityLogger.getBadNetMaskNum((String)string));
                }
                n3 |= n5 << n4;
                n4 -= 8;
            }
            return n3;
        }
        catch (NumberFormatException numberFormatException) {
            throw new StreamCorruptedException(SecurityLogger.getBadNetMaskFormat((String)string));
        }
    }

    protected static final boolean parseAction(String string) throws IOException {
        String string2 = string.toLowerCase(Locale.ENGLISH);
        if (string2.equals("allow")) {
            return true;
        }
        if (string2.equals("deny")) {
            return false;
        }
        throw new StreamCorruptedException(SecurityLogger.getBadAction((String)string2));
    }

    public static final boolean filterEnabled() {
        return SecurityService.getConnectionFilterEnabled();
    }

    public static final ConnectionFilter getFilter() {
        return SecurityService.getConnectionFilter();
    }

    public static final void setFilter(ConnectionFilter connectionFilter) {
        if (connectionFilter == null) {
            throw new NullPointerException(SecurityLogger.getNullFilter());
        }
        if (SecurityService.getConnectionFilter() != null) {
            throw new SecurityException(SecurityLogger.getSetFilterMoreThanOnce());
        }
        SecurityService.setConnectionFilter(connectionFilter);
    }
}

