/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.notshared;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.logging.WLLevel;
import weblogic.security.SecurityEnvironment;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.security.shared.LoggerAdapter;

public class LoggerAdapterImpl
implements LoggerAdapter {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final String WLS_PACKAGE = "weblogic.security.providers.";
    private static final int WLS_PACKAGE_OFFSET = "weblogic.security.providers.".length();
    private static final String WLES_PACKAGE = "com.bea.security.providers.";
    private static final int WLES_PACKAGE_OFFSET = "com.bea.security.providers.".length();
    private HashMap loggers = null;
    private boolean appletEnvironment = false;

    public LoggerAdapterImpl() {
        this.convertLegacyDebugSystemProperties();
        this.loggers = new HashMap();
    }

    private void run(PrivilegedAction privilegedAction) {
        SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)kernelId, (PrivilegedAction)privilegedAction);
    }

    public boolean isDebugEnabled(Object object) {
        DebugLogger debugLogger = this.getDebugLogger(object);
        if (debugLogger == null) {
            Logger logger = this.getLogger(object);
            if (logger == null) {
                return false;
            }
            return logger.isLoggable((Level)((Object)WLLevel.DEBUG));
        }
        return debugLogger.isDebugEnabled();
    }

    private void convertLegacyDebugSystemProperties() {
        this.mapOldSecurityDebugProperty("ssl.debug", "DebugSecuritySSL");
        this.mapOldSecurityDebugProperty("weblogic.security.SSL.verbose", "DebugSecuritySSL");
        this.mapOldSecurityDebugProperty("weblogic.security.ssl.verbose", "DebugSecuritySSL");
        this.mapOldSecurityDebugProperty("ssl.debugEaten", "DebugSecuritySSLEaten");
        this.mapOldSecurityDebugProperty("weblogic.security.SSL.debugEaten", "DebugSecuritySSLEaten");
        this.mapOldSecurityDebugProperty("weblogic.security.ssl.debugEaten", "DebugSecuritySSLEaten");
        this.mapOldSecurityDebugProperty("weblogic.security.DebugSecurityAtn", "DebugSecurityAtn");
        this.mapOldSecurityDebugProperty("weblogic.security.providers.authentication.WIndowsNTAuthenticator.debug", "DebugSecurityAtn");
        this.mapOldSecurityDebugProperty("weblogic.security.providers.authentication.DebugSecurityAtn", "DebugSecurityAtn");
        this.mapOldSecurityDebugProperty("weblogic.security.realm.debug", "DebugSecurityRealm");
    }

    private void mapOldSecurityDebugProperty(String string, String string2) {
        try {
            String string3 = System.getProperty(string);
            if (string3 == null) {
                return;
            }
            System.setProperty("weblogic.debug." + string2, string3);
        }
        catch (SecurityException securityException) {
            this.appletEnvironment = true;
        }
    }

    public synchronized Object getLogger(String string) {
        LoggerHolder loggerHolder = (LoggerHolder)this.loggers.get(string);
        if (loggerHolder != null) {
            return loggerHolder;
        }
        Logger logger = null;
        DebugLogger debugLogger = null;
        logger = this.getServerLogger();
        if (string != null) {
            if (string.startsWith("Security")) {
                debugLogger = this.getDebugLogger("Debug" + string);
            } else if (string.startsWith("Debug")) {
                debugLogger = this.getDebugLogger(string);
            } else if (string.startsWith(WLS_PACKAGE)) {
                String string2 = string.substring(WLS_PACKAGE_OFFSET);
                if (string2 != null) {
                    if (string2.startsWith("authentication")) {
                        debugLogger = this.getDebugLogger("DebugSecurityAtn");
                    } else if (string2.startsWith("authorization")) {
                        debugLogger = this.getDebugLogger("DebugSecurityAtz");
                    } else if (string2.startsWith("audit")) {
                        debugLogger = this.getDebugLogger("DebugSecurityAuditor");
                    } else if (string2.startsWith("credentials")) {
                        debugLogger = this.getDebugLogger("DebugSecurityCredMap");
                    } else if (string2.startsWith("pk")) {
                        debugLogger = this.getDebugLogger("DebugSecurityKeyStore");
                    } else if (string2.startsWith("profiles")) {
                        debugLogger = this.getDebugLogger("DebugSecurityProfiler");
                    } else if (string2.startsWith("realmadapter")) {
                        debugLogger = this.getDebugLogger("DebugSecurityRealm");
                    } else if (string2.startsWith("saml")) {
                        debugLogger = this.getDebugLogger("DebugSecurityAtn");
                    }
                }
            } else if (string.startsWith(WLES_PACKAGE)) {
                String string3 = string.substring(WLES_PACKAGE_OFFSET);
                if (string3 != null) {
                    if (string3.startsWith("authentication")) {
                        debugLogger = this.getDebugLogger("DebugSecurityAtn");
                    } else if (string3.startsWith("authorization")) {
                        debugLogger = this.getDebugLogger("DebugSecurityAtz");
                    } else if (string3.startsWith("audit")) {
                        debugLogger = this.getDebugLogger("DebugSecurityAuditor");
                    } else if (string3.startsWith("credentials")) {
                        debugLogger = this.getDebugLogger("DebugSecurityCredMap");
                    } else if (string3.startsWith("pk")) {
                        debugLogger = this.getDebugLogger("DebugSecurityKeyStore");
                    } else if (string3.startsWith("profiles")) {
                        debugLogger = this.getDebugLogger("DebugSecurityProfiler");
                    } else if (string3.startsWith("realmadapter")) {
                        debugLogger = this.getDebugLogger("DebugSecurityRealm");
                    } else if (string3.startsWith("saml")) {
                        debugLogger = this.getDebugLogger("DebugSecurityAtn");
                    }
                }
            } else {
                debugLogger = string.startsWith("weblogic.entitlement") ? this.getDebugLogger("DebugSecurityEEngine") : this.getDebugLogger(string);
            }
        }
        if (logger != null || debugLogger != null) {
            loggerHolder = new LoggerHolder(logger, debugLogger);
            this.loggers.put(string, loggerHolder);
        }
        return loggerHolder;
    }

    private Logger getServerLogger() {
        if (this.appletEnvironment) {
            return null;
        }
        try {
            return SecurityEnvironment.getSecurityEnvironment().getServerLogger();
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    private DebugLogger getDebugLogger(String string) {
        if (this.appletEnvironment) {
            return null;
        }
        try {
            return DebugLogger.getDebugLogger((String)string);
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    public void debug(Object object, final Object object2) {
        final DebugLogger debugLogger = this.getDebugLogger(object);
        if (debugLogger == null) {
            final Logger logger = this.getLogger(object);
            if (logger != null) {
                this.run(new PrivilegedAction(){

                    public Object run() {
                        logger.log((Level)((Object)WLLevel.DEBUG), object2.toString());
                        return null;
                    }
                });
            }
            return;
        }
        this.run(new PrivilegedAction(){

            public Object run() {
                debugLogger.debug(object2.toString());
                return null;
            }
        });
    }

    public void debug(Object object, final Object object2, final Throwable throwable) {
        final DebugLogger debugLogger = this.getDebugLogger(object);
        if (debugLogger == null) {
            final Logger logger = this.getLogger(object);
            if (logger != null) {
                this.run(new PrivilegedAction(){

                    public Object run() {
                        logger.log((Level)((Object)WLLevel.DEBUG), object2.toString(), throwable);
                        return null;
                    }
                });
            }
            return;
        }
        this.run(new PrivilegedAction(){

            public Object run() {
                debugLogger.debug(object2.toString(), throwable);
                return null;
            }
        });
    }

    public void info(Object object, final Object object2) {
        final Logger logger = this.getLogger(object);
        if (logger != null) {
            this.run(new PrivilegedAction(){

                public Object run() {
                    logger.log((Level)((Object)WLLevel.INFO), object2.toString());
                    return null;
                }
            });
        }
    }

    public void info(Object object, final Object object2, final Throwable throwable) {
        final Logger logger = this.getLogger(object);
        if (logger != null) {
            this.run(new PrivilegedAction(){

                public Object run() {
                    logger.log((Level)((Object)WLLevel.INFO), object2.toString(), throwable);
                    return null;
                }
            });
        }
    }

    public void warn(Object object, final Object object2) {
        final Logger logger = this.getLogger(object);
        if (logger != null) {
            this.run(new PrivilegedAction(){

                public Object run() {
                    logger.log((Level)((Object)WLLevel.WARNING), object2.toString());
                    return null;
                }
            });
        }
    }

    public void warn(Object object, final Object object2, final Throwable throwable) {
        final Logger logger = this.getLogger(object);
        if (logger != null) {
            this.run(new PrivilegedAction(){

                public Object run() {
                    logger.log((Level)((Object)WLLevel.WARNING), object2.toString(), throwable);
                    return null;
                }
            });
        }
    }

    public void error(Object object, final Object object2) {
        final Logger logger = this.getLogger(object);
        if (logger != null) {
            this.run(new PrivilegedAction(){

                public Object run() {
                    logger.log((Level)((Object)WLLevel.ERROR), object2.toString());
                    return null;
                }
            });
        }
    }

    public void error(Object object, final Object object2, final Throwable throwable) {
        final Logger logger = this.getLogger(object);
        if (logger != null) {
            this.run(new PrivilegedAction(){

                public Object run() {
                    logger.log((Level)((Object)WLLevel.ERROR), object2.toString(), throwable);
                    return null;
                }
            });
        }
    }

    public void severe(Object object, final Object object2) {
        final Logger logger = this.getLogger(object);
        if (logger != null) {
            this.run(new PrivilegedAction(){

                public Object run() {
                    logger.log((Level)((Object)WLLevel.CRITICAL), object2.toString());
                    return null;
                }
            });
        }
    }

    public void severe(Object object, final Object object2, final Throwable throwable) {
        final Logger logger = this.getLogger(object);
        if (logger != null) {
            this.run(new PrivilegedAction(){

                public Object run() {
                    logger.log((Level)((Object)WLLevel.CRITICAL), object2.toString(), throwable);
                    return null;
                }
            });
        }
    }

    private final DebugLogger getDebugLogger(Object object) {
        if (object == null) {
            return null;
        }
        return ((LoggerHolder)object).getDebugLogger();
    }

    private final Logger getLogger(Object object) {
        if (object == null) {
            return null;
        }
        return ((LoggerHolder)object).getLogger();
    }

    private class LoggerHolder {
        private Logger logger = null;
        private DebugLogger debugLogger = null;

        private LoggerHolder() {
        }

        public LoggerHolder(Logger logger, DebugLogger debugLogger) {
            this.logger = logger;
            this.debugLogger = debugLogger;
        }

        public final Logger getLogger() {
            return this.logger;
        }

        public final DebugLogger getDebugLogger() {
            return this.debugLogger;
        }
    }
}

