/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.ntrealm;

import java.security.AccessController;
import java.util.Enumeration;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import weblogic.kernel.Kernel;
import weblogic.management.configuration.NTRealmMBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.SecurityLogger;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.ntrealm.NTRealm;
import weblogic.security.ntrealm.NTResumeEnum;
import weblogic.security.ntrealm.NTUserGroupEnum;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.AssertionError;

public final class NTDelegate {
    private static final boolean verbose = Boolean.getBoolean("weblogic.security.ntrealm.verbose");
    private static final String NT_PROPS = "ntrealm.properties";
    private static final String NT_PREFIX = "weblogic.security.ntrealm.";
    private static final String NT_DOMAIN = ".";
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private String domain;
    private String[] altDomains;
    private boolean useAltDomain;
    private static boolean ignoreBadDomainName;
    private NTRealm owner;
    private static boolean libLoaded;

    public NTDelegate(NTRealm nTRealm) {
        Object object;
        Object object2;
        this.owner = nTRealm;
        String string = null;
        try {
            if (Kernel.isServer() && (object2 = ManagementService.getRuntimeAccess(kernelId).getDomain().getSecurity()) != null) {
                object = (NTRealmMBean)object2.getRealm().getCachingRealm().getBasicRealm();
                string = object.getPrimaryDomain();
            }
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
        boolean bl = this.useAltDomain = string != null;
        if (this.useAltDomain) {
            object2 = new Vector();
            object = new StringTokenizer(string, ",");
            while (((StringTokenizer)object).hasMoreTokens()) {
                ((Vector)object2).add(((StringTokenizer)object).nextToken().trim());
            }
            int n = ((Vector)object2).size();
            if (n > 0) {
                this.altDomains = new String[n];
                for (int i = 0; i < n; ++i) {
                    this.altDomains[i] = ((Vector)object2).elementAt(i).toString();
                }
            }
            if (this.altDomains == null) {
                throw new SecurityException("Incorrectly configured NTRealmMBean, null domain.");
            }
            this.cleanAltDomains();
        }
        if (!libLoaded) {
            this.domain = NTDelegate.loadlib();
        }
        if (this.owner.log != null) {
            this.owner.log.debug("<NTRealm><I> Primary Domain Controller = " + this.domain);
            if (this.useAltDomain) {
                object2 = new StringBuffer("<NTRealm><I> Alternate Primary Domain Controllers: ");
                for (int i = 0; i < this.altDomains.length; ++i) {
                    ((StringBuffer)object2).append(this.altDomains[i] + " ");
                }
                this.owner.log.debug(((StringBuffer)object2).toString());
            }
        }
    }

    private void cleanAltDomains() {
        for (int i = 0; i < this.altDomains.length; ++i) {
            if (this.altDomains[i].startsWith("\\\\")) continue;
            this.altDomains[i] = this.altDomains[i].startsWith("\\") ? "\\" + this.altDomains[i] : "\\\\" + this.altDomains[i];
        }
    }

    void setAltDomain(String string) {
        if (this.altDomains == null) {
            this.altDomains = new String[1];
        }
        this.altDomains[0] = string;
        this.useAltDomain = this.altDomains[0] != null;
    }

    void addAltDomains(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.addAltDomain(stringTokenizer.nextToken().trim());
        }
        this.cleanAltDomains();
    }

    private void addAltDomain(String string) {
        if (this.altDomains == null) {
            this.altDomains = new String[1];
            this.altDomains[0] = string;
        } else {
            String[] stringArray = new String[this.altDomains.length + 1];
            for (int i = 0; i < this.altDomains.length; ++i) {
                stringArray[i] = this.altDomains[i];
            }
            stringArray[this.altDomains.length + 1] = string;
            this.altDomains = stringArray;
        }
        this.useAltDomain = this.altDomains[0] != null;
    }

    String getAltDomain() {
        if (this.altDomains != null && this.altDomains[0] != null) {
            return this.altDomains[0];
        }
        return null;
    }

    String[] getAltDomains() {
        if (this.altDomains != null) {
            return this.altDomains;
        }
        return null;
    }

    String getAltDomain(int n) {
        if (this.altDomains != null && this.altDomains[n] != null) {
            return this.altDomains[n];
        }
        return null;
    }

    String getDomain() {
        return this.domain;
    }

    boolean getUseAltDomain() {
        return this.useAltDomain;
    }

    public native boolean authenticate(String var1, String var2);

    private native boolean nativeGetUser(String var1, String var2);

    public boolean getUser(String string) {
        if (this.useAltDomain) {
            if (this.altDomains == null) {
                return this.nativeGetUser(string, null);
            }
            for (int i = 0; i < this.altDomains.length; ++i) {
                if (!this.nativeGetUser(string, this.altDomains[i])) continue;
                return true;
            }
        } else {
            return this.nativeGetUser(string, null);
        }
        return false;
    }

    public Enumeration getUserNames() {
        if (this.useAltDomain) {
            NTResumeEnum nTResumeEnum;
            block3: {
                nTResumeEnum = null;
                try {
                    nTResumeEnum = new NTResumeEnum(this.altDomains, true);
                }
                catch (RuntimeException runtimeException) {
                    if (ignoreBadDomainName) break block3;
                    throw runtimeException;
                }
            }
            return nTResumeEnum;
        }
        return new NTResumeEnum(null, true);
    }

    public Enumeration getGroupNames() {
        if (this.useAltDomain) {
            NTResumeEnum nTResumeEnum;
            block3: {
                nTResumeEnum = null;
                try {
                    nTResumeEnum = new NTResumeEnum(this.altDomains, false);
                }
                catch (RuntimeException runtimeException) {
                    if (ignoreBadDomainName) break block3;
                    throw runtimeException;
                }
            }
            return nTResumeEnum;
        }
        return new NTResumeEnum(null, false);
    }

    public Enumeration getGroupsForUser(String string) {
        if (this.useAltDomain) {
            return new NTUserGroupEnum(string, this.altDomains);
        }
        return new NTUserGroupEnum(string, null);
    }

    public boolean isUserInGroup(String string, String string2) {
        if (string.endsWith("$")) {
            return false;
        }
        try {
            Enumeration enumeration = this.getGroupsForUser(string);
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                if (!string2.equals(string3)) continue;
                return true;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return false;
    }

    private static native String initFields();

    private static synchronized String loadlib() {
        String string = "wlntrealm";
        String string2 = System.getProperty("java.vendor");
        String string3 = null;
        if (string2 != null && string2.toLowerCase(Locale.ENGLISH).indexOf("microsoft") != -1) {
            string = "wlntrealm_ms";
        }
        try {
            ignoreBadDomainName = Boolean.getBoolean("weblogic.security.ntrealm.ignoreBadDomainName");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            System.loadLibrary(string);
            string3 = NTDelegate.initFields();
            NTResumeEnum.initFields();
            NTUserGroupEnum.initFields();
        }
        catch (SecurityException securityException) {
            SecurityLogger.logStackTrace((Throwable)securityException);
            if (!ignoreBadDomainName) {
                throw new SecurityException(securityException.getMessage() + " -- bad domain name");
            }
            System.out.println("<NTRealm><E> Ignoring Bad Domain Name: " + securityException.getMessage());
        }
        libLoaded = true;
        return string3;
    }

    static {
        libLoaded = false;
    }
}

