/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.ntrealm;

import java.security.AccessController;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.Vector;
import weblogic.kernel.Kernel;
import weblogic.logging.LogOutputStream;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.AbstractListableRealm;
import weblogic.security.acl.BasicRealm;
import weblogic.security.acl.DebuggableRealm;
import weblogic.security.acl.DefaultUserInfoImpl;
import weblogic.security.acl.User;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.ntrealm.NTDelegate;
import weblogic.security.service.PrivilegedActions;

public final class NTRealm
extends AbstractListableRealm
implements DebuggableRealm {
    private String name;
    LogOutputStream log;
    private NTDelegate ntDelegate = new NTDelegate(this);
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public NTRealm() {
        super("NT Realm");
        ServerMBean serverMBean = null;
        if (Kernel.isServer()) {
            serverMBean = ManagementService.getRuntimeAccess(kernelId).getServer();
        }
        if (serverMBean != null) {
            this.setDebug(serverMBean.getServerDebug().getDebugSecurityRealm());
        } else {
            this.setDebug(false);
        }
    }

    public User getUser(String string) {
        if (this.log != null) {
            this.log.debug("getUser(\"" + string + "\")");
        }
        return this.ntDelegate.getUser(string) ? new NTUser(string) : null;
    }

    protected User authUserPassword(String string, String string2) {
        NTUser nTUser = null;
        if (this.log != null) {
            this.log.debug("authUserPassword(\"" + string + ")");
        }
        if (this.ntDelegate.authenticate(string, string2)) {
            nTUser = new NTUser(string);
        }
        return nTUser;
    }

    public Group getGroup(String string) {
        Enumeration enumeration;
        if (this.log != null) {
            this.log.debug("getGroup(" + string + ")");
        }
        if ((enumeration = this.ntDelegate.getGroupNames()) != null) {
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                if (!string2.equals(string)) continue;
                return new NTGroup(string);
            }
        }
        return super.getGroup(string);
    }

    public Enumeration getUsers() {
        if (this.log != null) {
            this.log.debug("getUsers");
        }
        return new Enumeration(){
            private Enumeration users;

            private Enumeration getUsers() {
                if (this.users == null) {
                    this.users = NTRealm.this.ntDelegate.getUserNames();
                }
                return this.users;
            }

            public boolean hasMoreElements() {
                Enumeration enumeration = this.getUsers();
                if (enumeration != null) {
                    return enumeration.hasMoreElements();
                }
                return false;
            }

            public Object nextElement() {
                String string = (String)this.getUsers().nextElement();
                return new NTUser(string);
            }
        };
    }

    public Enumeration getGroups() {
        if (this.log != null) {
            this.log.debug("getGroups");
        }
        return new Enumeration(){
            private Enumeration groups;

            private Enumeration getGroups() {
                if (this.groups == null) {
                    this.groups = NTRealm.this.ntDelegate.getGroupNames();
                }
                return this.groups;
            }

            public boolean hasMoreElements() {
                Enumeration enumeration = this.getGroups();
                if (enumeration != null) {
                    return enumeration.hasMoreElements();
                }
                return false;
            }

            public Object nextElement() {
                String string = (String)this.getGroups().nextElement();
                return NTRealm.this.getGroup(string);
            }
        };
    }

    public void setDebug(boolean bl) {
        if (bl && this.log == null) {
            this.log = new LogOutputStream("NTRealm");
        }
        if (!bl) {
            this.log = null;
        }
    }

    public LogOutputStream getDebugLog() {
        return this.log;
    }

    public static void main(String[] stringArray) throws Exception {
        Object e;
        int n;
        Object object;
        User user;
        if (stringArray.length < 2) {
            System.err.println("usage: NTDelegate username password <domain>");
            return;
        }
        NTRealm nTRealm = new NTRealm();
        if (stringArray.length >= 3) {
            nTRealm.ntDelegate.addAltDomains(stringArray[2]);
        }
        System.out.println("NTDelegate using Primary Domain Controller " + nTRealm.ntDelegate.getDomain());
        if (nTRealm.ntDelegate.getUseAltDomain() && (user = nTRealm.ntDelegate.getAltDomains()) != null) {
            object = new StringBuffer("NTDelegate using Alternate Primary Domain Controllers: ");
            for (n = 0; n < ((User)user).length; ++n) {
                ((StringBuffer)object).append((String)user[n]);
                ((StringBuffer)object).append(" ");
            }
            System.out.println(((StringBuffer)object).toString());
        }
        user = nTRealm.authenticate(new DefaultUserInfoImpl(stringArray[0], stringArray[1]));
        System.out.println("auth ? " + user);
        System.out.println("enum users:");
        object = nTRealm.getUsers();
        n = 1;
        while (object.hasMoreElements()) {
            e = object.nextElement();
            System.out.println("   #" + n++ + " '" + e + "'");
        }
        System.out.println("enum groups:");
        object = nTRealm.getGroups();
        n = 1;
        while (object.hasMoreElements()) {
            e = object.nextElement();
            System.out.println("   #" + n++ + " '" + e + "'");
        }
        System.out.println("enum groups for user: " + stringArray[0]);
        object = nTRealm.ntDelegate.getGroupsForUser(stringArray[0]);
        n = 1;
        while (object.hasMoreElements()) {
            e = object.nextElement();
            System.out.println("   #" + n++ + " '" + e + "'");
        }
        System.out.println("is user " + stringArray[0] + " an Administrator? " + nTRealm.ntDelegate.isUserInGroup(stringArray[0], "Administrators"));
        System.out.println("done");
    }

    public class NTGroup
    implements Group {
        private String name;

        NTGroup(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public boolean addMember(Principal principal) {
            throw new SecurityException("Cannot add members to groups in realm " + NTRealm.this.getName());
        }

        public boolean removeMember(Principal principal) {
            throw new SecurityException("Cannot remove members to groups in realm " + NTRealm.this.getName());
        }

        public Enumeration members() {
            if (NTRealm.this.log != null) {
                NTRealm.this.log.debug("members()");
            }
            return new Enumeration(){
                private Enumeration enum_;

                private Enumeration getEnum() {
                    if (this.enum_ == null) {
                        Vector<String> vector = new Vector<String>();
                        Enumeration enumeration = NTRealm.this.ntDelegate.getUserNames();
                        while (enumeration.hasMoreElements()) {
                            String string = (String)enumeration.nextElement();
                            if (!NTRealm.this.ntDelegate.isUserInGroup(string, NTGroup.this.getName())) continue;
                            vector.addElement(string);
                        }
                        this.enum_ = vector.elements();
                    }
                    return this.enum_;
                }

                public boolean hasMoreElements() {
                    return this.getEnum().hasMoreElements();
                }

                public Object nextElement() {
                    String string = (String)this.getEnum().nextElement();
                    return NTRealm.this.getUser(string);
                }
            };
        }

        public boolean isMember(Principal principal) {
            if (NTRealm.this.log != null) {
                NTRealm.this.log.debug("isMember(\"" + principal.getName() + "\")");
            }
            return NTRealm.this.ntDelegate.isUserInGroup(principal.getName(), this.getName());
        }
    }

    public class NTUser
    extends User {
        private static final long serialVersionUID = -3724078631048539618L;

        NTUser(String string) {
            super(string);
        }

        public BasicRealm getRealm() {
            return NTRealm.this;
        }
    }
}

