/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.ntrealm;

import java.security.AccessController;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import weblogic.kernel.Kernel;
import weblogic.management.configuration.NTRealmMBean;
import weblogic.management.configuration.SecurityMBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

class NTResumeEnum
implements Enumeration {
    private String[] list;
    private int preferredMaxBytes;
    private int resumeHandle;
    private String altDomain;
    private boolean useAltDomain;
    private boolean enumUsers;
    private boolean enumGlobalGroups;
    private int index;
    private boolean depleted;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    static native void initFields();

    private NTResumeEnum() {
        SecurityMBean securityMBean = null;
        if (Kernel.isServer()) {
            securityMBean = ManagementService.getRuntimeAccess(kernelId).getDomain().getSecurity();
        }
        if (securityMBean != null) {
            NTRealmMBean nTRealmMBean = (NTRealmMBean)securityMBean.getRealm().getCachingRealm().getBasicRealm();
            this.preferredMaxBytes = nTRealmMBean.getPreferredMaxBytes();
        } else {
            this.preferredMaxBytes = 10240;
        }
        this.resumeHandle = 0;
        this.depleted = false;
    }

    NTResumeEnum(String[] stringArray, boolean bl) {
        this();
        this.enumUsers = bl;
        this.enumGlobalGroups = true;
        this.useAltDomain = false;
        this.populate();
        if (stringArray != null && stringArray.length > 0) {
            int n;
            this.enumGlobalGroups = true;
            this.useAltDomain = true;
            Vector<String> vector = new Vector<String>();
            for (n = 0; n < this.list.length; ++n) {
                if (this.list[n].endsWith("$") || vector.contains(this.list[n]) || this.list[n].equals("None")) continue;
                vector.addElement(this.list[n]);
            }
            for (n = 0; n < stringArray.length; ++n) {
                this.altDomain = stringArray[n];
                this.depleted = false;
                this.list = null;
                this.populate();
                for (int i = 0; i < this.list.length; ++i) {
                    if (this.list[i].endsWith("$") || vector.contains(this.list[i]) || this.list[i].equals("None")) continue;
                    vector.addElement(this.list[i]);
                }
            }
            this.list = new String[vector.size()];
            n = 0;
            while (!vector.isEmpty()) {
                this.list[n++] = (String)vector.firstElement();
                vector.removeElementAt(0);
            }
        }
    }

    public boolean hasMoreElements() {
        if (this.list == null) {
            return false;
        }
        if (this.list != null && this.index < this.list.length) {
            return true;
        }
        this.populate();
        return !this.depleted;
    }

    public Object nextElement() {
        if (!this.hasMoreElements()) {
            throw new NoSuchElementException();
        }
        String string = this.list[this.index++];
        if (this.depleted && this.index == this.list.length) {
            this.list = null;
        }
        return string;
    }

    private void populate() {
        if (this.depleted) {
            return;
        }
        this.list = this.populate0();
        if (this.list == null) {
            return;
        }
        if (!this.enumUsers) {
            int n;
            this.enumGlobalGroups = false;
            String[] stringArray = this.populate0();
            if (stringArray == null) {
                return;
            }
            String[] stringArray2 = this.list;
            this.list = new String[stringArray2.length + stringArray.length];
            for (n = 0; n < stringArray2.length; ++n) {
                this.list[n] = stringArray2[n];
            }
            for (n = 0; n < stringArray.length; ++n) {
                this.list[n + stringArray2.length] = stringArray[n];
            }
        }
        this.index = 0;
    }

    private native String[] populate0();
}

