/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.pk;

import java.security.cert.CertPathParameters;
import java.security.cert.X509Certificate;
import weblogic.security.SecurityLogger;
import weblogic.security.pk.CertPathSelector;
import weblogic.security.service.ContextHandler;

public final class CertPathBuilderParameters
implements CertPathParameters {
    private String realmName;
    private CertPathSelector selector;
    private X509Certificate[] trustedCAs;
    private ContextHandler context;

    public CertPathBuilderParameters(String string, CertPathSelector certPathSelector, X509Certificate[] x509CertificateArray, ContextHandler contextHandler) {
        if (string == null || string.length() < 1) {
            throw new IllegalArgumentException(SecurityLogger.getCertPathBuilderParametersIllegalRealm());
        }
        if (certPathSelector == null) {
            throw new IllegalArgumentException(SecurityLogger.getCertPathBuilderParametersIllegalCertPathSelector());
        }
        this.realmName = string;
        this.selector = certPathSelector;
        this.trustedCAs = x509CertificateArray;
        this.context = contextHandler;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public CertPathSelector getSelector() {
        return this.selector;
    }

    public X509Certificate[] getTrustedCAs() {
        return this.trustedCAs;
    }

    public ContextHandler getContext() {
        return this.context;
    }

    public Object clone() {
        throw new UnsupportedOperationException();
    }
}

