/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.pk;

import java.security.cert.CertPathParameters;
import java.security.cert.X509Certificate;
import weblogic.security.SecurityLogger;
import weblogic.security.service.ContextHandler;

public final class CertPathValidatorParameters
implements CertPathParameters {
    private String realmName;
    private X509Certificate[] trustedCAs;
    private ContextHandler context;

    public CertPathValidatorParameters(String string, X509Certificate[] x509CertificateArray, ContextHandler contextHandler) {
        if (string == null || string.length() < 1) {
            throw new IllegalArgumentException(SecurityLogger.getCertPathValidatorParametersIllegalRealm());
        }
        this.realmName = string;
        this.trustedCAs = x509CertificateArray;
        this.context = contextHandler;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public X509Certificate[] getTrustedCAs() {
        return this.trustedCAs;
    }

    public ContextHandler getContext() {
        return this.context;
    }

    public Object clone() {
        throw new UnsupportedOperationException();
    }
}

