/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.pk;

import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateFactorySpi;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import weblogic.logging.Loggable;
import weblogic.security.SecurityInitializationException;
import weblogic.security.SecurityLogger;
import weblogic.security.utils.X509Utils;

public class X509CertificateFactory
extends CertificateFactorySpi {
    private static final String MY_JDK_SECURITY_PROVIDER_NAME = "WLSX509CertificateFactoryProvider";
    private static final String FACTORY_ALGORITHM = "X.509";
    private static CertificateFactory standardFactory;

    public static void register() {
        if (Security.getProvider(MY_JDK_SECURITY_PROVIDER_NAME) != null) {
            return;
        }
        if (!Boolean.parseBoolean(System.getProperty("weblogic.security.RegisterX509CertificateFactory", "true"))) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                int n = Security.insertProviderAt(new MyJDKSecurityProvider(), 1);
                if (n != 1) {
                    Loggable loggable = SecurityLogger.logCouldNotRegisterWLSX509CertificateFactoryAsDefaultFactoryLoggable();
                    loggable.log();
                    throw new SecurityInitializationException(loggable.getMessageText());
                }
                return null;
            }
        });
    }

    private synchronized CertificateFactory getStandardFactory() {
        if (standardFactory == null) {
            Provider[] providerArray = Security.getProviders();
            for (int i = 0; standardFactory == null && providerArray != null && i < providerArray.length; ++i) {
                Provider provider = providerArray[i];
                if (MY_JDK_SECURITY_PROVIDER_NAME.equals(provider.getName())) continue;
                try {
                    standardFactory = CertificateFactory.getInstance(FACTORY_ALGORITHM, provider);
                    continue;
                }
                catch (CertificateException certificateException) {
                    // empty catch block
                }
            }
            if (standardFactory == null) {
                throw new AssertionError((Object)"The WLS X.509 CertificateFactory could not find another X.509 CertificateFactory to delegate to");
            }
        }
        return standardFactory;
    }

    public CertPath engineGenerateCertPath(InputStream inputStream) throws CertificateException {
        String string = (String)this.engineGetCertPathEncodings().next();
        return this.engineGenerateCertPath(inputStream, string);
    }

    public CertPath engineGenerateCertPath(InputStream inputStream, String string) throws CertificateException {
        CertPath certPath = this.getStandardFactory().generateCertPath(inputStream, string);
        return "PKCS7".equals(string) ? X509CertificateFactory.orderCertPath(certPath) : certPath;
    }

    public CertPath engineGenerateCertPath(List list) throws CertificateException {
        return this.getStandardFactory().generateCertPath(list);
    }

    public Certificate engineGenerateCertificate(InputStream inputStream) throws CertificateException {
        return this.getStandardFactory().generateCertificate(inputStream);
    }

    public Iterator engineGetCertPathEncodings() {
        return this.getStandardFactory().getCertPathEncodings();
    }

    public Collection engineGenerateCertificates(InputStream inputStream) throws CertificateException {
        return this.getStandardFactory().generateCertificates(inputStream);
    }

    public CRL engineGenerateCRL(InputStream inputStream) throws CRLException {
        return this.getStandardFactory().generateCRL(inputStream);
    }

    public Collection engineGenerateCRLs(InputStream inputStream) throws CRLException {
        return this.getStandardFactory().generateCRLs(inputStream);
    }

    private static X509Certificate findIssuer(X509Certificate[] x509CertificateArray, X509Certificate x509Certificate) {
        for (int i = 0; i < x509CertificateArray.length; ++i) {
            X509Certificate x509Certificate2 = x509CertificateArray[i];
            if (x509Certificate2 == null || !X509Utils.isIssuedBy(x509Certificate, x509Certificate2)) continue;
            x509CertificateArray[i] = null;
            return x509Certificate2;
        }
        return null;
    }

    private static X509Certificate findIssued(X509Certificate[] x509CertificateArray, X509Certificate x509Certificate) {
        for (int i = 0; i < x509CertificateArray.length; ++i) {
            X509Certificate x509Certificate2 = x509CertificateArray[i];
            if (x509Certificate2 == null || !X509Utils.isIssuedBy(x509Certificate2, x509Certificate)) continue;
            x509CertificateArray[i] = null;
            return x509Certificate2;
        }
        return null;
    }

    private static CertPath orderCertPath(CertPath certPath) throws CertificateException {
        if (X509Utils.isOrdered(certPath)) {
            return certPath;
        }
        X509Certificate[] x509CertificateArray = X509Utils.getCertificates(certPath);
        Vector<X509Certificate> vector = new Vector<X509Certificate>(x509CertificateArray.length);
        vector.add(x509CertificateArray[0]);
        x509CertificateArray[0] = null;
        X509Certificate x509Certificate = (X509Certificate)vector.lastElement();
        while (x509Certificate != null && !X509Utils.isSelfSigned(x509Certificate)) {
            if ((x509Certificate = X509CertificateFactory.findIssuer(x509CertificateArray, x509Certificate)) == null) continue;
            vector.add(x509Certificate);
        }
        x509Certificate = (X509Certificate)vector.firstElement();
        while (x509Certificate != null) {
            if ((x509Certificate = X509CertificateFactory.findIssued(x509CertificateArray, x509Certificate)) == null) continue;
            vector.add(0, x509Certificate);
        }
        if (vector.size() < x509CertificateArray.length) {
            return certPath;
        }
        return CertificateFactory.getInstance(FACTORY_ALGORITHM).generateCertPath(new ArrayList(vector));
    }

    private static class MyJDKSecurityProvider
    extends Provider {
        private MyJDKSecurityProvider() {
            super(X509CertificateFactory.MY_JDK_SECURITY_PROVIDER_NAME, 1.0, "WebLogic JDK CertPath provider");
            this.put("CertificateFactory.X.509", "weblogic.security.pk.X509CertificateFactory");
        }
    }
}

