/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.pki.revocation.common;

import java.io.File;
import java.math.BigInteger;
import java.net.URI;
import java.security.PrivateKey;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import javax.security.auth.x500.X500Principal;
import weblogic.security.pki.revocation.common.CertRevocCheckMethodList;
import weblogic.security.pki.revocation.common.CertRevocStatus;
import weblogic.security.pki.revocation.common.DefaultLogListener;
import weblogic.security.pki.revocation.common.LogListener;
import weblogic.security.pki.revocation.common.Timer;
import weblogic.security.pki.revocation.common.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCertRevocContext {
    public static final Boolean DEFAULT_CHECKING_ENABLED = Boolean.FALSE;
    public static final Boolean DEFAULT_CHECKING_DISABLED = Boolean.FALSE;
    public static final Boolean DEFAULT_FAIL_ON_UNKNOWN_REVOC_STATUS = Boolean.FALSE;
    public static final CertRevocCheckMethodList.SelectableMethodList DEFAULT_SELECTABLE_METHOD_LIST = CertRevocCheckMethodList.SelectableMethodList.OCSP_THEN_CRL;
    public static final CertRevocCheckMethodList DEFAULT_METHOD_ORDER = new CertRevocCheckMethodList(DEFAULT_SELECTABLE_METHOD_LIST);
    public static final URI DEFAULT_OCSP_RESPONDER_URL = null;
    public static final String DEFAULT_OCSP_RESPONDER_URL_STRING = null;
    public static final AttributeUsage DEFAULT_OCSP_RESPONDER_URL_USAGE = AttributeUsage.FAILOVER;
    public static final X509Certificate DEFAULT_OCSP_RESPONDER_TRUSTED_CERT = null;
    public static final Boolean DEFAULT_OCSP_NONCE_ENABLED = Boolean.FALSE;
    public static final PrivateKey DEFAULT_OCSP_REQUEST_SIGNING_PRIVATE_KEY = null;
    public static final String DEFAULT_OCSP_REQUEST_SIGNING_PRIVATE_KEY_ALIAS = null;
    public static final X509Certificate DEFAULT_OCSP_REQUEST_SIGNING_CERT = null;
    public static final Boolean DEFAULT_OCSP_RESPONSE_CACHE_ENABLED = Boolean.TRUE;
    public static final Integer DEFAULT_OCSP_RESPONSE_CACHE_CAPACITY = 1024;
    public static final Integer DEFAULT_OCSP_RESPONSE_CACHE_REFRESH_PERIOD_PERCENT = 100;
    public static final Long DEFAULT_OCSP_RESPONSE_TIMEOUT = 10L;
    public static final long MIN_OCSP_RESPONSE_TIMEOUT = 1L;
    public static final long MAX_OCSP_RESPONSE_TIMEOUT = 300L;
    public static final Integer DEFAULT_OCSP_TIME_TOLERANCE = 0;
    public static final int MIN_OCSP_TIME_TOLERANCE = 0;
    public static final int MAX_OCSP_TIME_TOLERANCE = 900;
    public static final CrlCacheType DEFAULT_CRL_CACHE_TYPE = CrlCacheType.FILE;
    public static final File DEFAULT_CRL_CACHE_IMPORT_DIR = null;
    public static final File DEFAULT_CRL_CACHE_TYPE_FILE_DIR = null;
    public static final String DEFAULT_CRL_CACHE_TYPE_LDAP_HOST_NAME = null;
    public static final Integer DEFAULT_CRL_CACHE_TYPE_LDAP_PORT = -1;
    public static final Integer DEFAULT_CRL_CACHE_TYPE_LDAP_SEARCH_TIMEOUT = 10;
    public static final int MIN_CRL_CACHE_TYPE_LDAP_SEARCH_TIMEOUT = 1;
    public static final int MAX_CRL_CACHE_TYPE_LDAP_SEARCH_TIMEOUT = 300;
    public static final Integer DEFAULT_CRL_CACHE_REFRESH_PERIOD_PERCENT = 100;
    public static final Boolean DEFAULT_CRL_DP_ENABLED = Boolean.TRUE;
    public static final Long DEFAULT_CRL_DP_DOWNLOAD_TIMEOUT = 10L;
    public static final long MIN_CRL_DP_DOWNLOAD_TIMEOUT = 1L;
    public static final long MAX_CRL_DP_DOWNLOAD_TIMEOUT = 300L;
    public static final Boolean DEFAULT_CRL_DP_BACKGROUND_DOWNLOAD_ENABLED = Boolean.FALSE;
    public static final URI DEFAULT_CRL_DP_URL = null;
    public static final String DEFAULT_CRL_DP_URL_STRING = null;
    public static final AttributeUsage DEFAULT_CRL_DP_URL_USAGE = AttributeUsage.FAILOVER;
    private static final String REVOCATION_SUB_DIRECTORY_NAME = "certrevocation";
    private static final String REVOCATION_CRLCACHE_SUB_DIRECTORY_NAME = "crlcache";
    private static final String REVOCATION_CRLCACHE_STORAGE_SUB_DIRECTORY_NAME = "storage";
    private static final String REVOCATION_CRLCACHE_IMPORT_SUB_DIRECTORY_NAME = "import";
    private final LogListener logListener;
    private final Set<X509Certificate> trustedCerts;

    protected AbstractCertRevocContext(Set<X509Certificate> set, LogListener logListener) {
        try {
            Util.checkNotNull("trustedCerts", set);
            if (set.isEmpty()) {
                throw new IllegalArgumentException("Expected populated set of trusted certificates.");
            }
            this.trustedCerts = Collections.unmodifiableSet(new HashSet<X509Certificate>(set));
            this.logListener = null != logListener ? logListener : DefaultLogListener.getInstance();
        }
        catch (RuntimeException runtimeException) {
            if (logListener.isLoggable(Level.FINE)) {
                logListener.log(Level.FINE, runtimeException, "AbstractCertRevocContext initialization", new Object[0]);
            }
            throw runtimeException;
        }
    }

    public final LogListener getLogListener() {
        return this.logListener;
    }

    public final boolean isLoggable(Level level) {
        return this.getLogListener().isLoggable(level);
    }

    public final void log(Level level, String string, Object ... objectArray) {
        this.getLogListener().log(level, string, objectArray);
    }

    public final void log(Level level, Throwable throwable, String string, Object ... objectArray) {
        this.getLogListener().log(level, throwable, string, objectArray);
    }

    public abstract void logAttemptingCertRevocCheck(X500Principal var1);

    public abstract void logUnknownCertRevocStatusNoFail(X500Principal var1);

    public abstract void logCertRevocStatus(CertRevocStatus var1);

    public abstract void logIgnoredNonceCertRevocStatus(CertRevocStatus var1);

    public abstract void logUnknownCertRevocStatusFail(X500Principal var1);

    public abstract void logRevokedCertRevocStatusFail(X500Principal var1);

    public abstract void logNotRevokedCertRevocStatusNotFail(X500Principal var1);

    public final Set<X509Certificate> getTrustedCerts() {
        return this.trustedCerts;
    }

    public final X509Certificate getValidTrustedCert(X500Principal x500Principal) {
        Util.checkNotNull("subject", x500Principal);
        for (X509Certificate x509Certificate : this.getTrustedCerts()) {
            if (null == x509Certificate || !x500Principal.equals(x509Certificate.getSubjectX500Principal()) || !AbstractCertRevocContext.isWithinValidityPeriod(x509Certificate)) continue;
            return x509Certificate;
        }
        return null;
    }

    public final X509Certificate getValidTrustedCert(X500Principal x500Principal, BigInteger bigInteger) {
        Util.checkNotNull("issuer", x500Principal);
        Util.checkNotNull("serialNumber", bigInteger);
        for (X509Certificate x509Certificate : this.getTrustedCerts()) {
            if (null == x509Certificate || !x500Principal.equals(x509Certificate.getIssuerX500Principal()) || !bigInteger.equals(x509Certificate.getSerialNumber()) || !AbstractCertRevocContext.isWithinValidityPeriod(x509Certificate)) continue;
            return x509Certificate;
        }
        return null;
    }

    public abstract void schedule(Runnable var1);

    public abstract Timer scheduleWithFixedDelay(Runnable var1, long var2, long var4);

    public abstract boolean isCheckingEnabled();

    public abstract boolean isCheckingDisabled(X500Principal var1);

    public abstract boolean isFailOnUnknownRevocStatus(X500Principal var1);

    public abstract CertRevocCheckMethodList getMethodOrder(X500Principal var1);

    public abstract URI getOcspResponderUrl(X500Principal var1);

    public abstract AttributeUsage getOcspResponderUrlUsage(X500Principal var1);

    public abstract X509Certificate getOcspResponderTrustedCert(X500Principal var1);

    public abstract boolean isOcspNonceEnabled(X500Principal var1);

    public abstract PrivateKey getOcspRequestSigningPrivateKey(X500Principal var1);

    public abstract X509Certificate getOcspRequestSigningCert(X500Principal var1);

    public abstract boolean isOcspResponseCacheEnabled(X500Principal var1);

    public abstract int getOcspResponseCacheCapacity();

    public abstract int getOcspResponseCacheRefreshPeriodPercent();

    public abstract long getOcspResponseTimeout(X500Principal var1);

    public abstract int getOcspTimeTolerance(X500Principal var1);

    public abstract CrlCacheType getCrlCacheType();

    public abstract File getCrlCacheImportDir();

    public abstract File getCrlCacheTypeFileDir();

    public abstract String getCrlCacheTypeLdapHostname();

    public abstract int getCrlCacheTypeLdapPort();

    public abstract int getCrlCacheTypeLdapSearchTimeout();

    public abstract int getCrlCacheRefreshPeriodPercent();

    public abstract boolean isCrlDpEnabled(X500Principal var1);

    public abstract long getCrlDpDownloadTimeout(X500Principal var1);

    public abstract boolean isCrlDpBackgroundDownloadEnabled(X500Principal var1);

    public abstract URI getCrlDpUrl(X500Principal var1);

    public abstract AttributeUsage getCrlDpUrlUsage(X500Principal var1);

    private static boolean isWithinValidityPeriod(X509Certificate x509Certificate) {
        Util.checkNotNull("X509Certificate", x509Certificate);
        try {
            x509Certificate.checkValidity();
            return true;
        }
        catch (CertificateNotYetValidException certificateNotYetValidException) {
        }
        catch (CertificateExpiredException certificateExpiredException) {
            // empty catch block
        }
        return false;
    }

    private static void checkCrlCacheBaseDirectory(File file) {
        if (null == file) {
            throw new IllegalArgumentException("Unexpected null CRL cache base directory.");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("CRL cache base directory does not exist on the given path \"" + file.getAbsolutePath() + "\".");
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("CRL cache base directory path is not pointing to a directory: \"" + file.getAbsolutePath() + "\".");
        }
    }

    protected static File getCrlCacheStorageDirectory(File file) {
        AbstractCertRevocContext.checkCrlCacheBaseDirectory(file);
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append(REVOCATION_SUB_DIRECTORY_NAME);
        stringBuilder.append(File.separator);
        stringBuilder.append(REVOCATION_CRLCACHE_SUB_DIRECTORY_NAME);
        stringBuilder.append(File.separator);
        stringBuilder.append(REVOCATION_CRLCACHE_STORAGE_SUB_DIRECTORY_NAME);
        String string = stringBuilder.toString();
        File file2 = new File(file, string);
        return file2;
    }

    protected static File getCrlCacheImportDirectory(File file) {
        AbstractCertRevocContext.checkCrlCacheBaseDirectory(file);
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append(REVOCATION_SUB_DIRECTORY_NAME);
        stringBuilder.append(File.separator);
        stringBuilder.append(REVOCATION_CRLCACHE_SUB_DIRECTORY_NAME);
        stringBuilder.append(File.separator);
        stringBuilder.append(REVOCATION_CRLCACHE_IMPORT_SUB_DIRECTORY_NAME);
        String string = stringBuilder.toString();
        File file2 = new File(file, string);
        return file2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AttributeUsage {
        FAILOVER,
        OVERRIDE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CrlCacheType {
        FILE,
        LDAP;

    }
}

