/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.pki.revocation.common;

import java.io.File;
import java.net.URI;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import javax.security.auth.x500.X500Principal;
import weblogic.security.pki.revocation.common.AbstractCertRevocContext;
import weblogic.security.pki.revocation.common.CertRevocCheckMethodList;
import weblogic.security.pki.revocation.common.CertRevocStatus;
import weblogic.security.pki.revocation.common.Timer;
import weblogic.security.pki.revocation.common.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CachedCertRevocContext
extends AbstractCertRevocContext {
    private final Attribute<Boolean> checkingEnabled = new Attribute<Boolean>(DEFAULT_CHECKING_ENABLED, null, null);
    private final CaAttribute<Boolean> checkingDisabled = new CaAttribute<Boolean>(DEFAULT_CHECKING_DISABLED, null, null);
    private final CaAttribute<Boolean> failOnUnknownRevocStatus = new CaAttribute<Boolean>(DEFAULT_FAIL_ON_UNKNOWN_REVOC_STATUS, null, null);
    private final CaAttribute<CertRevocCheckMethodList> methodOrder = new CaAttribute<CertRevocCheckMethodList>(DEFAULT_METHOD_ORDER, null, null);
    private final CaAttribute<URI> ocspResponderUrl = new CaAttribute<URI>(DEFAULT_OCSP_RESPONDER_URL, null, null);
    private final CaAttribute<AbstractCertRevocContext.AttributeUsage> ocspResponderUrlUsage = new CaAttribute<AbstractCertRevocContext.AttributeUsage>(DEFAULT_OCSP_RESPONDER_URL_USAGE, null, null);
    private final CaAttribute<X509Certificate> ocspResponderTrustedCert = new CaAttribute<X509Certificate>(DEFAULT_OCSP_RESPONDER_TRUSTED_CERT, null, null);
    private final CaAttribute<Boolean> ocspNonceEnabled = new CaAttribute<Boolean>(DEFAULT_OCSP_NONCE_ENABLED, null, null);
    private final CaAttribute<PrivateKey> ocspRequestSigningPrivateKey = new CaAttribute<PrivateKey>(DEFAULT_OCSP_REQUEST_SIGNING_PRIVATE_KEY, null, null);
    private final CaAttribute<X509Certificate> ocspRequestSigningCert = new CaAttribute<X509Certificate>(DEFAULT_OCSP_REQUEST_SIGNING_CERT, null, null);
    private final CaAttribute<Boolean> ocspResponseCacheEnabled = new CaAttribute<Boolean>(DEFAULT_OCSP_RESPONSE_CACHE_ENABLED, null, null);
    private final Attribute<Integer> ocspResponseCacheCapacity = new Attribute<Integer>(DEFAULT_OCSP_RESPONSE_CACHE_CAPACITY, 1L, null);
    private final Attribute<Integer> ocspResponseCacheRefreshPeriodPercent = new Attribute<Integer>(DEFAULT_OCSP_RESPONSE_CACHE_REFRESH_PERIOD_PERCENT, 1L, 100L);
    private final CaAttribute<Long> ocspResponseTimeout = new CaAttribute<Long>(DEFAULT_OCSP_RESPONSE_TIMEOUT, 1L, 300L);
    private final CaAttribute<Integer> ocspTimeTolerance = new CaAttribute<Integer>(DEFAULT_OCSP_TIME_TOLERANCE, 0L, 900L);
    private final Attribute<AbstractCertRevocContext.CrlCacheType> crlCacheType = new Attribute<AbstractCertRevocContext.CrlCacheType>(DEFAULT_CRL_CACHE_TYPE, null, null);
    private final Attribute<File> crlCacheImportDir = new Attribute<File>(DEFAULT_CRL_CACHE_IMPORT_DIR, null, null);
    private final Attribute<File> crlCacheTypeFileDir = new Attribute<File>(DEFAULT_CRL_CACHE_TYPE_FILE_DIR, null, null);
    private final Attribute<String> crlCacheTypeLdapHostname = new Attribute<String>(DEFAULT_CRL_CACHE_TYPE_LDAP_HOST_NAME, null, null);
    private final Attribute<Integer> crlCacheTypeLdapPort = new Attribute<Integer>(DEFAULT_CRL_CACHE_TYPE_LDAP_PORT, -1L, 65535L);
    private final Attribute<Integer> crlCacheTypeLdapSearchTimeout = new Attribute<Integer>(DEFAULT_CRL_CACHE_TYPE_LDAP_SEARCH_TIMEOUT, 1L, 300L);
    private final Attribute<Integer> crlCacheRefreshPeriodPercent = new Attribute<Integer>(DEFAULT_CRL_CACHE_REFRESH_PERIOD_PERCENT, 1L, 100L);
    private final CaAttribute<Boolean> crlDpEnabled = new CaAttribute<Boolean>(DEFAULT_CRL_DP_ENABLED, null, null);
    private final CaAttribute<Long> crlDpDownloadTimeout = new CaAttribute<Long>(DEFAULT_CRL_DP_DOWNLOAD_TIMEOUT, 1L, 300L);
    private final CaAttribute<Boolean> crlDpBackgroundDownloadEnabled = new CaAttribute<Boolean>(DEFAULT_CRL_DP_BACKGROUND_DOWNLOAD_ENABLED, null, null);
    private final CaAttribute<URI> crlDpUrl = new CaAttribute<URI>(DEFAULT_CRL_DP_URL, null, null);
    private final CaAttribute<AbstractCertRevocContext.AttributeUsage> crlDpUrlUsage = new CaAttribute<AbstractCertRevocContext.AttributeUsage>(DEFAULT_CRL_DP_URL_USAGE, null, null);
    private final ExecutorService executorService;
    private final java.util.Timer timer;

    public CachedCertRevocContext(Set<X509Certificate> set, ExecutorService executorService) {
        super(set, null);
        this.executorService = executorService;
        this.timer = new java.util.Timer(true);
    }

    @Override
    public void logAttemptingCertRevocCheck(X500Principal x500Principal) {
    }

    @Override
    public void logUnknownCertRevocStatusNoFail(X500Principal x500Principal) {
    }

    @Override
    public void logCertRevocStatus(CertRevocStatus certRevocStatus) {
    }

    @Override
    public void logIgnoredNonceCertRevocStatus(CertRevocStatus certRevocStatus) {
    }

    @Override
    public void logUnknownCertRevocStatusFail(X500Principal x500Principal) {
    }

    @Override
    public void logRevokedCertRevocStatusFail(X500Principal x500Principal) {
    }

    @Override
    public void logNotRevokedCertRevocStatusNotFail(X500Principal x500Principal) {
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void schedule(Runnable runnable) {
        Util.checkNotNull("Runnable", runnable);
        if (null == this.executorService) {
            runnable.run();
        } else {
            this.executorService.execute(runnable);
        }
    }

    @Override
    public Timer scheduleWithFixedDelay(final Runnable runnable, long l, long l2) {
        Util.checkNotNull("Runnable", runnable);
        Util.checkRange("delay", l, 0L, null);
        Util.checkRange("period", l2, 0L, null);
        final TimerTask timerTask = new TimerTask(){

            public void run() {
                block2: {
                    try {
                        runnable.run();
                    }
                    catch (Exception exception) {
                        if (!CachedCertRevocContext.this.isLoggable(Level.FINE)) break block2;
                        CachedCertRevocContext.this.log(Level.FINE, exception, "Exception occurred running timer task {0}.", runnable.getClass().getName());
                    }
                }
            }
        };
        this.timer.schedule(timerTask, l, l2);
        Timer timer = new Timer(){

            public void cancel() {
                if (CachedCertRevocContext.this.isLoggable(Level.FINEST)) {
                    CachedCertRevocContext.this.log(Level.FINEST, "Cancelling timer task {0}.", runnable.getClass().getName());
                }
                boolean bl = timerTask.cancel();
                if (CachedCertRevocContext.this.isLoggable(Level.FINEST)) {
                    CachedCertRevocContext.this.log(Level.FINEST, "Returned from cancel for timer task {0}, Found/cancelled={1}.", runnable.getClass().getName(), bl);
                }
            }
        };
        return timer;
    }

    @Override
    public boolean isCheckingEnabled() {
        return this.checkingEnabled.getValue();
    }

    public Attribute<Boolean> getAttribute_CheckingEnabled() {
        return this.checkingEnabled;
    }

    @Override
    public boolean isCheckingDisabled(X500Principal x500Principal) {
        return this.checkingDisabled.getResolvedValue(x500Principal);
    }

    public CaAttribute<Boolean> getAttribute_CheckingDisabled() {
        return this.checkingDisabled;
    }

    @Override
    public boolean isFailOnUnknownRevocStatus(X500Principal x500Principal) {
        return this.failOnUnknownRevocStatus.getResolvedValue(x500Principal);
    }

    public CaAttribute<Boolean> getAttribute_FailOnUnknownRevocStatus() {
        return this.failOnUnknownRevocStatus;
    }

    @Override
    public CertRevocCheckMethodList getMethodOrder(X500Principal x500Principal) {
        return this.methodOrder.getResolvedValue(x500Principal);
    }

    public CaAttribute<CertRevocCheckMethodList> getAttribute_MethodOrder() {
        return this.methodOrder;
    }

    @Override
    public URI getOcspResponderUrl(X500Principal x500Principal) {
        return this.ocspResponderUrl.getResolvedValue(x500Principal);
    }

    public CaAttribute<URI> getAttribute_OcspResponderUrl() {
        return this.ocspResponderUrl;
    }

    @Override
    public AbstractCertRevocContext.AttributeUsage getOcspResponderUrlUsage(X500Principal x500Principal) {
        return this.ocspResponderUrlUsage.getResolvedValue(x500Principal);
    }

    public CaAttribute<AbstractCertRevocContext.AttributeUsage> getAttribute_OcspResponderUrlUsage() {
        return this.ocspResponderUrlUsage;
    }

    @Override
    public X509Certificate getOcspResponderTrustedCert(X500Principal x500Principal) {
        return this.ocspResponderTrustedCert.getResolvedValue(x500Principal);
    }

    public CaAttribute<X509Certificate> getAttribute_OcspResponderTrustedCert() {
        return this.ocspResponderTrustedCert;
    }

    @Override
    public boolean isOcspNonceEnabled(X500Principal x500Principal) {
        return this.ocspNonceEnabled.getResolvedValue(x500Principal);
    }

    public CaAttribute<Boolean> getAttribute_OcspNonceEnabled() {
        return this.ocspNonceEnabled;
    }

    @Override
    public PrivateKey getOcspRequestSigningPrivateKey(X500Principal x500Principal) {
        return this.ocspRequestSigningPrivateKey.getResolvedValue(x500Principal);
    }

    public CaAttribute<PrivateKey> getAttribute_OcspRequestSigningPrivateKey() {
        return this.ocspRequestSigningPrivateKey;
    }

    @Override
    public X509Certificate getOcspRequestSigningCert(X500Principal x500Principal) {
        return this.ocspRequestSigningCert.getResolvedValue(x500Principal);
    }

    public CaAttribute<X509Certificate> getAttribute_OcspRequestSigningCert() {
        return this.ocspRequestSigningCert;
    }

    @Override
    public boolean isOcspResponseCacheEnabled(X500Principal x500Principal) {
        return this.ocspResponseCacheEnabled.getResolvedValue(x500Principal);
    }

    public CaAttribute<Boolean> getAttribute_OcspResponseCacheEnabled() {
        return this.ocspResponseCacheEnabled;
    }

    @Override
    public int getOcspResponseCacheCapacity() {
        return this.ocspResponseCacheCapacity.getValue();
    }

    public Attribute<Integer> getAttribute_OcspResponseCacheCapacity() {
        return this.ocspResponseCacheCapacity;
    }

    @Override
    public int getOcspResponseCacheRefreshPeriodPercent() {
        return this.ocspResponseCacheRefreshPeriodPercent.getValue();
    }

    public Attribute<Integer> getAttribute_OcspResponseCacheRefreshPeriodPercent() {
        return this.ocspResponseCacheRefreshPeriodPercent;
    }

    @Override
    public long getOcspResponseTimeout(X500Principal x500Principal) {
        return this.ocspResponseTimeout.getResolvedValue(x500Principal);
    }

    public CaAttribute<Long> getAttribute_OcspResponseTimeout() {
        return this.ocspResponseTimeout;
    }

    @Override
    public int getOcspTimeTolerance(X500Principal x500Principal) {
        return this.ocspTimeTolerance.getResolvedValue(x500Principal);
    }

    public CaAttribute<Integer> getAttribute_OcspTimeTolerance() {
        return this.ocspTimeTolerance;
    }

    @Override
    public AbstractCertRevocContext.CrlCacheType getCrlCacheType() {
        return this.crlCacheType.getValue();
    }

    public Attribute<AbstractCertRevocContext.CrlCacheType> getAttribute_CrlCacheType() {
        return this.crlCacheType;
    }

    @Override
    public File getCrlCacheImportDir() {
        return this.crlCacheImportDir.getValue();
    }

    public Attribute<File> getAttribute_CrlCacheImportDir() {
        return this.crlCacheImportDir;
    }

    @Override
    public File getCrlCacheTypeFileDir() {
        return this.crlCacheTypeFileDir.getValue();
    }

    public Attribute<File> getAttribute_CrlCacheTypeFileDir() {
        return this.crlCacheTypeFileDir;
    }

    @Override
    public String getCrlCacheTypeLdapHostname() {
        return this.crlCacheTypeLdapHostname.getValue();
    }

    public Attribute<String> getAttribute_CrlCacheTypeLdapHostname() {
        return this.crlCacheTypeLdapHostname;
    }

    @Override
    public int getCrlCacheTypeLdapPort() {
        return this.crlCacheTypeLdapPort.getValue();
    }

    public Attribute<Integer> getAttribute_CrlCacheTypeLdapPort() {
        return this.crlCacheTypeLdapPort;
    }

    @Override
    public int getCrlCacheTypeLdapSearchTimeout() {
        return this.crlCacheTypeLdapSearchTimeout.getValue();
    }

    public Attribute<Integer> getAttribute_CrlCacheTypeLdapSearchTimeout() {
        return this.crlCacheTypeLdapSearchTimeout;
    }

    @Override
    public int getCrlCacheRefreshPeriodPercent() {
        return this.crlCacheRefreshPeriodPercent.getValue();
    }

    public Attribute<Integer> getAttribute_CrlCacheRefreshPeriodPercent() {
        return this.crlCacheRefreshPeriodPercent;
    }

    @Override
    public boolean isCrlDpEnabled(X500Principal x500Principal) {
        return this.crlDpEnabled.getResolvedValue(x500Principal);
    }

    public CaAttribute<Boolean> getAttribute_CrlDpEnabled() {
        return this.crlDpEnabled;
    }

    @Override
    public long getCrlDpDownloadTimeout(X500Principal x500Principal) {
        return this.crlDpDownloadTimeout.getResolvedValue(x500Principal);
    }

    public CaAttribute<Long> getAttribute_CrlDpDownloadTimeout() {
        return this.crlDpDownloadTimeout;
    }

    @Override
    public boolean isCrlDpBackgroundDownloadEnabled(X500Principal x500Principal) {
        return this.crlDpBackgroundDownloadEnabled.getResolvedValue(x500Principal);
    }

    public CaAttribute<Boolean> getAttribute_CrlDpBackgroundDownloadEnabled() {
        return this.crlDpBackgroundDownloadEnabled;
    }

    @Override
    public URI getCrlDpUrl(X500Principal x500Principal) {
        return this.crlDpUrl.getResolvedValue(x500Principal);
    }

    public CaAttribute<URI> getAttribute_CrlDpUrl() {
        return this.crlDpUrl;
    }

    @Override
    public AbstractCertRevocContext.AttributeUsage getCrlDpUrlUsage(X500Principal x500Principal) {
        return this.crlDpUrlUsage.getResolvedValue(x500Principal);
    }

    public CaAttribute<AbstractCertRevocContext.AttributeUsage> getAttribute_CrlDpUrlUsage() {
        return this.crlDpUrlUsage;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CaAttribute<T> {
        private final Attribute<T> defaultValue;
        private static final int CA_VALUES_INIT_CAPACITY = 16;
        private final ConcurrentHashMap<X500Principal, T> caValues = new ConcurrentHashMap(16);

        CaAttribute(T t, Long l, Long l2) {
            this.defaultValue = new Attribute<T>(t, l, l2);
        }

        public T getResolvedValue(X500Principal x500Principal) {
            T t = this.getCaValue(x500Principal);
            if (null != t) {
                return t;
            }
            return this.getDefaultValue();
        }

        public T getDefaultValue() {
            return this.defaultValue.getValue();
        }

        public T setDefaultValue(T t) {
            return this.defaultValue.setValue(t);
        }

        public T getCaValue(X500Principal x500Principal) {
            if (null == x500Principal) {
                throw new IllegalArgumentException("Non-null CA DN expected.");
            }
            return this.caValues.get(x500Principal);
        }

        public T setCaValue(X500Principal x500Principal, T t) {
            if (null == x500Principal) {
                throw new IllegalArgumentException("Non-null CA DN expected.");
            }
            if (null == t) {
                return this.caValues.remove(x500Principal);
            }
            ((Attribute)this.defaultValue).checkRange(t);
            return this.caValues.put(x500Principal, t);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Attribute<T> {
        private volatile T value;
        private final Long minValue;
        private final Long maxValue;

        Attribute(T t, Long l, Long l2) {
            this.minValue = l;
            this.maxValue = l2;
            this.setValue(t);
        }

        public T getValue() {
            return this.value;
        }

        public T setValue(T t) {
            this.checkRange(t);
            T t2 = this.value;
            this.value = t;
            return t2;
        }

        private void checkRange(T t) {
            if (null == t) {
                return;
            }
            if (null != this.minValue || null != this.maxValue) {
                boolean bl = false;
                long l = 0L;
                if (t instanceof Integer) {
                    l = ((Integer)t).intValue();
                    bl = true;
                }
                if (t instanceof Long) {
                    l = (Long)t;
                    bl = true;
                }
                if (bl) {
                    Util.checkRange(null, l, this.minValue, this.maxValue);
                }
            }
        }
    }
}

