/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.pki.revocation.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertRevocCheckMethodList {
    private final List<SelectableMethod> list;

    public CertRevocCheckMethodList(String string) throws IllegalArgumentException {
        this(CertRevocCheckMethodList.parseSelectableMethodList(string));
    }

    public CertRevocCheckMethodList(SelectableMethodList selectableMethodList) {
        CertRevocCheckMethodList.checkNonNull((Object)selectableMethodList, "SelectableMethodList");
        ArrayList<SelectableMethod> arrayList = new ArrayList<SelectableMethod>();
        switch (selectableMethodList) {
            case OCSP: {
                arrayList.add(SelectableMethod.OCSP);
                break;
            }
            case CRL: {
                arrayList.add(SelectableMethod.CRL);
                break;
            }
            case OCSP_THEN_CRL: {
                arrayList.add(SelectableMethod.OCSP);
                arrayList.add(SelectableMethod.CRL);
                break;
            }
            case CRL_THEN_OCSP: {
                arrayList.add(SelectableMethod.CRL);
                arrayList.add(SelectableMethod.OCSP);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + (Object)((Object)selectableMethodList));
            }
        }
        this.list = Collections.unmodifiableList(arrayList);
    }

    public int size() {
        return this.list.size();
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public boolean contains(SelectableMethod selectableMethod) {
        CertRevocCheckMethodList.checkNonNull((Object)selectableMethod, "SelectableMethod");
        return this.list.contains((Object)selectableMethod);
    }

    public Iterator<SelectableMethod> iterator() {
        return this.list.iterator();
    }

    public SelectableMethod get(int n) {
        return this.list.get(n);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CertRevocCheckMethodList)) {
            return false;
        }
        CertRevocCheckMethodList certRevocCheckMethodList = (CertRevocCheckMethodList)object;
        return ((Object)this.list).equals(certRevocCheckMethodList.list);
    }

    public int hashCode() {
        return ((Object)this.list).hashCode();
    }

    private static boolean add(List<SelectableMethod> list, SelectableMethod selectableMethod) {
        CertRevocCheckMethodList.checkNonNull(list, "List<SelectableMethod>");
        CertRevocCheckMethodList.checkNonNull((Object)selectableMethod, "SelectableMethod");
        if (!list.contains((Object)selectableMethod)) {
            return list.add(selectableMethod);
        }
        return false;
    }

    private static void checkNonNull(Object object, String string) {
        if (null == string) {
            string = "";
        }
        if (null == object) {
            throw new IllegalArgumentException("Non-null " + string + " expected.");
        }
    }

    private static SelectableMethodList parseSelectableMethodList(String string) {
        SelectableMethodList selectableMethodList;
        CertRevocCheckMethodList.checkNonNull(string, "String");
        string = string.toUpperCase(Locale.US);
        try {
            selectableMethodList = SelectableMethodList.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Unrecognized CertRevocCheckMethodList: '" + string + "'.", illegalArgumentException);
        }
        return selectableMethodList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SelectableMethodList {
        OCSP,
        CRL,
        OCSP_THEN_CRL,
        CRL_THEN_OCSP;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SelectableMethod {
        OCSP,
        CRL;

    }
}

