/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.pki.revocation.common;

import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.security.auth.x500.X500Principal;
import weblogic.security.pki.revocation.common.CertRevocCheckMethodList;
import weblogic.security.pki.revocation.common.LogListener;
import weblogic.security.pki.revocation.common.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CertRevocStatus {
    private static final String DATE_FORMAT = "EEE d MMM yyyy HH:mm:ss.SSS Z";
    private final CertRevocCheckMethodList.SelectableMethod sourceMethod;
    private final X500Principal subjectDn;
    private final X500Principal issuerDn;
    private final BigInteger serialNumber;
    private final Date thisUpdate;
    private final Date nextUpdate;
    private final boolean revoked;
    private final Boolean nonceIgnored;
    private final Object key;
    private final Map<String, String> additionalProperties;

    CertRevocStatus(CertRevocCheckMethodList.SelectableMethod selectableMethod, X500Principal x500Principal, X500Principal x500Principal2, BigInteger bigInteger, Date date, Date date2, boolean bl, Boolean bl2, Map<String, String> map) {
        Util.checkNotNull("sourceMethod", (Object)selectableMethod);
        Util.checkNotNull("issuerDn", x500Principal2);
        Util.checkNotNull("serialNumber", bigInteger);
        Util.checkNotNull("thisUpdate", date);
        this.sourceMethod = selectableMethod;
        this.subjectDn = x500Principal;
        this.issuerDn = x500Principal2;
        this.serialNumber = bigInteger;
        this.thisUpdate = date;
        this.nextUpdate = date2;
        this.revoked = bl;
        this.nonceIgnored = bl2;
        this.key = CertRevocStatus.createKey(x500Principal2, bigInteger);
        if (null == map) {
            this.additionalProperties = null;
        } else {
            HashMap<String, String> hashMap = new HashMap<String, String>(map);
            this.additionalProperties = Collections.unmodifiableMap(hashMap);
        }
    }

    public Object getKey() {
        return this.key;
    }

    public static Object createKey(X509Certificate x509Certificate) {
        Util.checkNotNull("X509Certificate", x509Certificate);
        X500Principal x500Principal = x509Certificate.getIssuerX500Principal();
        BigInteger bigInteger = x509Certificate.getSerialNumber();
        if (null == x500Principal || null == bigInteger) {
            return null;
        }
        return CertRevocStatus.createKey(x500Principal, bigInteger);
    }

    public static Object createKey(X500Principal x500Principal, BigInteger bigInteger) {
        Util.checkNotNull("issuerDn", x500Principal);
        Util.checkNotNull("serialNumber", bigInteger);
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(x500Principal.getName());
        stringBuilder.append("|");
        stringBuilder.append(bigInteger.toString(16));
        return stringBuilder.toString();
    }

    public CertRevocCheckMethodList.SelectableMethod getSourceMethod() {
        return this.sourceMethod;
    }

    public X500Principal getSubjectDn() {
        return this.subjectDn;
    }

    public X500Principal getIssuerDn() {
        return this.issuerDn;
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber;
    }

    public Date getThisUpdate() {
        return this.thisUpdate;
    }

    public Date getNextUpdate() {
        return this.nextUpdate;
    }

    public boolean isRevoked() {
        return this.revoked;
    }

    public Boolean isNonceIgnored() {
        return this.nonceIgnored;
    }

    boolean isValid(int n, int n2, LogListener logListener) {
        Date date;
        Util.checkTimeTolerance(n);
        Util.checkRefreshPeriodPercent(n2);
        if (null == this.nextUpdate) {
            if (null != logListener && logListener.isLoggable(Level.FINEST)) {
                logListener.log(Level.FINEST, "Status not cachable for {0}: No next update indicated, continually updated.", this.getSubjectDn());
            }
            return false;
        }
        if (this.thisUpdate.getTime() >= this.nextUpdate.getTime()) {
            if (null != logListener && logListener.isLoggable(Level.FINEST)) {
                logListener.log(Level.FINEST, "Invalid status for {0}: ThisUpdate {1} is after NextUpdate {2}.", this.getSubjectDn(), this.thisUpdate, this.nextUpdate);
            }
            return false;
        }
        long l = this.nextUpdate.getTime() - this.thisUpdate.getTime();
        long l2 = l * (long)n2 / 100L;
        Date date2 = new Date(this.thisUpdate.getTime() + l2);
        Date date3 = this.thisUpdate;
        if (n > 0) {
            date3 = new Date(this.thisUpdate.getTime() - (long)(n * 1000));
        }
        Date date4 = date2;
        if (n > 0) {
            date4 = new Date(date2.getTime() + (long)(n * 1000));
        }
        if ((date = new Date()).before(date3)) {
            if (null != logListener && logListener.isLoggable(Level.FINEST)) {
                logListener.log(Level.FINEST, "Premature status for {0}: Now {1} is before tolerance-applied ThisUpdate {2}.", this.getSubjectDn(), date, date3);
            }
            return false;
        }
        if (!date.before(date4)) {
            if (null != logListener && logListener.isLoggable(Level.FINEST)) {
                logListener.log(Level.FINEST, "Expired status for {0}: Now {1} is not before tolerance-applied NextUpdate {2}.", this.getSubjectDn(), date, date4);
            }
            return false;
        }
        return true;
    }

    public String toString() {
        return this.generateString();
    }

    private String generateString() {
        Set<Map.Entry<String, String>> set;
        String string = this.isRevoked() ? "REVOKED" : "NOT REVOKED";
        String string2 = this.getSubjectDn() != null ? this.getSubjectDn().getName() : null;
        String string3 = MessageFormat.format("\nStatus={0}\nSource={1}\nSubject=\"{2}\"\nIssuer=\"{3}\"\nSerialNumber={4}\nStatusValid={5,date,EEE d MMM yyyy HH:mm:ss.SSS Z}\nStatusExpires={6,date,EEE d MMM yyyy HH:mm:ss.SSS Z}", new Object[]{string, this.getSourceMethod(), string2, this.getIssuerDn().getName(), this.getSerialNumber().toString(16), this.getThisUpdate(), this.getNextUpdate()});
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append(string3);
        if (null != this.nonceIgnored) {
            stringBuilder.append("\n");
            stringBuilder.append("NonceIgnored");
            stringBuilder.append("=");
            stringBuilder.append(this.nonceIgnored);
        }
        if (null != this.additionalProperties && null != (set = this.additionalProperties.entrySet())) {
            for (Map.Entry<String, String> entry : set) {
                if (null == entry) continue;
                stringBuilder.append("\n");
                stringBuilder.append(entry.getKey());
                stringBuilder.append("=");
                stringBuilder.append(entry.getValue());
            }
        }
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    public Map<String, String> getAdditionalProperties() {
        return this.additionalProperties;
    }

    static String format(Date date) {
        if (null == date) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_FORMAT);
        return simpleDateFormat.format(date);
    }
}

