/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.pki.revocation.common;

import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import weblogic.security.pki.revocation.common.CertRevocStatus;
import weblogic.security.pki.revocation.common.LogListener;
import weblogic.security.pki.revocation.common.Util;

final class CertRevocStatusCache {
    private static final int INITIAL_CAPACITY = 1024;
    private final CacheImpl cache;
    private final Object cacheSync = new Object();

    public static CertRevocStatusCache getInstance() {
        return new CertRevocStatusCache();
    }

    private CertRevocStatusCache() {
        this.cache = new CacheImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CertRevocStatus getStatus(X509Certificate x509Certificate, int n, int n2, LogListener logListener) {
        Util.checkNotNull("X509Certificate", x509Certificate);
        Util.checkTimeTolerance(n);
        Util.checkRefreshPeriodPercent(n2);
        Object object = CertRevocStatus.createKey(x509Certificate);
        Object object2 = this.cacheSync;
        synchronized (object2) {
            CertRevocStatus certRevocStatus = (CertRevocStatus)this.cache.get(object);
            if (null == certRevocStatus) {
                return null;
            }
            if (!certRevocStatus.isValid(n, n2, logListener)) {
                this.cache.remove(certRevocStatus.getKey());
                return null;
            }
            return certRevocStatus;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putStatus(X509Certificate x509Certificate, CertRevocStatus certRevocStatus, int n, int n2, int n3, LogListener logListener) {
        Util.checkNotNull("X509Certificate", x509Certificate);
        Util.checkTimeTolerance(n);
        Util.checkRefreshPeriodPercent(n2);
        CertRevocStatusCache.checkCapacity(n3);
        Object object = CertRevocStatus.createKey(x509Certificate);
        Object object2 = this.cacheSync;
        synchronized (object2) {
            if (null == certRevocStatus) {
                return null != this.cache.remove(object);
            }
            if (!certRevocStatus.isValid(n, n2, logListener)) {
                return false;
            }
            this.adjustCapacity(n3);
            this.cache.put(object, certRevocStatus);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        Object object = this.cacheSync;
        synchronized (object) {
            return this.cache.size();
        }
    }

    private static void checkCapacity(int n) {
        Util.checkRange("capacity", Long.valueOf(n), 1L, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adjustCapacity(int n) {
        Object object = this.cacheSync;
        synchronized (object) {
            int n2;
            this.cache.setMaxEntries(n);
            if (n2 > 0) {
                Iterator iterator = this.cache.entrySet().iterator();
                for (n2 = this.cache.size() - n; n2 > 0 && iterator.hasNext(); --n2) {
                    Map.Entry entry = iterator.next();
                    iterator.remove();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CacheImpl
    extends LinkedHashMap<Object, CertRevocStatus> {
        private static final float LOAD_FACTOR = 0.75f;
        private static final boolean ACCESS_ORDER = true;
        private volatile int maxEntries;

        private CacheImpl() {
            super(1024, 0.75f, true);
            this.setMaxEntries(1024);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<Object, CertRevocStatus> entry) {
            return this.size() > this.maxEntries;
        }

        public void setMaxEntries(int n) {
            CertRevocStatusCache.checkCapacity(n);
            this.maxEntries = n;
        }
    }
}

