/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.pki.revocation.common;

import java.io.File;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import javax.security.auth.x500.X500Principal;
import weblogic.security.pki.revocation.common.AbstractCertRevocContext;
import weblogic.security.pki.revocation.common.CrlCacheAccessor;
import weblogic.security.pki.revocation.common.DeleteInvalidCrlFromCacheRunnable;
import weblogic.security.pki.revocation.common.DownloadCrlFromDpRunnable;
import weblogic.security.pki.revocation.common.ImportCrlFromFileRunnable;
import weblogic.security.pki.revocation.common.LogListener;
import weblogic.security.pki.revocation.common.Timer;
import weblogic.security.pki.revocation.common.Util;

final class CrlCacheUpdater {
    private static final long IMPORT_CRL_FROM_FILE_PERIOD_MILLIS = CrlCacheUpdater.getTimerPeriodMillis("weblogic.security.pki.revocation.importCrlFromFilePeriodMillis", 60000L);
    private static final Object importCrlFromFileSync = new Object();
    private static volatile Timer importCrlFromFileTimer = null;
    private static final long DELETE_INVALID_CRL_FROM_CACHE_PERIOD_MILLIS = CrlCacheUpdater.getTimerPeriodMillis("weblogic.security.pki.revocation.deleteInvalidCrlFromCachePeriodMillis", 300000L);
    private static final Object deleteInvalidCrlFromCacheSync = new Object();
    private static volatile Timer deleteInvalidCrlFromCacheTimer = null;

    CrlCacheUpdater() {
    }

    static void startAllMaintenanceTasks(CrlCacheAccessor crlCacheAccessor, AbstractCertRevocContext abstractCertRevocContext) {
        CrlCacheUpdater.startImportCrlFromFile(crlCacheAccessor, abstractCertRevocContext);
        CrlCacheUpdater.startDeleteInvalidCrlFromCache(crlCacheAccessor, abstractCertRevocContext);
    }

    static void cancelAllMaintenanceTasks(LogListener logListener) {
        CrlCacheUpdater.cancelImportCrlFromFile(logListener);
        CrlCacheUpdater.cancelDeleteInvalidCrlFromCache(logListener);
    }

    static boolean isAllMaintenanceTasksActive() {
        boolean bl = CrlCacheUpdater.isImportCrlFromFileActive();
        return bl &= CrlCacheUpdater.isDeleteInvalidCrlFromCacheActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean updateCrlCacheFromDP(X509Certificate x509Certificate, CrlCacheAccessor crlCacheAccessor, AbstractCertRevocContext abstractCertRevocContext) {
        DownloadCrlFromDpRunnable downloadCrlFromDpRunnable;
        Object object;
        Util.checkNotNull("certToCheck", x509Certificate);
        Util.checkNotNull("crlCacheAccessor", crlCacheAccessor);
        Util.checkNotNull("AbstractCertRevocContext", abstractCertRevocContext);
        X500Principal x500Principal = x509Certificate.getIssuerX500Principal();
        Util.checkNotNull("certToCheck issuer", x500Principal);
        long l = abstractCertRevocContext.getCrlDpDownloadTimeout(x500Principal);
        if (abstractCertRevocContext.isLoggable(Level.FINEST)) {
            abstractCertRevocContext.log(Level.FINEST, "CrlDpDownloadTimeout={0}", l);
        }
        long l2 = l * 1000L;
        URI uRI = abstractCertRevocContext.getCrlDpUrl(x500Principal);
        if (abstractCertRevocContext.isLoggable(Level.FINEST)) {
            abstractCertRevocContext.log(Level.FINEST, "CrlDpUrl={0}", uRI);
        }
        AbstractCertRevocContext.AttributeUsage attributeUsage = abstractCertRevocContext.getCrlDpUrlUsage(x500Principal);
        if (abstractCertRevocContext.isLoggable(Level.FINEST)) {
            abstractCertRevocContext.log(Level.FINEST, "CrlDpUrlUsage={0}", new Object[]{attributeUsage});
        }
        Object object2 = object = new Object();
        synchronized (object2) {
            long l3;
            downloadCrlFromDpRunnable = new DownloadCrlFromDpRunnable(crlCacheAccessor, object, x509Certificate, abstractCertRevocContext.getLogListener(), uRI, attributeUsage, l2);
            abstractCertRevocContext.schedule(downloadCrlFromDpRunnable);
            long l4 = l2 <= 0L ? Long.MAX_VALUE : l2;
            long l5 = System.currentTimeMillis();
            long l6 = Long.MAX_VALUE - l5;
            long l7 = l3 = l6 <= l4 ? Long.MAX_VALUE : l5 + l4;
            while (downloadCrlFromDpRunnable.isRunning() && l4 > 0L) {
                try {
                    object.wait(l4);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                l4 = l3 - System.currentTimeMillis();
            }
        }
        return downloadCrlFromDpRunnable.isCrlCacheUpdated();
    }

    private static boolean isImportCrlFromFileActive() {
        return null != importCrlFromFileTimer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean startImportCrlFromFile(CrlCacheAccessor crlCacheAccessor, AbstractCertRevocContext abstractCertRevocContext) {
        if (null != importCrlFromFileTimer) {
            return true;
        }
        Object object = importCrlFromFileSync;
        synchronized (object) {
            if (null != importCrlFromFileTimer) {
                return true;
            }
            Util.checkNotNull("crlCacheAccessor", crlCacheAccessor);
            Util.checkNotNull("AbstractCertRevocContext", abstractCertRevocContext);
            if (abstractCertRevocContext.isLoggable(Level.FINEST)) {
                abstractCertRevocContext.log(Level.FINEST, "Attempting to start automatic checking for CRL files to import.", new Object[0]);
            }
            try {
                long l;
                long l2;
                ImportCrlFromFileRunnable importCrlFromFileRunnable;
                File file = abstractCertRevocContext.getCrlCacheImportDir();
                CrlCacheUpdater.ensureCrlCacheDir(file);
                String string = file.getAbsolutePath();
                if (abstractCertRevocContext.isLoggable(Level.FINEST)) {
                    abstractCertRevocContext.log(Level.FINEST, "CrlCacheImportDir=\"{0}\"", string);
                }
                if (null == (importCrlFromFileTimer = abstractCertRevocContext.scheduleWithFixedDelay(importCrlFromFileRunnable = new ImportCrlFromFileRunnable(file, crlCacheAccessor, abstractCertRevocContext.getLogListener()), l2 = IMPORT_CRL_FROM_FILE_PERIOD_MILLIS, l = IMPORT_CRL_FROM_FILE_PERIOD_MILLIS))) {
                    throw new IllegalStateException("Scheduler returned null importCrlFromFileTimer.");
                }
            }
            catch (Exception exception) {
                if (abstractCertRevocContext.isLoggable(Level.FINE)) {
                    abstractCertRevocContext.log(Level.FINE, exception, "Unable to start automatic checking for CRL files to import.", new Object[0]);
                }
                return false;
            }
            if (abstractCertRevocContext.isLoggable(Level.FINEST)) {
                abstractCertRevocContext.log(Level.FINEST, "Successfully started automatic checking for CRL files to import.", new Object[0]);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cancelImportCrlFromFile(LogListener logListener) {
        if (null == importCrlFromFileTimer) {
            return;
        }
        Object object = importCrlFromFileSync;
        synchronized (object) {
            block9: {
                if (null == importCrlFromFileTimer) {
                    return;
                }
                if (null != logListener && logListener.isLoggable(Level.FINEST)) {
                    logListener.log(Level.FINEST, "Attempting to stop automatic checking for CRL files to import.", new Object[0]);
                }
                try {
                    importCrlFromFileTimer.cancel();
                    importCrlFromFileTimer = null;
                    if (null != logListener && logListener.isLoggable(Level.FINEST)) {
                        logListener.log(Level.FINEST, "Successfully stopped automatic checking for CRL files to import.", new Object[0]);
                    }
                }
                catch (Exception exception) {
                    if (null == logListener || !logListener.isLoggable(Level.FINE)) break block9;
                    logListener.log(Level.FINE, exception, "Error occured while stopping automatic checking for CRL files to import.", new Object[0]);
                }
            }
        }
    }

    private static boolean isDeleteInvalidCrlFromCacheActive() {
        return null != deleteInvalidCrlFromCacheTimer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean startDeleteInvalidCrlFromCache(CrlCacheAccessor crlCacheAccessor, AbstractCertRevocContext abstractCertRevocContext) {
        if (null != deleteInvalidCrlFromCacheTimer) {
            return true;
        }
        Object object = deleteInvalidCrlFromCacheSync;
        synchronized (object) {
            if (null != deleteInvalidCrlFromCacheTimer) {
                return true;
            }
            Util.checkNotNull("crlCacheAccessor", crlCacheAccessor);
            Util.checkNotNull("AbstractCertRevocContext", abstractCertRevocContext);
            if (abstractCertRevocContext.isLoggable(Level.FINEST)) {
                abstractCertRevocContext.log(Level.FINEST, "Attempting to start automatic deleting of invalid CRLs in cache.", new Object[0]);
            }
            try {
                long l;
                long l2;
                DeleteInvalidCrlFromCacheRunnable deleteInvalidCrlFromCacheRunnable;
                File file = abstractCertRevocContext.getCrlCacheTypeFileDir();
                CrlCacheUpdater.ensureCrlCacheDir(file);
                String string = file.getAbsolutePath();
                if (abstractCertRevocContext.isLoggable(Level.FINEST)) {
                    abstractCertRevocContext.log(Level.FINEST, "CrlCacheTypeFileDir=\"{0}\"", string);
                }
                if (null == (deleteInvalidCrlFromCacheTimer = abstractCertRevocContext.scheduleWithFixedDelay(deleteInvalidCrlFromCacheRunnable = new DeleteInvalidCrlFromCacheRunnable(abstractCertRevocContext, file, crlCacheAccessor), l2 = DELETE_INVALID_CRL_FROM_CACHE_PERIOD_MILLIS, l = DELETE_INVALID_CRL_FROM_CACHE_PERIOD_MILLIS))) {
                    throw new IllegalStateException("Scheduler returned null deleteInvalidCrlFromCacheTimer.");
                }
            }
            catch (Exception exception) {
                if (abstractCertRevocContext.isLoggable(Level.FINE)) {
                    abstractCertRevocContext.log(Level.FINE, exception, "Unable to start automatic deleting of invalid CRLs in cache.", new Object[0]);
                }
                return false;
            }
            if (abstractCertRevocContext.isLoggable(Level.FINEST)) {
                abstractCertRevocContext.log(Level.FINEST, "Successfully started automatic deleting of invalid CRLs in cache.", new Object[0]);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cancelDeleteInvalidCrlFromCache(LogListener logListener) {
        if (null == deleteInvalidCrlFromCacheTimer) {
            return;
        }
        Object object = deleteInvalidCrlFromCacheSync;
        synchronized (object) {
            block9: {
                if (null == deleteInvalidCrlFromCacheTimer) {
                    return;
                }
                if (null != logListener && logListener.isLoggable(Level.FINEST)) {
                    logListener.log(Level.FINEST, "Attempting to stop automatic deleting of invalid CRLs in cache.", new Object[0]);
                }
                try {
                    deleteInvalidCrlFromCacheTimer.cancel();
                    deleteInvalidCrlFromCacheTimer = null;
                    if (null != logListener && logListener.isLoggable(Level.FINEST)) {
                        logListener.log(Level.FINEST, "Successfully stopped automatic deleting of invalid CRLs in cache.", new Object[0]);
                    }
                }
                catch (Exception exception) {
                    if (null == logListener || !logListener.isLoggable(Level.FINE)) break block9;
                    logListener.log(Level.FINE, exception, "Error occured while stopping automatic deleting of invalid CRLs in cache.", new Object[0]);
                }
            }
        }
    }

    static void ensureCrlCacheDir(File file) {
        if (null == file) {
            throw new IllegalArgumentException("Unexpected null directory used by CRL cache.");
        }
        if (file.exists()) {
            if (!file.isDirectory()) {
                throw new IllegalArgumentException("Directory reference for CRL cache is not a directory: \"" + file.getAbsolutePath() + "\".");
            }
        } else {
            file.mkdirs();
            if (!file.exists()) {
                throw new IllegalStateException("Unable to create CRL cache directory: \"" + file.getAbsolutePath() + "\".");
            }
        }
    }

    private static long getTimerPeriodMillis(String string, long l) {
        Long l2;
        if (l < 0L) {
            l = 0L;
        }
        if (null == (l2 = Long.getLong(string, l)) || l2 < 0L) {
            return l;
        }
        return l2;
    }
}

