/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.pki.revocation.common;

import java.security.cert.X509Certificate;
import java.util.logging.Level;
import weblogic.security.pki.revocation.common.AbstractCertRevocContext;
import weblogic.security.pki.revocation.common.AbstractRevocChecker;
import weblogic.security.pki.revocation.common.CertRevocStatus;
import weblogic.security.pki.revocation.common.CertRevocStatusCache;
import weblogic.security.pki.revocation.common.CrlCacheAccessor;
import weblogic.security.pki.revocation.common.DefaultCrlChecker;
import weblogic.security.pki.revocation.common.Util;

abstract class CrlChecker
extends AbstractRevocChecker {
    private static final boolean crlMemCacheEnabled = false;
    private static final int CRL_MEM_CACHE_MAX_SIZE = 1024;
    private static final CertRevocStatusCache crlMemCache = CertRevocStatusCache.getInstance();

    public static CrlChecker getInstance(AbstractCertRevocContext abstractCertRevocContext) {
        return new DefaultCrlChecker(abstractCertRevocContext);
    }

    CrlChecker(AbstractCertRevocContext abstractCertRevocContext) {
        super(abstractCertRevocContext);
    }

    final CertRevocStatus getCertRevocStatus(X509Certificate x509Certificate, X509Certificate x509Certificate2) {
        Util.checkNotNull("Issuer X509Certificate.", x509Certificate);
        Util.checkNotNull("X509Certificate to be checked.", x509Certificate2);
        AbstractCertRevocContext abstractCertRevocContext = this.getContext();
        if (abstractCertRevocContext.isLoggable(Level.FINEST)) {
            abstractCertRevocContext.log(Level.FINEST, "CrlMemCacheEnabled={0}", false);
        }
        CertRevocStatus certRevocStatus = this.getCrlStatus(x509Certificate, x509Certificate2);
        return certRevocStatus;
    }

    private CertRevocStatus getCachedStatus(X509Certificate x509Certificate) {
        Util.checkNotNull("X509Certificate to be checked.", x509Certificate);
        AbstractCertRevocContext abstractCertRevocContext = this.getContext();
        int n = abstractCertRevocContext.getCrlCacheRefreshPeriodPercent();
        if (abstractCertRevocContext.isLoggable(Level.FINEST)) {
            abstractCertRevocContext.log(Level.FINEST, "CrlCacheRefreshPeriodPercent={0}", n);
        }
        return crlMemCache.getStatus(x509Certificate, 0, n, abstractCertRevocContext.getLogListener());
    }

    private void updateCachedStatus(X509Certificate x509Certificate, CertRevocStatus certRevocStatus) {
        Util.checkNotNull("X509Certificate to be checked.", x509Certificate);
        AbstractCertRevocContext abstractCertRevocContext = this.getContext();
        int n = abstractCertRevocContext.getCrlCacheRefreshPeriodPercent();
        if (abstractCertRevocContext.isLoggable(Level.FINEST)) {
            abstractCertRevocContext.log(Level.FINEST, "CrlCacheRefreshPeriodPercent={0}", n);
        }
        crlMemCache.putStatus(x509Certificate, certRevocStatus, 0, n, 1024, abstractCertRevocContext.getLogListener());
    }

    abstract CertRevocStatus getCrlStatus(X509Certificate var1, X509Certificate var2);

    abstract CrlCacheAccessor getCrlCacheAccessor();
}

