/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.pki.revocation.common;

import com.rsa.certj.CertJ;
import com.rsa.certj.DatabaseService;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.InvalidUseException;
import com.rsa.certj.Provider;
import com.rsa.certj.ProviderManagementException;
import com.rsa.certj.cert.CRL;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X509CRL;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.provider.db.FlatFileDB;
import com.rsa.certj.provider.path.X509V1CertPath;
import com.rsa.certj.provider.revocation.CRLCertStatus;
import com.rsa.certj.provider.revocation.CRLEvidence;
import com.rsa.certj.spi.path.CertPathCtx;
import com.rsa.certj.spi.revocation.CertRevocationInfo;
import java.io.File;
import java.io.InputStream;
import java.util.Date;
import java.util.Vector;
import java.util.logging.Level;
import javax.security.auth.x500.X500Principal;
import weblogic.security.pki.revocation.common.AbstractCertRevocContext;
import weblogic.security.pki.revocation.common.CertRevocCheckMethodList;
import weblogic.security.pki.revocation.common.CertRevocStatus;
import weblogic.security.pki.revocation.common.CrlCacheAccessor;
import weblogic.security.pki.revocation.common.CrlCacheUpdater;
import weblogic.security.pki.revocation.common.CrlChecker;
import weblogic.security.pki.revocation.common.LogListener;
import weblogic.security.pki.revocation.common.RsaUtil;
import weblogic.security.pki.revocation.common.Util;

class DefaultCrlChecker
extends CrlChecker {
    private static final String CRL_CACHE_DB_PROVIDER_NAME = "CRL_CACHE_DB_PROVIDER";
    private static final String CRL_CERT_PATH_PROVIDER_NAME = "CRL_CERT_PATH_PROVIDER";
    private static final String CRL_CERT_STATUS_PROVIDER_NAME = "CRL_CERT_STATUS_PROVIDER";

    DefaultCrlChecker(AbstractCertRevocContext abstractCertRevocContext) {
        super(abstractCertRevocContext);
    }

    CertRevocStatus getCrlStatus(java.security.cert.X509Certificate x509Certificate, java.security.cert.X509Certificate x509Certificate2) {
        CertRevocationInfo certRevocationInfo;
        Util.checkNotNull("Issuer X509Certificate.", x509Certificate);
        Util.checkNotNull("X509Certificate to be checked.", x509Certificate2);
        AbstractCertRevocContext abstractCertRevocContext = this.getContext();
        LogListener logListener = abstractCertRevocContext.getLogListener();
        X500Principal x500Principal = x509Certificate2.getIssuerX500Principal();
        X509Certificate x509Certificate3 = RsaUtil.toRsaCert(x509Certificate2, logListener);
        X509Certificate x509Certificate4 = RsaUtil.toRsaCert(x509Certificate, logListener);
        if (null == x509Certificate3 || null == x509Certificate4) {
            if (abstractCertRevocContext.isLoggable(Level.FINE)) {
                abstractCertRevocContext.log(Level.FINE, "Unable to check revocation status, unable to convert both subject and issuer certificates.", new Object[0]);
            }
            return null;
        }
        if (!RsaUtil.isFIPS140UsageOk(logListener)) {
            return null;
        }
        try {
            certRevocationInfo = this.checkCertRevocation(x500Principal, x509Certificate3, x509Certificate2, x509Certificate4, x509Certificate);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            DefaultCrlChecker.logThrowableDuringCrlCheck(abstractCertRevocContext, outOfMemoryError);
            return null;
        }
        catch (Exception exception) {
            DefaultCrlChecker.logThrowableDuringCrlCheck(abstractCertRevocContext, exception);
            return null;
        }
        CertRevocStatus certRevocStatus = this.evalRevocationInfo(x509Certificate2, certRevocationInfo);
        return certRevocStatus;
    }

    private static void logThrowableDuringCrlCheck(AbstractCertRevocContext abstractCertRevocContext, Throwable throwable) {
        if (abstractCertRevocContext.isLoggable(Level.FINE)) {
            abstractCertRevocContext.log(Level.FINE, throwable, "Exception while checking revocation status using CRLs.", new Object[0]);
        }
    }

    private CertRevocationInfo checkCertRevocation(X500Principal x500Principal, X509Certificate x509Certificate, java.security.cert.X509Certificate x509Certificate2, X509Certificate x509Certificate3, java.security.cert.X509Certificate x509Certificate4) throws Exception {
        Util.checkNotNull("issuerDn", x500Principal);
        Util.checkNotNull("rsaCertToCheck", x509Certificate);
        Util.checkNotNull("certToCheck", x509Certificate2);
        Util.checkNotNull("rsaCertToCheckIssuer", x509Certificate3);
        Util.checkNotNull("certToCheckIssuer", x509Certificate4);
        CertJ certJ = this.newCertJ();
        DefaultCrlCacheAccessor defaultCrlCacheAccessor = this.addCrlCacheProvider(certJ);
        this.addCertPathProvider(certJ);
        this.addCrlCertStatusProvider(certJ);
        CertPathCtx certPathCtx = this.initCertPathCtx(x509Certificate3, defaultCrlCacheAccessor.getDatabaseService());
        AbstractCertRevocContext abstractCertRevocContext = this.getContext();
        CertRevocationInfo certRevocationInfo = null;
        boolean bl = false;
        boolean bl2 = true;
        while (bl2) {
            boolean bl3;
            block7: {
                boolean bl4;
                bl2 = false;
                certRevocationInfo = certJ.checkCertRevocation(certPathCtx, (Certificate)x509Certificate);
                if (null == certRevocationInfo) {
                    if (!abstractCertRevocContext.isLoggable(Level.FINE)) break;
                    abstractCertRevocContext.log(Level.FINE, "CRL processing implementation returned no revocation information.", new Object[0]);
                    break;
                }
                if (2 != certRevocationInfo.getStatus()) break;
                if (bl) continue;
                bl = true;
                if (abstractCertRevocContext.isLoggable(Level.FINEST)) {
                    abstractCertRevocContext.log(Level.FINEST, "Attempting CRL fetch from Distribution Point, CRL is not cached.", new Object[0]);
                }
                if (!(bl4 = abstractCertRevocContext.isCrlDpEnabled(x500Principal))) {
                    if (!abstractCertRevocContext.isLoggable(Level.FINEST)) continue;
                    abstractCertRevocContext.log(Level.FINEST, "CRL fetch from Distribution Point is disabled.", new Object[0]);
                    continue;
                }
                if (!defaultCrlCacheAccessor.isCrlCacheUpdatable()) {
                    if (!abstractCertRevocContext.isLoggable(Level.FINEST)) continue;
                    abstractCertRevocContext.log(Level.FINEST, "Not attempting CRL fetch from Distribution Point, CRL cache is not updatable.", new Object[0]);
                    continue;
                }
                bl3 = false;
                try {
                    bl3 = this.updateCrlCacheFromDP(x509Certificate2, defaultCrlCacheAccessor);
                }
                catch (Exception exception) {
                    if (!abstractCertRevocContext.isLoggable(Level.FINE)) break block7;
                    abstractCertRevocContext.log(Level.FINE, exception, "Exception while updating CRL cache from Distribution Point.", new Object[0]);
                }
            }
            if (!bl3) continue;
            bl2 = true;
        }
        return certRevocationInfo;
    }

    private boolean updateCrlCacheFromDP(java.security.cert.X509Certificate x509Certificate, CrlCacheAccessor crlCacheAccessor) throws Exception {
        AbstractCertRevocContext abstractCertRevocContext = this.getContext();
        boolean bl = CrlCacheUpdater.updateCrlCacheFromDP(x509Certificate, crlCacheAccessor, abstractCertRevocContext);
        if (abstractCertRevocContext.isLoggable(Level.FINEST)) {
            abstractCertRevocContext.log(Level.FINEST, "Attempted to update CRL cache from DP, updatedCache={0}.", bl);
        }
        return bl;
    }

    private CertJ newCertJ() throws ProviderManagementException, InvalidUseException, InvalidParameterException {
        CertJ certJ = new CertJ();
        certJ.setDevice(RsaUtil.getCryptoJDeviceList());
        return certJ;
    }

    private void addCrlCertStatusProvider(CertJ certJ) throws Exception {
        Util.checkNotNull("CertJ", certJ);
        CRLCertStatus cRLCertStatus = new CRLCertStatus(CRL_CERT_STATUS_PROVIDER_NAME);
        certJ.addProvider((Provider)cRLCertStatus);
    }

    private void addCertPathProvider(CertJ certJ) throws Exception {
        Util.checkNotNull("CertJ", certJ);
        X509V1CertPath x509V1CertPath = new X509V1CertPath(CRL_CERT_PATH_PROVIDER_NAME);
        certJ.addProvider((Provider)x509V1CertPath);
    }

    private DefaultCrlCacheAccessor addCrlCacheProvider(CertJ certJ) throws Exception {
        boolean bl;
        Util.checkNotNull("CertJ", certJ);
        AbstractCertRevocContext abstractCertRevocContext = this.getContext();
        AbstractCertRevocContext.CrlCacheType crlCacheType = abstractCertRevocContext.getCrlCacheType();
        if (abstractCertRevocContext.isLoggable(Level.FINEST)) {
            abstractCertRevocContext.log(Level.FINEST, "CrlCacheType={0}", new Object[]{crlCacheType});
        }
        switch (crlCacheType) {
            case FILE: {
                bl = this.addCrlCacheFileProvider(certJ);
                break;
            }
            default: {
                throw new IllegalStateException("Unable to initialize file-based CRL cache, unsupported CrlCacheType \"" + (Object)((Object)crlCacheType) + "\".");
            }
        }
        DatabaseService databaseService = (DatabaseService)certJ.bindService(1, CRL_CACHE_DB_PROVIDER_NAME);
        return new DefaultCrlCacheAccessor(databaseService, bl, abstractCertRevocContext.getLogListener());
    }

    private boolean addCrlCacheFileProvider(CertJ certJ) throws Exception {
        Util.checkNotNull("CertJ", certJ);
        AbstractCertRevocContext abstractCertRevocContext = this.getContext();
        File file = abstractCertRevocContext.getCrlCacheTypeFileDir();
        CrlCacheUpdater.ensureCrlCacheDir(file);
        String string = file.getAbsolutePath();
        if (abstractCertRevocContext.isLoggable(Level.FINEST)) {
            abstractCertRevocContext.log(Level.FINEST, "CrlCacheTypeFileDir=\"{0}\"", string);
        }
        char[] cArray = new char[]{};
        FlatFileDB flatFileDB = new FlatFileDB(CRL_CACHE_DB_PROVIDER_NAME, string, cArray, 6, 2);
        certJ.addProvider((Provider)flatFileDB);
        return true;
    }

    private CertPathCtx initCertPathCtx(X509Certificate x509Certificate, DatabaseService databaseService) {
        Util.checkNotNull("issuerCert", x509Certificate);
        Util.checkNotNull("dbService", databaseService);
        AbstractCertRevocContext abstractCertRevocContext = this.getContext();
        X509Certificate[] x509CertificateArray = new X509Certificate[]{x509Certificate};
        int n = 4;
        byte[][] byArray = null;
        Date date = new Date();
        if (abstractCertRevocContext.isLoggable(Level.FINEST)) {
            abstractCertRevocContext.log(Level.FINEST, "Validation time=\"{0}\"", date);
        }
        CertPathCtx certPathCtx = new CertPathCtx(n, (Certificate[])x509CertificateArray, byArray, date, databaseService);
        return certPathCtx;
    }

    private CertRevocStatus evalRevocationInfo(java.security.cert.X509Certificate x509Certificate, CertRevocationInfo certRevocationInfo) {
        Util.checkNotNull("certToCheck", x509Certificate);
        AbstractCertRevocContext abstractCertRevocContext = this.getContext();
        if (null == certRevocationInfo) {
            if (abstractCertRevocContext.isLoggable(Level.FINER)) {
                abstractCertRevocContext.log(Level.FINER, "Revocation status unavailable from CRL (CertRevocationInfo is null).", new Object[0]);
            }
            return null;
        }
        Boolean bl = RsaUtil.evalRevocStatusCode(CertRevocCheckMethodList.SelectableMethod.CRL, certRevocationInfo.getStatus(), abstractCertRevocContext.getLogListener());
        if (null == bl) {
            return null;
        }
        int n = certRevocationInfo.getType();
        if (n != 1) {
            if (abstractCertRevocContext.isLoggable(Level.FINE)) {
                abstractCertRevocContext.log(Level.FINE, "Revocation status unavailable from CRL, unexpected evidence type {0}.", n);
            }
            return null;
        }
        CRLEvidence cRLEvidence = (CRLEvidence)certRevocationInfo.getEvidence();
        if (null == cRLEvidence) {
            if (abstractCertRevocContext.isLoggable(Level.FINE)) {
                abstractCertRevocContext.log(Level.FINE, "Revocation status unavailable from CRL, no evidence available.", new Object[0]);
            }
            return null;
        }
        Date date = null;
        Date date2 = null;
        X509CRL x509CRL = (X509CRL)cRLEvidence.getCRL();
        if (null == x509CRL) {
            Vector vector = cRLEvidence.getCRLList();
            if (null == vector || vector.isEmpty()) {
                if (abstractCertRevocContext.isLoggable(Level.FINE)) {
                    abstractCertRevocContext.log(Level.FINE, "Revocation status unavailable from CRL, no CRL evidence available.", new Object[0]);
                }
                return null;
            }
            for (Object e : vector) {
                X509CRL x509CRL2;
                if (!(e instanceof X509CRL) && abstractCertRevocContext.isLoggable(Level.FINE)) {
                    abstractCertRevocContext.log(Level.FINE, "Found non-X509CRL object in evidence.getCRLList(), foundClass={0}", null == e ? null : e.getClass().getName());
                }
                if (null == (x509CRL2 = (X509CRL)e).getNextUpdate()) {
                    date = x509CRL2.getThisUpdate();
                    date2 = x509CRL2.getNextUpdate();
                    break;
                }
                if (null != date2 && !x509CRL2.getNextUpdate().before(date2)) continue;
                date = x509CRL2.getThisUpdate();
                date2 = x509CRL2.getNextUpdate();
            }
        } else {
            date = x509CRL.getThisUpdate();
            date2 = x509CRL.getNextUpdate();
        }
        return new CertRevocStatus(CertRevocCheckMethodList.SelectableMethod.CRL, x509Certificate.getSubjectX500Principal(), x509Certificate.getIssuerX500Principal(), x509Certificate.getSerialNumber(), date, date2, bl, null, null);
    }

    CrlCacheAccessor getCrlCacheAccessor() {
        DefaultCrlCacheAccessor defaultCrlCacheAccessor;
        block2: {
            defaultCrlCacheAccessor = null;
            try {
                defaultCrlCacheAccessor = this.addCrlCacheProvider(this.newCertJ());
            }
            catch (Exception exception) {
                AbstractCertRevocContext abstractCertRevocContext = this.getContext();
                if (!abstractCertRevocContext.isLoggable(Level.FINE)) break block2;
                abstractCertRevocContext.log(Level.FINE, exception, "Unable to get CrlCacheAccessor.", new Object[0]);
            }
        }
        return defaultCrlCacheAccessor;
    }

    private static final class DefaultCrlCacheAccessor
    implements CrlCacheAccessor {
        private final DatabaseService dbService;
        private final boolean crlCacheUpdatable;
        private final LogListener logger;

        private DefaultCrlCacheAccessor(DatabaseService databaseService, boolean bl, LogListener logListener) {
            Util.checkNotNull("DatabaseService", databaseService);
            this.dbService = databaseService;
            this.crlCacheUpdatable = bl;
            this.logger = logListener;
        }

        public boolean loadCrl(InputStream inputStream) throws Exception {
            X509CRL x509CRL;
            byte[] byArray;
            Util.checkNotNull("InputStream", inputStream);
            try {
                byArray = Util.readAll(inputStream);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.logErrorLoadCrl(outOfMemoryError, "reading");
                throw new RuntimeException(outOfMemoryError);
            }
            catch (Exception exception) {
                this.logErrorLoadCrl(exception, "reading");
                throw exception;
            }
            try {
                x509CRL = new X509CRL(byArray, 0, 0);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.logErrorLoadCrl(outOfMemoryError, "parsing");
                throw new RuntimeException(outOfMemoryError);
            }
            catch (Exception exception) {
                this.logErrorLoadCrl(exception, "parsing");
                throw exception;
            }
            byArray = null;
            try {
                this.dbService.insertCRL((CRL)x509CRL);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.logErrorLoadCrl(outOfMemoryError, "inserting");
                throw new RuntimeException(outOfMemoryError);
            }
            catch (Exception exception) {
                this.logErrorLoadCrl(exception, "inserting");
                throw exception;
            }
            return true;
        }

        public void deleteCrl(X500Principal x500Principal, Date date) throws Exception {
            X500Name x500Name;
            Util.checkNotNull("issuerX500Name", x500Principal);
            Util.checkNotNull("thisUpdate", date);
            try {
                byte[] byArray = x500Principal.getEncoded();
                x500Name = new X500Name(byArray, 0, 0);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Illegal issuer distinguished name: " + x500Principal, exception);
            }
            try {
                this.dbService.deleteCRL(x500Name, date);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw new RuntimeException(outOfMemoryError);
            }
            catch (Exception exception) {
                throw exception;
            }
        }

        public boolean isCrlCacheUpdatable() {
            return this.crlCacheUpdatable;
        }

        private DatabaseService getDatabaseService() {
            return this.dbService;
        }

        private void logErrorLoadCrl(Throwable throwable, String string) {
            if (null != this.logger && this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, throwable, "Unable to load CRL, while " + string + ".", new Object[0]);
            }
        }
    }
}

