/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.pki.revocation.common;

import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.cert.extensions.CRLDistributionPoints;
import com.rsa.certj.cert.extensions.GeneralName;
import com.rsa.certj.cert.extensions.GeneralNames;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import javax.security.auth.x500.X500Principal;
import weblogic.security.pki.revocation.common.AbstractCertRevocContext;
import weblogic.security.pki.revocation.common.CrlCacheAccessor;
import weblogic.security.pki.revocation.common.CrlDpFetcher;
import weblogic.security.pki.revocation.common.LogListener;
import weblogic.security.pki.revocation.common.RsaUtil;
import weblogic.security.pki.revocation.common.Util;

class DefaultCrlDpFetcher
extends CrlDpFetcher {
    DefaultCrlDpFetcher() {
    }

    boolean updateCrls(java.security.cert.X509Certificate x509Certificate, CrlCacheAccessor crlCacheAccessor, URI uRI, AbstractCertRevocContext.AttributeUsage attributeUsage, long l, long l2, LogListener logListener) throws Exception {
        Util.checkNotNull("X509Certificate with DPs", x509Certificate);
        Util.checkNotNull("CrlCacheAccessor", crlCacheAccessor);
        X500Principal x500Principal = this.getIssuerX500Principal(x509Certificate, logListener);
        if (null == x500Principal) {
            return false;
        }
        X509Certificate x509Certificate2 = this.toRsaCert(x509Certificate, logListener);
        if (null == x509Certificate2) {
            return false;
        }
        X500Name x500Name = this.getRsaIssuerX500Name(x509Certificate, logListener, x509Certificate2);
        if (null == x500Name) {
            return false;
        }
        URI uRI2 = this.getUri(uRI, attributeUsage, logListener, x500Principal, x509Certificate2, x500Name);
        if (null != uRI2) {
            if (null != logListener && logListener.isLoggable(Level.FINEST)) {
                logListener.log(Level.FINEST, "Attempting to download CRL from URI \"{0}\".", uRI2);
            }
            int n = l2 > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l2;
            int n2 = l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l;
            return this.loadCrl(crlCacheAccessor, logListener, x500Principal, n, n2, uRI2);
        }
        if (null != logListener && logListener.isLoggable(Level.FINER)) {
            logListener.log(Level.FINER, "Unable to determine CRL DP URI for certificate with subject \"{0}\".", x509Certificate.getSubjectX500Principal());
        }
        return false;
    }

    private URI getUri(URI uRI, AbstractCertRevocContext.AttributeUsage attributeUsage, LogListener logListener, X500Principal x500Principal, X509Certificate x509Certificate, X500Name x500Name) throws NameException {
        URI uRI2 = null;
        if (AbstractCertRevocContext.AttributeUsage.OVERRIDE == attributeUsage) {
            if (!DefaultCrlDpFetcher.isAlternateUriNull(uRI, logListener, x500Principal)) {
                uRI2 = uRI;
            }
        } else {
            CRLDistributionPoints cRLDistributionPoints = this.getDistributionPoints(logListener, x509Certificate);
            if (null != cRLDistributionPoints && null == (uRI2 = this.findUriInDp(logListener, x500Principal, x500Name, cRLDistributionPoints))) {
                uRI2 = this.findFailoverUri(uRI, attributeUsage, logListener, x500Principal);
            }
        }
        return uRI2;
    }

    private CRLDistributionPoints getDistributionPoints(LogListener logListener, X509Certificate x509Certificate) {
        CRLDistributionPoints cRLDistributionPoints = (CRLDistributionPoints)RsaUtil.getExtension(x509Certificate, 31);
        if (null == cRLDistributionPoints && null != logListener && logListener.isLoggable(Level.FINER)) {
            logListener.log(Level.FINER, "No Distribution points found in cert with subject \"{0}\".", x509Certificate.getSubjectName());
        }
        return cRLDistributionPoints;
    }

    private URI findFailoverUri(URI uRI, AbstractCertRevocContext.AttributeUsage attributeUsage, LogListener logListener, X500Principal x500Principal) {
        URI uRI2 = null;
        if (null != logListener && logListener.isLoggable(Level.FINER)) {
            logListener.log(Level.FINER, "Unable to find any usable CRL DP URI, checking FAILOVER CRL DP URI.", new Object[0]);
        }
        if (AbstractCertRevocContext.AttributeUsage.FAILOVER == attributeUsage && null != uRI) {
            if (null != logListener && logListener.isLoggable(Level.FINER)) {
                logListener.log(Level.FINER, "Trying FAILOVER CRL DP URI \"{0}\".", uRI);
            }
            uRI2 = uRI;
        } else if (null != logListener && logListener.isLoggable(Level.FINER)) {
            logListener.log(Level.FINER, "NO FAILOVER CRL DP URI for issuer \"{0}\".", x500Principal);
        }
        return uRI2;
    }

    private URI findUriInDp(LogListener logListener, X500Principal x500Principal, X500Name x500Name, CRLDistributionPoints cRLDistributionPoints) throws NameException {
        GeneralNames generalNames;
        Object object;
        int n;
        URI uRI = null;
        int n2 = cRLDistributionPoints.getDistributionPointCount();
        for (int i = 0; !(i >= n2 || -1 == (n = cRLDistributionPoints.getReasonFlags(i)) && this.isDpCrlIssuerEqual(x500Name, cRLDistributionPoints, i) && (object = cRLDistributionPoints.getDistributionPointName(i)) instanceof GeneralNames && null != (uRI = this.getUri(logListener, x500Principal, generalNames = (GeneralNames)object))); ++i) {
        }
        return uRI;
    }

    private static boolean isAlternateUriNull(URI uRI, LogListener logListener, X500Principal x500Principal) {
        if (null == uRI) {
            if (null != logListener && logListener.isLoggable(Level.FINE)) {
                logListener.log(Level.FINE, "Unable to fetch CRL from DP. CRL DP override URI set to null for cert issuer \"{0}\".", x500Principal);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadCrl(CrlCacheAccessor crlCacheAccessor, LogListener logListener, X500Principal x500Principal, int n, int n2, URI uRI) {
        boolean bl = false;
        InputStream inputStream = null;
        try {
            inputStream = this.getInputStream(n, n2, uRI);
            bl = crlCacheAccessor.loadCrl(inputStream);
        }
        catch (Exception exception) {
            if (null != logListener && logListener.isLoggable(Level.FINE)) {
                logListener.log(Level.FINE, exception, "Exception fetching CRL from DP URI \"{0}\" for cert issuer \"{1}\".", uRI, x500Principal);
            }
        }
        finally {
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return bl;
    }

    private InputStream getInputStream(int n, int n2, URI uRI) throws IOException {
        URL uRL = uRI.toURL();
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setConnectTimeout(n);
        uRLConnection.setReadTimeout(n2);
        InputStream inputStream = uRLConnection.getInputStream();
        return inputStream;
    }

    private URI getUri(LogListener logListener, X500Principal x500Principal, GeneralNames generalNames) throws NameException {
        URI uRI = null;
        int n = generalNames.getNameCount();
        for (int i = 0; i < n; ++i) {
            GeneralName generalName = generalNames.getGeneralName(i);
            if (generalName.getGeneralNameType() != 7) continue;
            String string = (String)generalName.getGeneralName();
            try {
                uRI = new URI(string);
                String string2 = uRI.getScheme().toLowerCase();
                if (!string2.equals("http") && !string2.equals("ftp")) continue;
                break;
            }
            catch (URISyntaxException uRISyntaxException) {
                if (null == logListener || !logListener.isLoggable(Level.FINE)) continue;
                logListener.log(Level.FINE, "Unable to parse DP URI \"{0}\" for cert issuer \"{1}\".", string, x500Principal);
            }
        }
        return uRI;
    }

    private boolean isDpCrlIssuerEqual(X500Name x500Name, CRLDistributionPoints cRLDistributionPoints, int n) throws NameException {
        GeneralNames generalNames = cRLDistributionPoints.getCRLIssuer(n);
        if (null == generalNames) {
            return true;
        }
        if (generalNames != null) {
            int n2 = generalNames.getNameCount();
            for (int i = 0; i < n2; ++i) {
                GeneralName generalName = generalNames.getGeneralName(i);
                if (!x500Name.equals((Object)generalName)) continue;
                return true;
            }
        }
        return false;
    }

    private X500Name getRsaIssuerX500Name(java.security.cert.X509Certificate x509Certificate, LogListener logListener, X509Certificate x509Certificate2) {
        X500Name x500Name = x509Certificate2.getIssuerName();
        if (null == x500Name && null != logListener && logListener.isLoggable(Level.FINE)) {
            logListener.log(Level.FINE, "Unable to update CRLs, missing internal issuer, certificate=\"{0}\".", x509Certificate.getSubjectDN());
        }
        return x500Name;
    }

    private X509Certificate toRsaCert(java.security.cert.X509Certificate x509Certificate, LogListener logListener) {
        X509Certificate x509Certificate2 = RsaUtil.toRsaCert(x509Certificate, logListener);
        if (null == x509Certificate2 && null != logListener && logListener.isLoggable(Level.FINE)) {
            logListener.log(Level.FINE, "Unable to update CRLs, certificate not convertible, certificate=\"{0}\".", x509Certificate.getSubjectDN());
        }
        return x509Certificate2;
    }

    private X500Principal getIssuerX500Principal(java.security.cert.X509Certificate x509Certificate, LogListener logListener) {
        X500Principal x500Principal = x509Certificate.getIssuerX500Principal();
        if (null == x500Principal && null != logListener && logListener.isLoggable(Level.FINE)) {
            logListener.log(Level.FINE, "Unable to update CRLs, missing issuer, certificate=\"{0}\".", x509Certificate.getSubjectDN());
        }
        return x500Principal;
    }
}

