/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.pki.revocation.common;

import com.rsa.certj.CertJ;
import com.rsa.certj.DatabaseService;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.InvalidUseException;
import com.rsa.certj.NoServiceException;
import com.rsa.certj.Provider;
import com.rsa.certj.ProviderManagementException;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.cert.X509V3Extensions;
import com.rsa.certj.provider.db.MemoryDB;
import com.rsa.certj.provider.path.X509V1CertPath;
import com.rsa.certj.provider.revocation.ocsp.OCSP;
import com.rsa.certj.provider.revocation.ocsp.OCSPEvidence;
import com.rsa.certj.provider.revocation.ocsp.OCSPRequestControl;
import com.rsa.certj.provider.revocation.ocsp.OCSPResponder;
import com.rsa.certj.provider.revocation.ocsp.OCSPRevocationInfo;
import com.rsa.certj.spi.db.DatabaseException;
import com.rsa.certj.spi.path.CertPathCtx;
import com.rsa.certj.spi.revocation.CertRevocationInfo;
import com.rsa.certj.spi.revocation.CertStatusException;
import com.rsa.jsafe.JSAFE_PrivateKey;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.security.PrivateKey;
import java.util.Date;
import java.util.HashMap;
import java.util.logging.Level;
import javax.security.auth.x500.X500Principal;
import weblogic.security.pki.revocation.common.AbstractCertRevocContext;
import weblogic.security.pki.revocation.common.CertRevocCheckMethodList;
import weblogic.security.pki.revocation.common.CertRevocStatus;
import weblogic.security.pki.revocation.common.LogListener;
import weblogic.security.pki.revocation.common.OcspChecker;
import weblogic.security.pki.revocation.common.RsaUtil;
import weblogic.security.pki.revocation.common.Util;

class DefaultOcspChecker
extends OcspChecker {
    private static final String DB_PROVIDER_NAME = "OCSP_DB_PROVIDER";
    private static final String CERT_PATH_PROVIDER_NAME = "OCSP_CERT_PATH_PROVIDER";
    private static final String OCSP_PROVIDER_NAME = "OCSP_PROVIDER";

    DefaultOcspChecker(AbstractCertRevocContext abstractCertRevocContext) {
        super(abstractCertRevocContext);
    }

    CertRevocStatus getRemoteStatus(java.security.cert.X509Certificate x509Certificate, java.security.cert.X509Certificate x509Certificate2) {
        Util.checkNotNull("Issuer X509Certificate.", x509Certificate);
        Util.checkNotNull("X509Certificate to be checked.", x509Certificate2);
        AbstractCertRevocContext abstractCertRevocContext = this.getContext();
        LogListener logListener = abstractCertRevocContext.getLogListener();
        X500Principal x500Principal = x509Certificate2.getIssuerX500Principal();
        X509Certificate x509Certificate3 = RsaUtil.toRsaCert(x509Certificate2, logListener);
        X509Certificate x509Certificate4 = RsaUtil.toRsaCert(x509Certificate, logListener);
        if (null == x509Certificate3 || null == x509Certificate4) {
            if (abstractCertRevocContext.isLoggable(Level.FINE)) {
                abstractCertRevocContext.log(Level.FINE, "Unable to check OCSP revocation status, unable to convert both subject and issuer certificates.", new Object[0]);
            }
            return null;
        }
        X509Certificate x509Certificate5 = this.getResponderTrustedCert(x500Principal);
        JSAFE_PrivateKey jSAFE_PrivateKey = this.getRequestSigningPrivateKey(x500Principal);
        X509Certificate x509Certificate6 = this.getRequestSigningPublicCert(x500Principal);
        if (null == jSAFE_PrivateKey || null == x509Certificate6) {
            if (abstractCertRevocContext.isLoggable(Level.FINEST)) {
                abstractCertRevocContext.log(Level.FINEST, "OCSP request signing disabled: Private key={0}, Public cert={1}.", null == jSAFE_PrivateKey ? "missing" : "gotIt", null == x509Certificate6 ? "missing" : "gotIt");
            }
            jSAFE_PrivateKey = null;
            x509Certificate6 = null;
        } else if (abstractCertRevocContext.isLoggable(Level.FINEST)) {
            abstractCertRevocContext.log(Level.FINEST, "OCSP request signing enabled, private key and public certificate configured.", new Object[0]);
        }
        JSAFE_PrivateKey jSAFE_PrivateKey2 = jSAFE_PrivateKey;
        X509Certificate x509Certificate7 = x509Certificate6;
        if (!RsaUtil.isFIPS140UsageOk(logListener)) {
            return null;
        }
        try {
            jSAFE_PrivateKey = this.checkCertRevocation(x500Principal, x509Certificate3, x509Certificate4, x509Certificate5, jSAFE_PrivateKey2, x509Certificate7);
        }
        catch (Exception exception) {
            if (abstractCertRevocContext.isLoggable(Level.FINE)) {
                abstractCertRevocContext.log(Level.FINE, exception, "Exception while checking revocation status using OCSP.", new Object[0]);
            }
            return null;
        }
        return this.evalRevocationInfo(x509Certificate2, (CertRevocationInfo)jSAFE_PrivateKey);
    }

    private JSAFE_PrivateKey getRequestSigningPrivateKey(X500Principal x500Principal) {
        Util.checkNotNull("issuerDn", x500Principal);
        AbstractCertRevocContext abstractCertRevocContext = this.getContext();
        JSAFE_PrivateKey jSAFE_PrivateKey = null;
        PrivateKey privateKey = abstractCertRevocContext.getOcspRequestSigningPrivateKey(x500Principal);
        if (null != privateKey && null == (jSAFE_PrivateKey = RsaUtil.toRsaPrivateKey(privateKey, abstractCertRevocContext.getLogListener())) && abstractCertRevocContext.isLoggable(Level.FINE)) {
            abstractCertRevocContext.log(Level.FINE, "Unable to convert request signing private key.", new Object[0]);
        }
        return jSAFE_PrivateKey;
    }

    private X509Certificate getRequestSigningPublicCert(X500Principal x500Principal) {
        Util.checkNotNull("issuerDn", x500Principal);
        AbstractCertRevocContext abstractCertRevocContext = this.getContext();
        X509Certificate x509Certificate = null;
        java.security.cert.X509Certificate x509Certificate2 = abstractCertRevocContext.getOcspRequestSigningCert(x500Principal);
        if (null != x509Certificate2 && null == (x509Certificate = RsaUtil.toRsaCert(x509Certificate2, abstractCertRevocContext.getLogListener())) && abstractCertRevocContext.isLoggable(Level.FINE)) {
            abstractCertRevocContext.log(Level.FINE, "Unable to convert request signing public certificate.", new Object[0]);
        }
        return x509Certificate;
    }

    private X509Certificate getResponderTrustedCert(X500Principal x500Principal) {
        Util.checkNotNull("issuerDn", x500Principal);
        AbstractCertRevocContext abstractCertRevocContext = this.getContext();
        X509Certificate x509Certificate = null;
        java.security.cert.X509Certificate x509Certificate2 = abstractCertRevocContext.getOcspResponderTrustedCert(x500Principal);
        if (null == x509Certificate2) {
            if (abstractCertRevocContext.isLoggable(Level.FINEST)) {
                abstractCertRevocContext.log(Level.FINEST, "No OCSP responder explicitly trusted certificate is available.", new Object[0]);
            }
        } else {
            x509Certificate = RsaUtil.toRsaCert(x509Certificate2, abstractCertRevocContext.getLogListener());
            if (null == x509Certificate) {
                if (abstractCertRevocContext.isLoggable(Level.FINE)) {
                    abstractCertRevocContext.log(Level.FINE, "Unable to convert OCSP responder explicitly trusted certificate.", new Object[0]);
                }
            } else if (abstractCertRevocContext.isLoggable(Level.FINEST)) {
                abstractCertRevocContext.log(Level.FINEST, "OCSP using explicitly trust certificate \"{0}\".", x509Certificate.getSubjectName());
            }
        }
        return x509Certificate;
    }

    private CertJ initCertJ() throws InvalidParameterException, ProviderManagementException, InvalidUseException {
        MemoryDB memoryDB = new MemoryDB(DB_PROVIDER_NAME);
        X509V1CertPath x509V1CertPath = new X509V1CertPath(CERT_PATH_PROVIDER_NAME);
        Provider[] providerArray = new Provider[]{memoryDB, x509V1CertPath};
        CertJ certJ = new CertJ(providerArray);
        certJ.setDevice(RsaUtil.getCryptoJDeviceList());
        return certJ;
    }

    private DatabaseService initDbService(X509Certificate x509Certificate, X509Certificate x509Certificate2, X509Certificate x509Certificate3, JSAFE_PrivateKey jSAFE_PrivateKey, CertJ certJ) throws InvalidParameterException, ProviderManagementException, NoServiceException, DatabaseException {
        Util.checkNotNull("certJ", certJ);
        DatabaseService databaseService = (DatabaseService)certJ.bindService(1, DB_PROVIDER_NAME);
        if (null != x509Certificate) {
            databaseService.insertCertificate((Certificate)x509Certificate);
        }
        Util.checkNotNull("issuerCert", x509Certificate2);
        databaseService.insertCertificate((Certificate)x509Certificate2);
        if (null != x509Certificate3 && null != jSAFE_PrivateKey) {
            databaseService.insertCertificate((Certificate)x509Certificate3);
            databaseService.insertPrivateKeyByCertificate((Certificate)x509Certificate3, jSAFE_PrivateKey);
        }
        return databaseService;
    }

    private CertPathCtx initCertPathCtx(X500Principal x500Principal, X509Certificate x509Certificate, X509Certificate x509Certificate2, DatabaseService databaseService) {
        Util.checkNotNull("issuerDn", x500Principal);
        Util.checkNotNull("issuerCert", x509Certificate);
        Util.checkNotNull("dbService", databaseService);
        X509Certificate[] x509CertificateArray = null != x509Certificate2 ? new X509Certificate[]{x509Certificate, x509Certificate2} : new X509Certificate[]{x509Certificate};
        AbstractCertRevocContext abstractCertRevocContext = this.getContext();
        AbstractCertRevocContext.AttributeUsage attributeUsage = abstractCertRevocContext.getOcspResponderUrlUsage(x500Principal);
        if (abstractCertRevocContext.isLoggable(Level.FINEST)) {
            abstractCertRevocContext.log(Level.FINEST, "OcspResponderUrlUsage={0}", new Object[]{attributeUsage});
        }
        URI uRI = abstractCertRevocContext.getOcspResponderUrl(x500Principal);
        if (abstractCertRevocContext.isLoggable(Level.FINEST)) {
            abstractCertRevocContext.log(Level.FINEST, "OcspResponderUrl={0}", uRI);
        }
        int n = 4;
        if (AbstractCertRevocContext.AttributeUsage.OVERRIDE == attributeUsage) {
            if (null == uRI) {
                throw new IllegalStateException("OCSP responder URI override is null, preventing OCSP checking for cert issuer \"" + x500Principal + "\"");
            }
            n |= 0x800;
        }
        byte[][] byArray = null;
        Date date = new Date();
        if (abstractCertRevocContext.isLoggable(Level.FINEST)) {
            abstractCertRevocContext.log(Level.FINEST, "Validation time=\"{0}\"", date);
        }
        CertPathCtx certPathCtx = new CertPathCtx(n, (Certificate[])x509CertificateArray, byArray, date, databaseService);
        return certPathCtx;
    }

    private String[] initDestList(X500Principal x500Principal) {
        Util.checkNotNull("issuerDn", x500Principal);
        AbstractCertRevocContext abstractCertRevocContext = this.getContext();
        URI uRI = abstractCertRevocContext.getOcspResponderUrl(x500Principal);
        if (abstractCertRevocContext.isLoggable(Level.FINEST)) {
            abstractCertRevocContext.log(Level.FINEST, "OcspResponderUrl={0}", uRI);
        }
        String[] stringArray = null;
        if (null != uRI) {
            stringArray = new String[]{uRI.toASCIIString()};
        }
        return stringArray;
    }

    private OCSPResponder initOcspResponder(X509Certificate x509Certificate, X509Certificate x509Certificate2, X500Principal x500Principal, X509Certificate x509Certificate3, DatabaseService databaseService) throws InvalidParameterException {
        Util.checkNotNull("issuerDn", x500Principal);
        Util.checkNotNull("issuerCert", x509Certificate3);
        Util.checkNotNull("dbService", databaseService);
        AbstractCertRevocContext abstractCertRevocContext = this.getContext();
        int n = 0;
        if (abstractCertRevocContext.isLoggable(Level.FINEST)) {
            abstractCertRevocContext.log(Level.FINEST, "Using OCSP responder profile={0}", n);
        }
        int n2 = 8;
        boolean bl = abstractCertRevocContext.isOcspNonceEnabled(x500Principal);
        if (abstractCertRevocContext.isLoggable(Level.FINEST)) {
            abstractCertRevocContext.log(Level.FINEST, "OcspNonceEnabled={0}", bl);
        }
        if (!bl) {
            n2 |= 1;
        }
        if (abstractCertRevocContext.isLoggable(Level.FINEST)) {
            abstractCertRevocContext.log(Level.FINEST, "ocspResponderFlags={0}", n2);
        }
        String[] stringArray = null;
        if (abstractCertRevocContext.isLoggable(Level.FINEST)) {
            abstractCertRevocContext.log(Level.FINEST, "proxyList is empty, reverting to System Properties.", new Object[0]);
        }
        OCSPRequestControl oCSPRequestControl = this.initOcspRequestControl(x509Certificate);
        X509Certificate[] x509CertificateArray = new X509Certificate[]{x509Certificate3};
        int n3 = abstractCertRevocContext.getOcspTimeTolerance(x500Principal);
        if (abstractCertRevocContext.isLoggable(Level.FINEST)) {
            abstractCertRevocContext.log(Level.FINEST, "OcspTimeTolerance={0}", n3);
        }
        String[] stringArray2 = this.initDestList(x500Principal);
        OCSPResponder oCSPResponder = new OCSPResponder(n, n2, stringArray2, stringArray, oCSPRequestControl, x509Certificate2, x509CertificateArray, databaseService, n3);
        return oCSPResponder;
    }

    private OCSPRequestControl initOcspRequestControl(X509Certificate x509Certificate) throws InvalidParameterException {
        AbstractCertRevocContext abstractCertRevocContext = this.getContext();
        String string = "SHA1/RSA/PKCS1Block01Pad";
        String string2 = "SHA1";
        X509Certificate[] x509CertificateArray = null;
        Object var6_6 = null;
        X509V3Extensions x509V3Extensions = null;
        Object var8_8 = null;
        String string3 = null;
        if (x509Certificate != null && x509Certificate.getSubjectName() != null) {
            string3 = x509Certificate.getSubjectName().toStringRFC2253();
        }
        if (abstractCertRevocContext.isLoggable(Level.FINEST)) {
            abstractCertRevocContext.log(Level.FINEST, "Request signing: signingCert={0}, digestAlg={1}, signatureAlg={2}, extraCerts={3}, requestExtensions={4}", string3, string2, string, var6_6, var8_8);
        }
        OCSPRequestControl oCSPRequestControl = new OCSPRequestControl(x509Certificate, string2, string, x509CertificateArray, x509V3Extensions);
        return oCSPRequestControl;
    }

    private OCSP initOcspProvider(X500Principal x500Principal, OCSPResponder oCSPResponder) throws UnsupportedEncodingException, InvalidParameterException, CertificateException, NameException {
        Util.checkNotNull("issuerDn", x500Principal);
        Util.checkNotNull("ocspResponder", oCSPResponder);
        AbstractCertRevocContext abstractCertRevocContext = this.getContext();
        long l = abstractCertRevocContext.getOcspResponseTimeout(x500Principal);
        if (abstractCertRevocContext.isLoggable(Level.FINEST)) {
            abstractCertRevocContext.log(Level.FINEST, "OcspResponseTimeout={0}", l);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("timeoutSecs=");
        stringBuilder.append(l);
        stringBuilder.append("\n");
        if (abstractCertRevocContext.isLoggable(Level.FINEST)) {
            abstractCertRevocContext.log(Level.FINEST, "OCSP configStream=\"{0}\"", stringBuilder.toString());
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(stringBuilder.toString().getBytes("US-ASCII"));
        OCSP oCSP = new OCSP(OCSP_PROVIDER_NAME, oCSPResponder, (InputStream)byteArrayInputStream);
        return oCSP;
    }

    private CertRevocationInfo checkCertRevocation(X500Principal x500Principal, X509Certificate x509Certificate, X509Certificate x509Certificate2, X509Certificate x509Certificate3, JSAFE_PrivateKey jSAFE_PrivateKey, X509Certificate x509Certificate4) throws InvalidParameterException, ProviderManagementException, InvalidUseException, NoServiceException, DatabaseException, UnsupportedEncodingException, CertificateException, NameException, CertStatusException {
        Util.checkNotNull("issuerDn", x500Principal);
        Util.checkNotNull("certToCheck", x509Certificate);
        Util.checkNotNull("issuerCert", x509Certificate2);
        CertJ certJ = this.initCertJ();
        DatabaseService databaseService = this.initDbService(x509Certificate3, x509Certificate2, x509Certificate4, jSAFE_PrivateKey, certJ);
        CertPathCtx certPathCtx = this.initCertPathCtx(x500Principal, x509Certificate2, x509Certificate3, databaseService);
        OCSPResponder oCSPResponder = this.initOcspResponder(x509Certificate4, x509Certificate3, x500Principal, x509Certificate2, databaseService);
        OCSP oCSP = this.initOcspProvider(x500Principal, oCSPResponder);
        certJ.registerService((Provider)oCSP);
        CertRevocationInfo certRevocationInfo = certJ.checkCertRevocation(certPathCtx, (Certificate)x509Certificate);
        return certRevocationInfo;
    }

    private CertRevocStatus evalRevocationInfo(java.security.cert.X509Certificate x509Certificate, CertRevocationInfo certRevocationInfo) {
        Util.checkNotNull("certToCheck", x509Certificate);
        AbstractCertRevocContext abstractCertRevocContext = this.getContext();
        if (null == certRevocationInfo) {
            if (abstractCertRevocContext.isLoggable(Level.FINER)) {
                abstractCertRevocContext.log(Level.FINER, "Revocation status unavailable from OCSP (CertRevocationInfo is null).", new Object[0]);
            }
            return null;
        }
        Boolean bl = RsaUtil.evalRevocStatusCode(CertRevocCheckMethodList.SelectableMethod.OCSP, certRevocationInfo.getStatus(), abstractCertRevocContext.getLogListener());
        if (null == bl) {
            return null;
        }
        int n = certRevocationInfo.getType();
        if (n != 2) {
            if (abstractCertRevocContext.isLoggable(Level.FINE)) {
                abstractCertRevocContext.log(Level.FINE, "Revocation status unavailable from OCSP, unexpected evidence type {0}.", n);
            }
            return null;
        }
        OCSPEvidence oCSPEvidence = (OCSPEvidence)certRevocationInfo.getEvidence();
        if (null == oCSPEvidence) {
            if (abstractCertRevocContext.isLoggable(Level.FINE)) {
                abstractCertRevocContext.log(Level.FINE, "Revocation status unavailable from OCSP, no evidence available.", new Object[0]);
            }
            return null;
        }
        int n2 = oCSPEvidence.getFlags();
        boolean bl2 = DefaultOcspChecker.isNonceIgnored(n2);
        Date date = null;
        Integer n3 = null;
        OCSPRevocationInfo oCSPRevocationInfo = oCSPEvidence.getRevocationInfo();
        if (null != oCSPRevocationInfo) {
            date = oCSPRevocationInfo.getRevocationTime();
            n3 = oCSPRevocationInfo.getReasonCode();
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(10);
        hashMap.put("Flags", Integer.toString(n2, 2));
        hashMap.put("ProducedAt", CertRevocStatus.format(oCSPEvidence.getProducedAt()));
        hashMap.put("RevocationTime", CertRevocStatus.format(date));
        hashMap.put("ReasonCode", null == n3 ? null : n3.toString());
        return new CertRevocStatus(CertRevocCheckMethodList.SelectableMethod.OCSP, x509Certificate.getSubjectX500Principal(), x509Certificate.getIssuerX500Principal(), x509Certificate.getSerialNumber(), oCSPEvidence.getThisUpdate(), oCSPEvidence.getNextUpdate(), bl, bl2, hashMap);
    }

    private static boolean isNonceIgnored(int n) {
        return (n & 1) != 0;
    }
}

