/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.pki.revocation.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import javax.security.auth.x500.X500Principal;
import weblogic.security.pki.revocation.common.AbstractCertRevocContext;
import weblogic.security.pki.revocation.common.CrlCacheAccessor;
import weblogic.security.pki.revocation.common.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DeleteInvalidCrlFromCacheRunnable
implements Runnable {
    private final AbstractCertRevocContext context;
    private final File crlCacheDir;
    private final CrlCacheAccessor crlCacheAccessor;
    private static final int INDEX_INITIAL_CAPACITY = 96;
    private static final Map<File, IndexValue> crlFileIndex = new ConcurrentHashMap<File, IndexValue>(96);

    DeleteInvalidCrlFromCacheRunnable(AbstractCertRevocContext abstractCertRevocContext, File file, CrlCacheAccessor crlCacheAccessor) {
        Util.checkNotNull("AbstractCertRevocContext", abstractCertRevocContext);
        Util.checkNotNull("crlCacheDir", file);
        Util.checkNotNull("crlCacheAccessor", crlCacheAccessor);
        file = new File(file, "crls");
        this.context = abstractCertRevocContext;
        this.crlCacheDir = file;
        this.crlCacheAccessor = crlCacheAccessor;
    }

    @Override
    public void run() {
        block2: {
            try {
                this.syncIndex();
                this.deleteInvalid();
            }
            catch (Exception exception) {
                if (!this.context.isLoggable(Level.FINE)) break block2;
                this.context.log(Level.FINE, exception, "Exception while checking for invalid CRLs within directory \"{0}\".", this.crlCacheDir);
            }
        }
    }

    private void syncIndex() {
        HashMap<File, IndexValue> hashMap = new HashMap<File, IndexValue>(crlFileIndex);
        File[] fileArray = this.crlCacheDir.listFiles(Util.CRL_FILES_ONLY_FILTER);
        if (null == fileArray) {
            return;
        }
        for (File file : fileArray) {
            if (null == file) continue;
            IndexValue indexValue = crlFileIndex.get(file);
            if (null == indexValue) {
                IndexValue indexValue2;
                block8: {
                    indexValue2 = null;
                    try {
                        indexValue2 = this.getIndexValue(file);
                    }
                    catch (Exception exception) {
                        if (!this.context.isLoggable(Level.FINE)) break block8;
                        this.context.log(Level.FINE, exception, "Exception while indexing found CRL in cache: file={0}", file);
                    }
                }
                if (null != indexValue2) {
                    crlFileIndex.put(file, indexValue2);
                }
                Util.backgroundTaskSleep();
                continue;
            }
            hashMap.remove(file);
        }
        if (!hashMap.isEmpty()) {
            for (File file : hashMap.keySet()) {
                crlFileIndex.remove(file);
            }
        }
    }

    private void deleteInvalid() {
        if (!crlFileIndex.isEmpty()) {
            int n = this.context.getCrlCacheRefreshPeriodPercent();
            for (Map.Entry<File, IndexValue> entry : crlFileIndex.entrySet()) {
                if (!this.isInvalid(entry, n)) continue;
                this.deleteFromCrlCache(entry);
                Util.backgroundTaskSleep();
            }
        }
    }

    private boolean isInvalid(Map.Entry<File, IndexValue> entry, int n) {
        IndexValue indexValue = entry.getValue();
        Date date = indexValue.getNextUpdate();
        if (null == date) {
            return true;
        }
        long l = indexValue.getThisUpdate().getTime();
        long l2 = date.getTime();
        if (l2 <= l) {
            return true;
        }
        long l3 = l2 - l;
        long l4 = l3 * (long)n / 100L;
        long l5 = l + l4;
        long l6 = new Date().getTime();
        return l6 >= l5;
    }

    private void deleteFromCrlCache(Map.Entry<File, IndexValue> entry) {
        block3: {
            IndexValue indexValue = entry.getValue();
            try {
                this.crlCacheAccessor.deleteCrl(indexValue.getIssuerX500Name(), indexValue.getThisUpdate());
                if (this.context.isLoggable(Level.FINEST)) {
                    this.context.log(Level.FINEST, "Deleted CRL from cache: file={0}, {1}", entry.getKey(), entry.getValue());
                }
            }
            catch (Exception exception) {
                if (!this.context.isLoggable(Level.FINE)) break block3;
                this.context.log(Level.FINE, exception, "Exception while deleting CRL from cache: file={0}, {1}", entry.getKey(), entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexValue getIndexValue(File file) throws Exception {
        Object object;
        X509CRL x509CRL = null;
        Exception exception = null;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            object = CertificateFactory.getInstance("X.509");
            x509CRL = (X509CRL)((CertificateFactory)object).generateCRL(fileInputStream);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            exception = new RuntimeException(outOfMemoryError);
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        finally {
            if (null != fileInputStream) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        object = null;
        if (null != exception) {
            throw exception;
        }
        if (null == x509CRL) {
            if (this.context.isLoggable(Level.FINER)) {
                this.context.log(Level.FINER, "Reading CRL from file \"{0}\", no generated CRL.", file);
            }
        } else {
            Date date;
            X500Principal x500Principal = x509CRL.getIssuerX500Principal();
            if (null == x500Principal && this.context.isLoggable(Level.FINER)) {
                this.context.log(Level.FINER, "Reading CRL from file \"{0}\", no issuer.", file);
            }
            if (null == (date = x509CRL.getThisUpdate()) && this.context.isLoggable(Level.FINER)) {
                this.context.log(Level.FINER, "Reading CRL from file \"{0}\", no ThisUpdate.", file);
            }
            Date date2 = x509CRL.getNextUpdate();
            if (null != x500Principal && null != date) {
                object = new IndexValue(x500Principal, date, date2);
            }
        }
        return object;
    }

    private static final class IndexValue {
        private final Date thisUpdate;
        private final Date nextUpdate;
        private final X500Principal issuerX500Name;

        private IndexValue(X500Principal x500Principal, Date date, Date date2) {
            Util.checkNotNull("issuerX500Name", x500Principal);
            Util.checkNotNull("thisUpdate", date);
            this.issuerX500Name = x500Principal;
            this.thisUpdate = date;
            this.nextUpdate = date2;
        }

        public X500Principal getIssuerX500Name() {
            return this.issuerX500Name;
        }

        public Date getThisUpdate() {
            return this.thisUpdate;
        }

        public Date getNextUpdate() {
            return this.nextUpdate;
        }

        public String toString() {
            return MessageFormat.format("Issuer={0}, ThisUpdate={1}, NextUpdate={2}", this.issuerX500Name, this.thisUpdate, this.nextUpdate);
        }
    }
}

