/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.pki.revocation.common;

import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import javax.security.auth.x500.X500Principal;
import weblogic.security.pki.revocation.common.AbstractCertRevocContext;
import weblogic.security.pki.revocation.common.CrlCacheAccessor;
import weblogic.security.pki.revocation.common.CrlDpFetcher;
import weblogic.security.pki.revocation.common.LogListener;
import weblogic.security.pki.revocation.common.Util;

final class DownloadCrlFromDpRunnable
implements Runnable {
    private volatile boolean running = true;
    private volatile boolean crlCacheUpdated = false;
    private final CrlCacheAccessor crlCacheAccessor;
    private final Object waitingObject;
    private final X509Certificate certWithDp;
    private final LogListener logger;
    private final URI alternateUri;
    private final AbstractCertRevocContext.AttributeUsage alternateUriUsage;
    private final long dpDownloadTimeout;

    DownloadCrlFromDpRunnable(CrlCacheAccessor crlCacheAccessor, Object object, X509Certificate x509Certificate, LogListener logListener, URI uRI, AbstractCertRevocContext.AttributeUsage attributeUsage, long l) {
        Util.checkNotNull("crlCacheAccessor", crlCacheAccessor);
        Util.checkNotNull("certWithDp", x509Certificate);
        Util.checkNotNull("waitingObject", object);
        this.crlCacheAccessor = crlCacheAccessor;
        this.waitingObject = object;
        this.certWithDp = x509Certificate;
        this.logger = logListener;
        this.alternateUri = uRI;
        this.alternateUriUsage = attributeUsage;
        this.dpDownloadTimeout = l;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isCrlCacheUpdated() {
        return this.crlCacheUpdated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object = this.waitingObject;
        synchronized (object) {
            X500Principal x500Principal = this.certWithDp.getSubjectX500Principal();
            String string = null == x500Principal ? "" : x500Principal.getName();
            try {
                long l = this.dpDownloadTimeout;
                long l2 = this.dpDownloadTimeout;
                CrlDpFetcher crlDpFetcher = CrlDpFetcher.getInstance();
                this.crlCacheUpdated = crlDpFetcher.updateCrls(this.certWithDp, this.crlCacheAccessor, this.alternateUri, this.alternateUriUsage, l, l2, this.logger);
            }
            catch (Exception exception) {
                if (null != this.logger && this.logger.isLoggable(Level.FINE)) {
                    this.logger.log(Level.FINE, exception, "Trying to download CRLs from Distribution Point for cert subject \"{0}\".", string);
                }
            }
            finally {
                this.running = false;
                if (null != this.waitingObject) {
                    this.waitingObject.notifyAll();
                }
            }
        }
    }
}

