/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.pki.revocation.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.logging.Level;
import weblogic.security.pki.revocation.common.CrlCacheAccessor;
import weblogic.security.pki.revocation.common.LogListener;
import weblogic.security.pki.revocation.common.Util;

final class ImportCrlFromFileRunnable
implements Runnable {
    private final File importDir;
    private final CrlCacheAccessor crlCacheAccessor;
    private final LogListener logger;

    ImportCrlFromFileRunnable(File file, CrlCacheAccessor crlCacheAccessor, LogListener logListener) {
        Util.checkNotNull("importDir", file);
        Util.checkNotNull("crlCacheAccessor", crlCacheAccessor);
        this.importDir = file;
        this.crlCacheAccessor = crlCacheAccessor;
        this.logger = logListener;
    }

    public void run() {
        block6: {
            File file = null;
            try {
                File[] fileArray = this.importDir.listFiles(Util.CRL_FILES_ONLY_FILTER);
                if (null == fileArray) {
                    return;
                }
                for (File file2 : fileArray) {
                    if (null == file2) continue;
                    file = file2;
                    if (null != this.logger && this.logger.isLoggable(Level.FINEST)) {
                        this.logger.log(Level.FINEST, "Trying to import CRL from file \"{0}\".", file2);
                    }
                    this.loadCrl(file2);
                    this.delete(file2);
                    if (null != this.logger && this.logger.isLoggable(Level.FINEST)) {
                        this.logger.log(Level.FINEST, "Successfully imported CRL from file \"{0}\".", file2);
                    }
                    Util.backgroundTaskSleep();
                }
            }
            catch (Exception exception) {
                if (null == this.logger || !this.logger.isLoggable(Level.FINE)) break block6;
                this.logger.log(Level.FINE, exception, "Trying to import CRLs from directory \"{0}\", last attempted file \"{1}\".", this.importDir, file);
            }
        }
    }

    private void delete(File file) {
        block6: {
            try {
                if (file.delete()) {
                    if (null != this.logger && this.logger.isLoggable(Level.FINEST)) {
                        this.logger.log(Level.FINEST, "Successfully deleted CRL file \"{0}\".", file);
                    }
                } else if (null != this.logger && this.logger.isLoggable(Level.FINE)) {
                    this.logger.log(Level.FINE, "Unable to delete CRL file \"{0}\".", file);
                }
            }
            catch (Exception exception) {
                if (null == this.logger || !this.logger.isLoggable(Level.FINE)) break block6;
                this.logger.log(Level.FINE, exception, "Error occurred while deleting CRL file \"{0}\".", file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCrl(File file) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            boolean bl = this.crlCacheAccessor.loadCrl(fileInputStream);
            if (null != this.logger && this.logger.isLoggable(Level.FINEST)) {
                this.logger.log(Level.FINEST, "Loaded CRL cache from file \"{0}\", cacheUpdated={1}.", file, bl);
            }
        }
        catch (Exception exception) {
            if (null != this.logger && this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, exception, "Error occurred trying to load CRL cache from file \"{0}\".", file);
            }
        }
        finally {
            if (null != fileInputStream) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

