/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.pki.revocation.common;

import java.security.cert.X509Certificate;
import java.util.logging.Level;
import javax.security.auth.x500.X500Principal;
import weblogic.security.pki.revocation.common.AbstractCertRevocContext;
import weblogic.security.pki.revocation.common.AbstractRevocChecker;
import weblogic.security.pki.revocation.common.CertRevocStatus;
import weblogic.security.pki.revocation.common.CertRevocStatusCache;
import weblogic.security.pki.revocation.common.DefaultOcspChecker;
import weblogic.security.pki.revocation.common.Util;

abstract class OcspChecker
extends AbstractRevocChecker {
    private static final CertRevocStatusCache ocspStatusCache = CertRevocStatusCache.getInstance();

    public static OcspChecker getInstance(AbstractCertRevocContext abstractCertRevocContext) {
        return new DefaultOcspChecker(abstractCertRevocContext);
    }

    OcspChecker(AbstractCertRevocContext abstractCertRevocContext) {
        super(abstractCertRevocContext);
    }

    final CertRevocStatus getCertRevocStatus(X509Certificate x509Certificate, X509Certificate x509Certificate2) {
        Util.checkNotNull("Issuer X509Certificate.", x509Certificate);
        Util.checkNotNull("X509Certificate to be checked.", x509Certificate2);
        AbstractCertRevocContext abstractCertRevocContext = this.getContext();
        X500Principal x500Principal = x509Certificate2.getIssuerX500Principal();
        boolean bl = abstractCertRevocContext.isOcspResponseCacheEnabled(x500Principal);
        if (abstractCertRevocContext.isLoggable(Level.FINEST)) {
            abstractCertRevocContext.log(Level.FINEST, "OcspResponseCacheEnabled={0}", bl);
        }
        boolean bl2 = abstractCertRevocContext.isOcspNonceEnabled(x500Principal);
        if (abstractCertRevocContext.isLoggable(Level.FINEST)) {
            abstractCertRevocContext.log(Level.FINEST, "OcspNonceEnabled={0}", bl2);
        }
        CertRevocStatus certRevocStatus = null;
        if (bl) {
            if (bl2) {
                this.updateCachedStatus(x509Certificate2, null);
            } else {
                certRevocStatus = this.getCachedStatus(x509Certificate2);
                if (null != certRevocStatus) {
                    if (abstractCertRevocContext.isLoggable(Level.FINEST)) {
                        abstractCertRevocContext.log(Level.FINEST, "Revocation status found in OCSP cache.", new Object[0]);
                    }
                    return certRevocStatus;
                }
                if (abstractCertRevocContext.isLoggable(Level.FINEST)) {
                    abstractCertRevocContext.log(Level.FINEST, "Revocation status not found in OCSP cache.", new Object[0]);
                }
            }
        }
        if (null != (certRevocStatus = this.getRemoteStatus(x509Certificate, x509Certificate2)) && bl2) {
            certRevocStatus = this.checkRequiredNonce(certRevocStatus);
        }
        if (bl && !bl2) {
            this.updateCachedStatus(x509Certificate2, certRevocStatus);
        }
        return certRevocStatus;
    }

    private CertRevocStatus getCachedStatus(X509Certificate x509Certificate) {
        Util.checkNotNull("X509Certificate to be checked.", x509Certificate);
        AbstractCertRevocContext abstractCertRevocContext = this.getContext();
        X500Principal x500Principal = x509Certificate.getIssuerX500Principal();
        int n = abstractCertRevocContext.getOcspTimeTolerance(x500Principal);
        if (abstractCertRevocContext.isLoggable(Level.FINEST)) {
            abstractCertRevocContext.log(Level.FINEST, "OcspTimeTolerance={0}", n);
        }
        int n2 = abstractCertRevocContext.getOcspResponseCacheRefreshPeriodPercent();
        if (abstractCertRevocContext.isLoggable(Level.FINEST)) {
            abstractCertRevocContext.log(Level.FINEST, "OcspResponseCacheRefreshPeriodPercent={0}", n2);
        }
        return ocspStatusCache.getStatus(x509Certificate, n, n2, abstractCertRevocContext.getLogListener());
    }

    private void updateCachedStatus(X509Certificate x509Certificate, CertRevocStatus certRevocStatus) {
        Util.checkNotNull("X509Certificate to be checked.", x509Certificate);
        AbstractCertRevocContext abstractCertRevocContext = this.getContext();
        X500Principal x500Principal = x509Certificate.getIssuerX500Principal();
        int n = abstractCertRevocContext.getOcspTimeTolerance(x500Principal);
        if (abstractCertRevocContext.isLoggable(Level.FINEST)) {
            abstractCertRevocContext.log(Level.FINEST, "OcspTimeTolerance={0}", n);
        }
        int n2 = abstractCertRevocContext.getOcspResponseCacheRefreshPeriodPercent();
        if (abstractCertRevocContext.isLoggable(Level.FINEST)) {
            abstractCertRevocContext.log(Level.FINEST, "OcspResponseCacheRefreshPeriodPercent={0}", n2);
        }
        int n3 = abstractCertRevocContext.getOcspResponseCacheCapacity();
        if (abstractCertRevocContext.isLoggable(Level.FINEST)) {
            abstractCertRevocContext.log(Level.FINEST, "OcspResponseCacheCapacity={0}", n3);
        }
        ocspStatusCache.putStatus(x509Certificate, certRevocStatus, n, n2, n3, abstractCertRevocContext.getLogListener());
    }

    private CertRevocStatus checkRequiredNonce(CertRevocStatus certRevocStatus) {
        Util.checkNotNull("CertRevocStatus", certRevocStatus);
        if (!certRevocStatus.isNonceIgnored().booleanValue()) {
            return certRevocStatus;
        }
        AbstractCertRevocContext abstractCertRevocContext = this.getContext();
        if (abstractCertRevocContext.isLoggable(Level.FINE)) {
            abstractCertRevocContext.log(Level.FINE, "OCSP responder ignored nonce, so response was ignored, which was:\n{0}", certRevocStatus);
        }
        abstractCertRevocContext.logIgnoredNonceCertRevocStatus(certRevocStatus);
        return null;
    }

    abstract CertRevocStatus getRemoteStatus(X509Certificate var1, X509Certificate var2);
}

