/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.pki.revocation.common;

import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import javax.security.auth.x500.X500Principal;
import weblogic.security.pki.revocation.common.AbstractCertRevocContext;
import weblogic.security.pki.revocation.common.CertRevocCheckMethodList;
import weblogic.security.pki.revocation.common.CertRevocStatus;
import weblogic.security.pki.revocation.common.CrlCacheAccessor;
import weblogic.security.pki.revocation.common.CrlCacheUpdater;
import weblogic.security.pki.revocation.common.CrlChecker;
import weblogic.security.pki.revocation.common.OcspChecker;
import weblogic.security.pki.revocation.common.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RevocationCertPathChecker
extends PKIXCertPathChecker {
    private static final String CLASSNAME = RevocationCertPathChecker.class.getName();
    private final AbstractCertRevocContext context;
    private final OcspChecker ocspChecker;
    private final CrlChecker crlChecker;
    private X509Certificate issuerX509Cert;

    public static RevocationCertPathChecker getInstance(AbstractCertRevocContext abstractCertRevocContext) {
        return new RevocationCertPathChecker(abstractCertRevocContext);
    }

    private RevocationCertPathChecker(AbstractCertRevocContext abstractCertRevocContext) {
        Util.checkNotNull("AbstractCertRevocContext", abstractCertRevocContext);
        this.context = abstractCertRevocContext;
        this.ocspChecker = OcspChecker.getInstance(abstractCertRevocContext);
        this.crlChecker = CrlChecker.getInstance(abstractCertRevocContext);
    }

    @Override
    public void init(boolean bl) throws CertPathValidatorException {
        if (this.context.isLoggable(Level.FINEST)) {
            this.context.log(Level.FINEST, "{0}.init called (forward not supported), forward={1}.", CLASSNAME, bl);
        }
        this.issuerX509Cert = null;
        if (bl) {
            throw new CertPathValidatorException("Forward checking is not supported.");
        }
    }

    @Override
    public boolean isForwardCheckingSupported() {
        return false;
    }

    @Override
    public Set<String> getSupportedExtensions() {
        Set<String> set = Collections.emptySet();
        if (this.context.isLoggable(Level.FINEST)) {
            this.context.log(Level.FINEST, "{0}.getSupportedExtensions called.", CLASSNAME);
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void check(Certificate certificate, Collection<String> collection) throws CertPathValidatorException {
        X500Principal x500Principal;
        X500Principal x500Principal2;
        X509Certificate x509Certificate;
        block27: {
            if (this.isCertToCheckNull(certificate) || !this.isCertToCheckX509(certificate)) {
                this.issuerX509Cert = null;
                return;
            }
            x509Certificate = (X509Certificate)certificate;
            if (!this.isEnabled()) {
                CrlCacheUpdater.cancelAllMaintenanceTasks(this.context.getLogListener());
                this.issuerX509Cert = x509Certificate;
                return;
            }
            if (!CrlCacheUpdater.isAllMaintenanceTasksActive()) {
                this.startAllMaintenanceTasks();
            }
            x500Principal2 = x509Certificate.getSubjectX500Principal();
            x500Principal = x509Certificate.getIssuerX500Principal();
            if (this.context.isLoggable(Level.FINE)) {
                this.context.log(Level.FINE, "Revocation status checking X509 certificate with subject \"{0}\" and issuer \"{1}\".", x500Principal2, x500Principal);
            }
            if (this.isIssuerDnMissing(x500Principal)) {
                this.issuerX509Cert = x509Certificate;
                return;
            }
            if (!this.isCheckingDisabled(x500Principal)) break block27;
            this.issuerX509Cert = x509Certificate;
            return;
        }
        try {
            boolean bl;
            block30: {
                block29: {
                    block28: {
                        bl = this.isFailOnUnknownRevocStatus(x500Principal);
                        if (this.ensureIssuerCert(x500Principal, bl)) break block28;
                        this.issuerX509Cert = x509Certificate;
                        return;
                    }
                    if (!this.isSubjectDnMissing(bl, x500Principal2)) break block29;
                    this.issuerX509Cert = x509Certificate;
                    return;
                }
                if (this.isExpectedIssuer(x500Principal, bl)) break block30;
                this.issuerX509Cert = x509Certificate;
                return;
            }
            try {
                CertRevocStatus certRevocStatus = null;
                CertRevocCheckMethodList certRevocCheckMethodList = this.context.getMethodOrder(x500Principal);
                Iterator<CertRevocCheckMethodList.SelectableMethod> iterator = certRevocCheckMethodList.iterator();
                block16: while (null == certRevocStatus && iterator.hasNext()) {
                    CertRevocCheckMethodList.SelectableMethod selectableMethod = iterator.next();
                    if (this.context.isLoggable(Level.FINEST)) {
                        this.context.log(Level.FINEST, "Trying revocation check using method {0}.", new Object[]{selectableMethod});
                    }
                    if (null == selectableMethod) {
                        if (!this.context.isLoggable(Level.FINER)) continue;
                        this.context.log(Level.FINER, "Skipping null revocation check method.", new Object[0]);
                        continue;
                    }
                    switch (selectableMethod) {
                        case OCSP: {
                            certRevocStatus = this.ocspChecker.getCertRevocStatus(this.issuerX509Cert, x509Certificate);
                            continue block16;
                        }
                        case CRL: {
                            certRevocStatus = this.crlChecker.getCertRevocStatus(this.issuerX509Cert, x509Certificate);
                            continue block16;
                        }
                    }
                    if (!this.context.isLoggable(Level.FINE)) continue;
                    this.context.log(Level.FINE, "Skipping unknown SelectableMethod: {0}", new Object[]{selectableMethod});
                }
                if (this.context.isLoggable(Level.FINEST)) {
                    this.context.log(Level.FINEST, "The revocation status of certificate {0} is:\n{1}.", x500Principal2, certRevocStatus == null ? "Unknown" : certRevocStatus);
                }
                if (null == certRevocStatus) {
                    if (!bl) return;
                    throw new CertPathValidatorException("Unknown revocation status for certificate \"" + x500Principal2 + "\".");
                }
                if (!certRevocStatus.isRevoked()) return;
                throw new CertPathValidatorException("Certificate revoked: \"" + x500Principal2 + "\".");
            }
            catch (Exception exception) {
                if (this.context.isLoggable(Level.FINE)) {
                    this.context.log(Level.FINE, exception, "An exception occurred while checking revocation of certificate={0},\nexception={1}", x500Principal2, exception.getMessage());
                }
                if (!bl) return;
                if (!(exception instanceof CertPathValidatorException)) throw new CertPathValidatorException("Unknown revocation status for certificate \"" + x500Principal2 + "\".", exception);
                throw (CertPathValidatorException)exception;
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            this.issuerX509Cert = x509Certificate;
        }
    }

    private void startAllMaintenanceTasks() {
        CrlCacheAccessor crlCacheAccessor = this.crlChecker.getCrlCacheAccessor();
        if (null == crlCacheAccessor) {
            return;
        }
        CrlCacheUpdater.startAllMaintenanceTasks(crlCacheAccessor, this.context);
    }

    private boolean isCheckingDisabled(X500Principal x500Principal) {
        if (this.context.isCheckingDisabled(x500Principal)) {
            if (this.context.isLoggable(Level.FINE)) {
                this.context.log(Level.FINE, "Revocation status checking is disabled for issuer \"{0}\".", x500Principal);
            }
            return true;
        }
        if (this.context.isLoggable(Level.FINE)) {
            this.context.log(Level.FINE, "Revocation status checking is enabled for issuer \"{0}\".", x500Principal);
        }
        return false;
    }

    private boolean isSubjectDnMissing(boolean bl, X500Principal x500Principal) throws CertPathValidatorException {
        if (null == x500Principal || null == x500Principal.getName() || x500Principal.getName().length() == 0) {
            if (bl) {
                throw new CertPathValidatorException("Unknown Revocation Status: Certificate to check has no subject.");
            }
            if (this.context.isLoggable(Level.FINE)) {
                this.context.log(Level.FINE, "Skipping revocation status checking since certificate to check has no subject.", new Object[0]);
            }
            return true;
        }
        return false;
    }

    private boolean isIssuerDnMissing(X500Principal x500Principal) {
        if (null == x500Principal || null == x500Principal.getName() || x500Principal.getName().length() == 0) {
            if (this.context.isLoggable(Level.FINE)) {
                this.context.log(Level.FINE, "Unable to check revocation status, missing issuer DN.", new Object[0]);
            }
            return true;
        }
        return false;
    }

    private boolean isCertToCheckX509(Certificate certificate) {
        if (certificate instanceof X509Certificate) {
            return true;
        }
        if (this.context.isLoggable(Level.FINE)) {
            this.context.log(Level.FINE, "Unable to check revocation of certificate of type {0}.", null == certificate ? null : certificate.getClass().getName());
        }
        return false;
    }

    private boolean isCertToCheckNull(Certificate certificate) {
        if (null == certificate) {
            if (this.context.isLoggable(Level.FINE)) {
                this.context.log(Level.FINE, "Given null certificate, no revocation checking is needed.", new Object[0]);
            }
            return true;
        }
        return false;
    }

    private boolean isEnabled() {
        boolean bl = this.context.isCheckingEnabled();
        if (this.context.isLoggable(Level.FINE)) {
            this.context.log(Level.FINE, "Certificate revocation checking is {0}.", bl ? "enabled" : "disabled");
        }
        return bl;
    }

    private boolean isFailOnUnknownRevocStatus(X500Principal x500Principal) {
        boolean bl = this.context.isFailOnUnknownRevocStatus(x500Principal);
        if (this.context.isLoggable(Level.FINE)) {
            this.context.log(Level.FINE, "Certificate validation will {0} if revocation status is indeterminable.", bl ? "FAIL" : "not be affected");
        }
        return bl;
    }

    private boolean ensureIssuerCert(X500Principal x500Principal, boolean bl) throws CertPathValidatorException {
        if (null == this.issuerX509Cert) {
            this.issuerX509Cert = this.context.getValidTrustedCert(x500Principal);
            if (null == this.issuerX509Cert) {
                if (bl) {
                    throw new CertPathValidatorException("Unknown Revocation Status: Could not find trusted issuer certificate with subject \"" + x500Principal + "\".");
                }
                if (this.context.isLoggable(Level.FINE)) {
                    this.context.log(Level.FINE, "Skipping revocation status checking since cannot find trusted issuer certificate with subject \"{0}\".", x500Principal);
                }
                return false;
            }
        }
        return true;
    }

    private boolean isExpectedIssuer(X500Principal x500Principal, boolean bl) throws CertPathValidatorException {
        X500Principal x500Principal2 = this.issuerX509Cert.getSubjectX500Principal();
        if (!x500Principal.equals(x500Principal2)) {
            if (bl) {
                throw new CertPathValidatorException("Unexpected issuer for certificate to check, expected issuer=\"" + x500Principal2 + "\".");
            }
            if (this.context.isLoggable(Level.FINE)) {
                this.context.log(Level.FINE, "Unexpected issuer for certificate to check, expected issuer=\n{0}.", x500Principal2);
            }
            return false;
        }
        return true;
    }
}

