/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.pki.revocation.common;

import com.rsa.certj.CertJVersion;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.X509CRL;
import com.rsa.certj.cert.X509V3Extensions;
import com.rsa.certj.cert.extensions.X509V3Extension;
import com.rsa.jsafe.CryptoJ;
import com.rsa.jsafe.JSAFE_PrivateKey;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import weblogic.security.pki.revocation.common.CertRevocCheckMethodList;
import weblogic.security.pki.revocation.common.LogListener;
import weblogic.security.pki.revocation.common.Util;

final class RsaUtil {
    private static final String DEVICE_NAME = "Java";

    RsaUtil() {
    }

    static String getCryptoJDeviceList() {
        return DEVICE_NAME;
    }

    /*
     * Enabled aggressive block sorting
     */
    static boolean isFIPS140UsageOk(LogListener logListener) {
        if (!CertJVersion.isFIPS140Compliant()) {
            if (null == logListener) return true;
            if (!logListener.isLoggable(Level.FINEST)) return true;
            logListener.log(Level.FINEST, "Not using FIPS 140 compliant implementation.", new Object[0]);
            return true;
        }
        if (CryptoJ.selfTestPassed()) {
            if (null == logListener) return true;
            if (!logListener.isLoggable(Level.FINEST)) return true;
            logListener.log(Level.FINEST, "Using FIPS 140 compliant implementation, self-tests passed.", new Object[0]);
            return true;
        }
        if (null == logListener) return false;
        if (!logListener.isLoggable(Level.FINE)) return false;
        logListener.log(Level.FINE, "Using FIPS 140 compliant implementation, however self-tests failed.", new Object[0]);
        return false;
    }

    static com.rsa.certj.cert.X509Certificate toRsaCert(X509Certificate x509Certificate, LogListener logListener) {
        Util.checkNotNull("java.security.cert.X509Certificate", x509Certificate);
        try {
            int n = 0;
            int n2 = 0;
            return new com.rsa.certj.cert.X509Certificate(x509Certificate.getEncoded(), n, n2);
        }
        catch (Exception exception) {
            if (null != logListener && logListener.isLoggable(Level.FINE)) {
                logListener.log(Level.FINE, exception, "Unable to convert java.security.cert.X509Certificate {0}.", x509Certificate);
            }
            return null;
        }
    }

    static JSAFE_PrivateKey toRsaPrivateKey(PrivateKey privateKey, LogListener logListener) {
        Util.checkNotNull("java.security.PrivateKey", privateKey);
        try {
            int n = 0;
            String string = RsaUtil.getCryptoJDeviceList();
            return JSAFE_PrivateKey.getInstance((byte[])privateKey.getEncoded(), (int)n, (String)string);
        }
        catch (Exception exception) {
            if (null != logListener && logListener.isLoggable(Level.FINE)) {
                logListener.log(Level.FINE, exception, "Unable to convert java.security.PrivateKey.", new Object[0]);
            }
            return null;
        }
    }

    static Boolean evalRevocStatusCode(CertRevocCheckMethodList.SelectableMethod selectableMethod, int n, LogListener logListener) {
        Util.checkNotNull("SelectableMethod", (Object)selectableMethod);
        switch (n) {
            case 2: {
                if (null != logListener && logListener.isLoggable(Level.FINEST)) {
                    logListener.log(Level.FINEST, "Revocation status unknown from {0}.", new Object[]{selectableMethod});
                }
                return null;
            }
            case 0: {
                return Boolean.FALSE;
            }
            case 1: {
                return Boolean.TRUE;
            }
        }
        if (null != logListener && logListener.isLoggable(Level.FINE)) {
            logListener.log(Level.FINE, "Revocation status unknown from {0}, unknown revocation status code {1}.", new Object[]{selectableMethod, n});
        }
        return null;
    }

    static X509V3Extension getExtension(X509CRL x509CRL, int n) {
        if (x509CRL == null) {
            return null;
        }
        return RsaUtil.getExtension(x509CRL.getExtensions(), n);
    }

    static X509V3Extension getExtension(com.rsa.certj.cert.X509Certificate x509Certificate, int n) {
        if (x509Certificate == null) {
            return null;
        }
        return RsaUtil.getExtension(x509Certificate.getExtensions(), n);
    }

    static X509V3Extension getExtension(X509V3Extensions x509V3Extensions, int n) {
        X509V3Extension x509V3Extension = null;
        if (x509V3Extensions != null) {
            try {
                x509V3Extension = x509V3Extensions.getExtensionByType(n);
            }
            catch (CertificateException certificateException) {
                // empty catch block
            }
        }
        return x509V3Extension;
    }
}

