/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.pki.revocation.common;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;

final class Util {
    private static final Locale FILE_EXTENSION_LOCALE = Locale.US;
    private static final String CRL_FILE_EXTENSION = ".crl";
    public static final CrlFilesOnlyFilter CRL_FILES_ONLY_FILTER = new CrlFilesOnlyFilter();

    Util() {
    }

    public static void checkNotNull(String string, Object object) {
        if (null == object) {
            throw new IllegalArgumentException("Expected non-null \"" + string + "\".");
        }
    }

    public static void checkRange(String string, Long l, Long l2, Long l3) {
        if (null == l) {
            return;
        }
        if (null == l2 && null == l3) {
            return;
        }
        if (null != l2 && l < l2) {
            throw new IllegalArgumentException("Value " + Util.formatValueName(string) + "minimum is " + l2 + ", was " + l + ".");
        }
        if (null != l3 && l > l3) {
            throw new IllegalArgumentException("Value " + Util.formatValueName(string) + "maximum is " + l3 + ", was " + l + ".");
        }
    }

    public static void checkTimeTolerance(int n) {
        Util.checkRange("timeTolerance", Long.valueOf(n), 0L, null);
    }

    public static void checkRefreshPeriodPercent(int n) {
        Util.checkRange("refreshPeriodPercent", Long.valueOf(n), 1L, 100L);
    }

    public static void backgroundTaskSleep() {
        try {
            Thread.currentThread();
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static byte[] readAll(InputStream inputStream) throws IOException {
        int n;
        Util.checkNotNull("InputStream", inputStream);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
        byteArrayOutputStream.reset();
        byte[] byArray = new byte[8192];
        while ((n = ((InputStream)bufferedInputStream).read(byArray, 0, byArray.length)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        return byArray2;
    }

    private static String formatValueName(String string) {
        return null == string ? "" : string + " ";
    }

    private static final class CrlFilesOnlyFilter
    implements FileFilter {
        private CrlFilesOnlyFilter() {
        }

        public boolean accept(File file) {
            String string;
            if (file != null && !file.isDirectory() && null != (string = file.getName())) {
                String string2 = string.toLowerCase(FILE_EXTENSION_LOCALE);
                return string2.endsWith(Util.CRL_FILE_EXTENSION);
            }
            return false;
        }
    }
}

