/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.pki.revocation.wls;

import java.io.File;
import java.math.BigInteger;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Set;
import java.util.logging.Level;
import javax.security.auth.x500.X500Principal;
import weblogic.kernel.Kernel;
import weblogic.management.DomainDir;
import weblogic.management.configuration.CertRevocCaMBean;
import weblogic.management.configuration.CertRevocMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.SecurityConfigurationMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.PropertyService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.security.SecurityLogger;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.pki.revocation.common.AbstractCertRevocContext;
import weblogic.security.pki.revocation.common.CertRevocCheckMethodList;
import weblogic.security.pki.revocation.common.CertRevocStatus;
import weblogic.security.pki.revocation.common.Timer;
import weblogic.security.pki.revocation.wls.WlsLogListener;
import weblogic.security.service.PrivilegedActions;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManagerFactory;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WlsCertRevocContext
extends AbstractCertRevocContext {
    public static final ExplicitTrustMethod DEFAULT_OCSP_RESPONDER_EXPLICIT_TRUST_METHOD = ExplicitTrustMethod.NONE;
    public static final X500Principal DEFAULT_OCSP_RESPONDER_CERT_SUBJECT_NAME = null;
    public static final String DEFAULT_OCSP_RESPONDER_CERT_SUBJECT_NAME_STRING = null;
    public static final X500Principal DEFAULT_OCSP_RESPONDER_CERT_ISSUER_NAME = null;
    public static final String DEFAULT_OCSP_RESPONDER_CERT_ISSUER_NAME_STRING = null;
    public static final BigInteger DEFAULT_OCSP_RESPONDER_CERT_SERIAL_NUMBER = null;
    public static final String DEFAULT_OCSP_RESPONDER_CERT_SERIAL_NUMBER_STRING = null;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public WlsCertRevocContext(Set<X509Certificate> set) {
        super(set, WlsLogListener.getInstance());
    }

    @Override
    public void logAttemptingCertRevocCheck(X500Principal x500Principal) {
        String string = WlsCertRevocContext.nameFrom(x500Principal);
        SecurityLogger.logAttemptingCertRevocCheck((String)string);
    }

    @Override
    public void logUnknownCertRevocStatusNoFail(X500Principal x500Principal) {
        String string = WlsCertRevocContext.nameFrom(x500Principal);
        SecurityLogger.logUnknownCertRevocStatusNoFail((String)string);
    }

    @Override
    public void logCertRevocStatus(CertRevocStatus certRevocStatus) {
        String string = WlsCertRevocContext.stringFrom(certRevocStatus);
        SecurityLogger.logCertRevocStatus((String)string);
    }

    @Override
    public void logIgnoredNonceCertRevocStatus(CertRevocStatus certRevocStatus) {
        String string = WlsCertRevocContext.stringFrom(certRevocStatus);
        SecurityLogger.logIgnoredNonceCertRevocStatus((String)string);
    }

    @Override
    public void logUnknownCertRevocStatusFail(X500Principal x500Principal) {
        String string = WlsCertRevocContext.nameFrom(x500Principal);
        SecurityLogger.logUnknownCertRevocStatusFail((String)string);
    }

    @Override
    public void logRevokedCertRevocStatusFail(X500Principal x500Principal) {
        String string = WlsCertRevocContext.nameFrom(x500Principal);
        SecurityLogger.logRevokedCertRevocStatusFail((String)string);
    }

    @Override
    public void logNotRevokedCertRevocStatusNotFail(X500Principal x500Principal) {
        String string = WlsCertRevocContext.nameFrom(x500Principal);
        SecurityLogger.logNotRevokedCertRevocStatusNotFail((String)string);
    }

    @Override
    public void schedule(Runnable runnable) {
        if (null == runnable) {
            throw new IllegalArgumentException("Expected non-null Runnable.");
        }
        WorkManager workManager = WorkManagerFactory.getInstance().getDefault();
        if (null == workManager) {
            throw new IllegalStateException("No weblogic.work.WorkManager available.");
        }
        workManager.schedule(runnable);
    }

    @Override
    public Timer scheduleWithFixedDelay(final Runnable runnable, long l, long l2) {
        if (null == runnable) {
            throw new IllegalArgumentException("Unexpected null Runnable.");
        }
        TimerListener timerListener = new TimerListener(){

            public final void timerExpired(weblogic.timers.Timer timer) {
                block2: {
                    try {
                        runnable.run();
                    }
                    catch (Exception exception) {
                        if (!WlsCertRevocContext.this.isLoggable(Level.FINE)) break block2;
                        WlsCertRevocContext.this.log(Level.FINE, exception, "Exception occurred running timer task {0}.", runnable.getClass().getName());
                    }
                }
            }
        };
        final weblogic.timers.Timer timer = TimerManagerFactory.getTimerManagerFactory().getDefaultTimerManager().schedule(timerListener, l, l2);
        Timer timer2 = new Timer(){

            public void cancel() {
                if (WlsCertRevocContext.this.isLoggable(Level.FINEST)) {
                    WlsCertRevocContext.this.log(Level.FINEST, "Cancelling timer task {0}.", runnable.getClass().getName());
                }
                boolean bl = timer.cancel();
                if (WlsCertRevocContext.this.isLoggable(Level.FINEST)) {
                    WlsCertRevocContext.this.log(Level.FINEST, "Returned from cancel for timer task {0}, Found/cancelled={1}.", runnable.getClass().getName(), bl);
                }
            }
        };
        return timer2;
    }

    @Override
    public boolean isCheckingEnabled() {
        CertRevocMBean certRevocMBean = this.getCertRevocMBean();
        if (null == certRevocMBean) {
            return DEFAULT_CHECKING_ENABLED;
        }
        return certRevocMBean.isCheckingEnabled();
    }

    @Override
    public boolean isCheckingDisabled(X500Principal x500Principal) {
        CertRevocMBean certRevocMBean = this.getCertRevocMBean();
        if (null == certRevocMBean) {
            return DEFAULT_CHECKING_DISABLED;
        }
        CertRevocCaMBean certRevocCaMBean = this.getCertRevocCaMBean(certRevocMBean, x500Principal);
        if (null == certRevocCaMBean) {
            return DEFAULT_CHECKING_DISABLED;
        }
        return certRevocCaMBean.isCheckingDisabled();
    }

    @Override
    public boolean isFailOnUnknownRevocStatus(X500Principal x500Principal) {
        CertRevocMBean certRevocMBean = this.getCertRevocMBean();
        if (null == certRevocMBean) {
            return DEFAULT_FAIL_ON_UNKNOWN_REVOC_STATUS;
        }
        CertRevocCaMBean certRevocCaMBean = this.getCertRevocCaMBean(certRevocMBean, x500Principal);
        if (null == certRevocCaMBean) {
            return certRevocMBean.isFailOnUnknownRevocStatus();
        }
        return certRevocCaMBean.isFailOnUnknownRevocStatus();
    }

    @Override
    public CertRevocCheckMethodList getMethodOrder(X500Principal x500Principal) {
        CertRevocMBean certRevocMBean = this.getCertRevocMBean();
        if (null == certRevocMBean) {
            return DEFAULT_METHOD_ORDER;
        }
        CertRevocCaMBean certRevocCaMBean = this.getCertRevocCaMBean(certRevocMBean, x500Principal);
        String string = null == certRevocCaMBean ? certRevocMBean.getMethodOrder() : certRevocCaMBean.getMethodOrder();
        try {
            return new CertRevocCheckMethodList(string);
        }
        catch (Exception exception) {
            this.logParsingException("MethodOrder", certRevocCaMBean, string, exception);
            return DEFAULT_METHOD_ORDER;
        }
    }

    @Override
    public URI getOcspResponderUrl(X500Principal x500Principal) {
        CertRevocMBean certRevocMBean = this.getCertRevocMBean();
        if (null == certRevocMBean) {
            return DEFAULT_OCSP_RESPONDER_URL;
        }
        CertRevocCaMBean certRevocCaMBean = this.getCertRevocCaMBean(certRevocMBean, x500Principal);
        if (null == certRevocCaMBean) {
            return DEFAULT_OCSP_RESPONDER_URL;
        }
        String string = certRevocCaMBean.getOcspResponderUrl();
        try {
            return null == string ? null : new URI(string);
        }
        catch (Exception exception) {
            this.logParsingException("OcspResponderUrl", certRevocCaMBean, string, exception);
            return DEFAULT_OCSP_RESPONDER_URL;
        }
    }

    @Override
    public AbstractCertRevocContext.AttributeUsage getOcspResponderUrlUsage(X500Principal x500Principal) {
        CertRevocMBean certRevocMBean = this.getCertRevocMBean();
        if (null == certRevocMBean) {
            return DEFAULT_OCSP_RESPONDER_URL_USAGE;
        }
        CertRevocCaMBean certRevocCaMBean = this.getCertRevocCaMBean(certRevocMBean, x500Principal);
        if (null == certRevocCaMBean) {
            return DEFAULT_OCSP_RESPONDER_URL_USAGE;
        }
        String string = certRevocCaMBean.getOcspResponderUrlUsage();
        try {
            return AbstractCertRevocContext.AttributeUsage.valueOf(string);
        }
        catch (Exception exception) {
            this.logParsingException("OcspResponderUrlUsage", certRevocCaMBean, string, exception);
            return DEFAULT_OCSP_RESPONDER_URL_USAGE;
        }
    }

    @Override
    public X509Certificate getOcspResponderTrustedCert(X500Principal x500Principal) {
        X509Certificate x509Certificate = null;
        ExplicitTrustMethod explicitTrustMethod = this.getOcspResponderExplicitTrustMethod(x500Principal);
        switch (explicitTrustMethod) {
            case USE_SUBJECT: {
                X500Principal x500Principal2 = this.getOcspResponderCertSubjectName(x500Principal);
                if (null != x500Principal2) {
                    x509Certificate = this.getValidTrustedCert(x500Principal2);
                }
                if (null != x509Certificate || !this.isLoggable(Level.FINE)) break;
                this.log(Level.FINE, "No valid OCSP explicitly trusted certificate for CA \"{0}\" with subject \"{1}\" was found.", x500Principal, x500Principal2);
                break;
            }
            case USE_ISSUER_SERIAL_NUMBER: {
                X500Principal x500Principal3 = this.getOcspResponderCertIssuerName(x500Principal);
                BigInteger bigInteger = this.getOcspResponderCertSerialNumber(x500Principal);
                if (null != x500Principal3 && null != bigInteger) {
                    x509Certificate = this.getValidTrustedCert(x500Principal3, bigInteger);
                }
                if (null != x509Certificate || !this.isLoggable(Level.FINE)) break;
                this.log(Level.FINE, "No valid OCSP explicitly trusted certificate for CA \"{0}\" with issuer \"{1}\" serial number \"{2}\" was found.", x500Principal, x500Principal3, bigInteger);
                break;
            }
            case NONE: {
                if (!this.isLoggable(Level.FINEST)) break;
                this.log(Level.FINEST, "No OCSP explicitly trusted certificate for CA \"{0}\" using method \"{1}\".", new Object[]{x500Principal, explicitTrustMethod});
                break;
            }
            default: {
                throw new IllegalStateException("Unknown ExplicitTrustMethod " + (Object)((Object)explicitTrustMethod));
            }
        }
        if (null != x509Certificate && this.isLoggable(Level.FINEST)) {
            this.log(Level.FINEST, "Found valid OCSP explicitly trusted certificate for CA \"{0}\" using method \"{1}\" with subject \"{2}\".", new Object[]{x500Principal, explicitTrustMethod, x509Certificate.getSubjectX500Principal()});
        }
        return x509Certificate;
    }

    ExplicitTrustMethod getOcspResponderExplicitTrustMethod(X500Principal x500Principal) {
        CertRevocMBean certRevocMBean = this.getCertRevocMBean();
        if (null == certRevocMBean) {
            return DEFAULT_OCSP_RESPONDER_EXPLICIT_TRUST_METHOD;
        }
        CertRevocCaMBean certRevocCaMBean = this.getCertRevocCaMBean(certRevocMBean, x500Principal);
        if (null == certRevocCaMBean) {
            return DEFAULT_OCSP_RESPONDER_EXPLICIT_TRUST_METHOD;
        }
        String string = certRevocCaMBean.getOcspResponderExplicitTrustMethod();
        try {
            return ExplicitTrustMethod.valueOf(string);
        }
        catch (Exception exception) {
            this.logParsingException("OcspResponderExplicitTrustMethod", certRevocCaMBean, string, exception);
            return DEFAULT_OCSP_RESPONDER_EXPLICIT_TRUST_METHOD;
        }
    }

    X500Principal getOcspResponderCertSubjectName(X500Principal x500Principal) {
        CertRevocMBean certRevocMBean = this.getCertRevocMBean();
        if (null == certRevocMBean) {
            return DEFAULT_OCSP_RESPONDER_CERT_SUBJECT_NAME;
        }
        CertRevocCaMBean certRevocCaMBean = this.getCertRevocCaMBean(certRevocMBean, x500Principal);
        if (null == certRevocCaMBean) {
            return DEFAULT_OCSP_RESPONDER_CERT_SUBJECT_NAME;
        }
        String string = certRevocCaMBean.getOcspResponderCertSubjectName();
        try {
            return null == string ? null : new X500Principal(string);
        }
        catch (Exception exception) {
            this.logParsingException("OcspResponderCertSubjectName", certRevocCaMBean, string, exception);
            return DEFAULT_OCSP_RESPONDER_CERT_SUBJECT_NAME;
        }
    }

    X500Principal getOcspResponderCertIssuerName(X500Principal x500Principal) {
        CertRevocMBean certRevocMBean = this.getCertRevocMBean();
        if (null == certRevocMBean) {
            return DEFAULT_OCSP_RESPONDER_CERT_ISSUER_NAME;
        }
        CertRevocCaMBean certRevocCaMBean = this.getCertRevocCaMBean(certRevocMBean, x500Principal);
        if (null == certRevocCaMBean) {
            return DEFAULT_OCSP_RESPONDER_CERT_ISSUER_NAME;
        }
        String string = certRevocCaMBean.getOcspResponderCertIssuerName();
        try {
            return null == string ? null : new X500Principal(string);
        }
        catch (Exception exception) {
            this.logParsingException("OcspResponderCertIssuerName", certRevocCaMBean, string, exception);
            return DEFAULT_OCSP_RESPONDER_CERT_ISSUER_NAME;
        }
    }

    BigInteger getOcspResponderCertSerialNumber(X500Principal x500Principal) {
        CertRevocMBean certRevocMBean = this.getCertRevocMBean();
        if (null == certRevocMBean) {
            return DEFAULT_OCSP_RESPONDER_CERT_SERIAL_NUMBER;
        }
        CertRevocCaMBean certRevocCaMBean = this.getCertRevocCaMBean(certRevocMBean, x500Principal);
        if (null == certRevocCaMBean) {
            return DEFAULT_OCSP_RESPONDER_CERT_SERIAL_NUMBER;
        }
        String string = certRevocCaMBean.getOcspResponderCertSerialNumber();
        try {
            return null == string ? null : new BigInteger(string);
        }
        catch (Exception exception) {
            this.logParsingException("OcspResponderCertSerialNumber", certRevocCaMBean, string, exception);
            return DEFAULT_OCSP_RESPONDER_CERT_SERIAL_NUMBER;
        }
    }

    @Override
    public boolean isOcspNonceEnabled(X500Principal x500Principal) {
        CertRevocMBean certRevocMBean = this.getCertRevocMBean();
        if (null == certRevocMBean) {
            return DEFAULT_OCSP_NONCE_ENABLED;
        }
        CertRevocCaMBean certRevocCaMBean = this.getCertRevocCaMBean(certRevocMBean, x500Principal);
        if (null == certRevocCaMBean) {
            return certRevocMBean.isOcspNonceEnabled();
        }
        return certRevocCaMBean.isOcspNonceEnabled();
    }

    @Override
    public PrivateKey getOcspRequestSigningPrivateKey(X500Principal x500Principal) {
        return null;
    }

    @Override
    public X509Certificate getOcspRequestSigningCert(X500Principal x500Principal) {
        return null;
    }

    @Override
    public boolean isOcspResponseCacheEnabled(X500Principal x500Principal) {
        CertRevocMBean certRevocMBean = this.getCertRevocMBean();
        if (null == certRevocMBean) {
            return DEFAULT_OCSP_RESPONSE_CACHE_ENABLED;
        }
        CertRevocCaMBean certRevocCaMBean = this.getCertRevocCaMBean(certRevocMBean, x500Principal);
        if (null == certRevocCaMBean) {
            return certRevocMBean.isOcspResponseCacheEnabled();
        }
        return certRevocCaMBean.isOcspResponseCacheEnabled();
    }

    @Override
    public int getOcspResponseCacheCapacity() {
        CertRevocMBean certRevocMBean = this.getCertRevocMBean();
        if (null == certRevocMBean) {
            return DEFAULT_OCSP_RESPONSE_CACHE_CAPACITY;
        }
        return certRevocMBean.getOcspResponseCacheCapacity();
    }

    @Override
    public int getOcspResponseCacheRefreshPeriodPercent() {
        CertRevocMBean certRevocMBean = this.getCertRevocMBean();
        if (null == certRevocMBean) {
            return DEFAULT_OCSP_RESPONSE_CACHE_REFRESH_PERIOD_PERCENT;
        }
        return certRevocMBean.getOcspResponseCacheRefreshPeriodPercent();
    }

    @Override
    public long getOcspResponseTimeout(X500Principal x500Principal) {
        CertRevocMBean certRevocMBean = this.getCertRevocMBean();
        if (null == certRevocMBean) {
            return DEFAULT_OCSP_RESPONSE_TIMEOUT;
        }
        CertRevocCaMBean certRevocCaMBean = this.getCertRevocCaMBean(certRevocMBean, x500Principal);
        if (null == certRevocCaMBean) {
            return certRevocMBean.getOcspResponseTimeout();
        }
        return certRevocCaMBean.getOcspResponseTimeout();
    }

    @Override
    public int getOcspTimeTolerance(X500Principal x500Principal) {
        CertRevocMBean certRevocMBean = this.getCertRevocMBean();
        if (null == certRevocMBean) {
            return DEFAULT_OCSP_TIME_TOLERANCE;
        }
        CertRevocCaMBean certRevocCaMBean = this.getCertRevocCaMBean(certRevocMBean, x500Principal);
        if (null == certRevocCaMBean) {
            return certRevocMBean.getOcspTimeTolerance();
        }
        return certRevocCaMBean.getOcspTimeTolerance();
    }

    @Override
    public AbstractCertRevocContext.CrlCacheType getCrlCacheType() {
        CertRevocMBean certRevocMBean = this.getCertRevocMBean();
        if (null == certRevocMBean) {
            return DEFAULT_CRL_CACHE_TYPE;
        }
        String string = certRevocMBean.getCrlCacheType();
        try {
            return AbstractCertRevocContext.CrlCacheType.valueOf(string);
        }
        catch (Exception exception) {
            this.logParsingException("CrlCacheType", null, string, exception);
            return DEFAULT_CRL_CACHE_TYPE;
        }
    }

    @Override
    public File getCrlCacheImportDir() {
        File file = this.getServerSecurityBaseDir();
        if (null == file) {
            return DEFAULT_CRL_CACHE_IMPORT_DIR;
        }
        File file2 = WlsCertRevocContext.getCrlCacheImportDirectory(file);
        if (null == file2) {
            return DEFAULT_CRL_CACHE_IMPORT_DIR;
        }
        return file2;
    }

    @Override
    public File getCrlCacheTypeFileDir() {
        File file = this.getServerSecurityBaseDir();
        if (null == file) {
            return DEFAULT_CRL_CACHE_TYPE_FILE_DIR;
        }
        File file2 = WlsCertRevocContext.getCrlCacheStorageDirectory(file);
        if (null == file2) {
            return DEFAULT_CRL_CACHE_TYPE_FILE_DIR;
        }
        return file2;
    }

    @Override
    public String getCrlCacheTypeLdapHostname() {
        CertRevocMBean certRevocMBean = this.getCertRevocMBean();
        if (null == certRevocMBean) {
            return DEFAULT_CRL_CACHE_TYPE_LDAP_HOST_NAME;
        }
        return certRevocMBean.getCrlCacheTypeLdapHostname();
    }

    @Override
    public int getCrlCacheTypeLdapPort() {
        CertRevocMBean certRevocMBean = this.getCertRevocMBean();
        if (null == certRevocMBean) {
            return DEFAULT_CRL_CACHE_TYPE_LDAP_PORT;
        }
        return certRevocMBean.getCrlCacheTypeLdapPort();
    }

    @Override
    public int getCrlCacheTypeLdapSearchTimeout() {
        CertRevocMBean certRevocMBean = this.getCertRevocMBean();
        if (null == certRevocMBean) {
            return DEFAULT_CRL_CACHE_TYPE_LDAP_SEARCH_TIMEOUT;
        }
        return certRevocMBean.getCrlCacheTypeLdapSearchTimeout();
    }

    @Override
    public int getCrlCacheRefreshPeriodPercent() {
        CertRevocMBean certRevocMBean = this.getCertRevocMBean();
        if (null == certRevocMBean) {
            return DEFAULT_CRL_CACHE_REFRESH_PERIOD_PERCENT;
        }
        return certRevocMBean.getCrlCacheRefreshPeriodPercent();
    }

    @Override
    public boolean isCrlDpEnabled(X500Principal x500Principal) {
        CertRevocMBean certRevocMBean = this.getCertRevocMBean();
        if (null == certRevocMBean) {
            return DEFAULT_CRL_DP_ENABLED;
        }
        CertRevocCaMBean certRevocCaMBean = this.getCertRevocCaMBean(certRevocMBean, x500Principal);
        if (null == certRevocCaMBean) {
            return certRevocMBean.isCrlDpEnabled();
        }
        return certRevocCaMBean.isCrlDpEnabled();
    }

    @Override
    public long getCrlDpDownloadTimeout(X500Principal x500Principal) {
        CertRevocMBean certRevocMBean = this.getCertRevocMBean();
        if (null == certRevocMBean) {
            return DEFAULT_CRL_DP_DOWNLOAD_TIMEOUT;
        }
        CertRevocCaMBean certRevocCaMBean = this.getCertRevocCaMBean(certRevocMBean, x500Principal);
        if (null == certRevocCaMBean) {
            return certRevocMBean.getCrlDpDownloadTimeout();
        }
        return certRevocCaMBean.getCrlDpDownloadTimeout();
    }

    @Override
    public boolean isCrlDpBackgroundDownloadEnabled(X500Principal x500Principal) {
        CertRevocMBean certRevocMBean = this.getCertRevocMBean();
        if (null == certRevocMBean) {
            return DEFAULT_CRL_DP_BACKGROUND_DOWNLOAD_ENABLED;
        }
        CertRevocCaMBean certRevocCaMBean = this.getCertRevocCaMBean(certRevocMBean, x500Principal);
        if (null == certRevocCaMBean) {
            return certRevocMBean.isCrlDpBackgroundDownloadEnabled();
        }
        return certRevocCaMBean.isCrlDpBackgroundDownloadEnabled();
    }

    @Override
    public URI getCrlDpUrl(X500Principal x500Principal) {
        CertRevocMBean certRevocMBean = this.getCertRevocMBean();
        if (null == certRevocMBean) {
            return DEFAULT_CRL_DP_URL;
        }
        CertRevocCaMBean certRevocCaMBean = this.getCertRevocCaMBean(certRevocMBean, x500Principal);
        if (null == certRevocCaMBean) {
            return DEFAULT_CRL_DP_URL;
        }
        String string = certRevocCaMBean.getCrlDpUrl();
        try {
            return null == string ? null : new URI(string);
        }
        catch (Exception exception) {
            this.logParsingException("CrlDpUrl", certRevocCaMBean, string, exception);
            return DEFAULT_CRL_DP_URL;
        }
    }

    @Override
    public AbstractCertRevocContext.AttributeUsage getCrlDpUrlUsage(X500Principal x500Principal) {
        CertRevocMBean certRevocMBean = this.getCertRevocMBean();
        if (null == certRevocMBean) {
            return DEFAULT_CRL_DP_URL_USAGE;
        }
        CertRevocCaMBean certRevocCaMBean = this.getCertRevocCaMBean(certRevocMBean, x500Principal);
        if (null == certRevocCaMBean) {
            return DEFAULT_CRL_DP_URL_USAGE;
        }
        String string = certRevocCaMBean.getCrlDpUrlUsage();
        try {
            return AbstractCertRevocContext.AttributeUsage.valueOf(string);
        }
        catch (Exception exception) {
            this.logParsingException("CrlDpUrlUsage", certRevocCaMBean, string, exception);
            return DEFAULT_CRL_DP_URL_USAGE;
        }
    }

    ServerMBean getServerMBean() {
        ServerMBean serverMBean = null;
        try {
            if (Kernel.isServer()) {
                RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
                if (null == runtimeAccess) {
                    this.logUnexpectedNullMBean("RuntimeAccess");
                } else {
                    ServerMBean serverMBean2 = runtimeAccess.getServer();
                    if (null == serverMBean2) {
                        this.logUnexpectedNullMBean("ServerMBean");
                    }
                }
            } else if (this.isLoggable(Level.FINE)) {
                this.log(Level.FINE, "Certificate revocation checking is currently unavailable outside the server.", new Object[0]);
            }
        }
        catch (RuntimeException runtimeException) {
            if (this.isLoggable(Level.FINE)) {
                this.log(Level.FINE, runtimeException, "Failure getting ServerMBean for kernelId={0}.", kernelId);
            }
            throw runtimeException;
        }
        return serverMBean;
    }

    private String getServerName() {
        String string = null;
        try {
            if (Kernel.isServer()) {
                PropertyService propertyService = ManagementService.getPropertyService(kernelId);
                if (null == propertyService) {
                    if (this.isLoggable(Level.FINE)) {
                        this.log(Level.FINE, "Unexpected null PropertyService for kernelId={0}.", kernelId);
                    }
                } else {
                    string = propertyService.getServerName();
                }
            } else if (this.isLoggable(Level.FINE)) {
                this.log(Level.FINE, "Certificate revocation checking is currently unavailable outside the server.", new Object[0]);
            }
        }
        catch (RuntimeException runtimeException) {
            if (this.isLoggable(Level.FINE)) {
                this.log(Level.FINE, runtimeException, "Failure getting server name for kernelId={0}.", kernelId);
            }
            throw runtimeException;
        }
        return string;
    }

    CertRevocMBean getCertRevocMBean() {
        CertRevocMBean certRevocMBean = null;
        try {
            if (Kernel.isServer()) {
                RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
                if (null == runtimeAccess) {
                    this.logUnexpectedNullMBean("RuntimeAccess");
                } else {
                    DomainMBean domainMBean = runtimeAccess.getDomain();
                    if (null == domainMBean) {
                        this.logUnexpectedNullMBean("DomainMBean");
                    } else {
                        SecurityConfigurationMBean securityConfigurationMBean = domainMBean.getSecurityConfiguration();
                        if (null == securityConfigurationMBean) {
                            this.logUnexpectedNullMBean("SecurityConfigurationMBean");
                        } else {
                            certRevocMBean = securityConfigurationMBean.getCertRevoc();
                            if (null == certRevocMBean) {
                                this.logUnexpectedNullMBean("CertRevocMBean");
                            }
                        }
                    }
                }
            } else if (this.isLoggable(Level.FINE)) {
                this.log(Level.FINE, "Certificate revocation checking is currently unavailable outside the server.", new Object[0]);
            }
        }
        catch (RuntimeException runtimeException) {
            if (this.isLoggable(Level.FINE)) {
                this.log(Level.FINE, runtimeException, "Failure getting CertRevocMBean for kernelId={0}.", kernelId);
            }
            throw runtimeException;
        }
        return certRevocMBean;
    }

    CertRevocCaMBean getCertRevocCaMBean(CertRevocMBean certRevocMBean, X500Principal x500Principal) {
        if (null == certRevocMBean) {
            throw new IllegalArgumentException("Expected non-null CertRevocMBean.");
        }
        if (null == x500Principal) {
            if (this.isLoggable(Level.FINE)) {
                this.log(Level.FINE, "Non-null caDn expected.", new Object[0]);
            }
            return null;
        }
        CertRevocCaMBean[] certRevocCaMBeanArray = certRevocMBean.getCertRevocCas();
        if (null == certRevocCaMBeanArray || 0 == certRevocCaMBeanArray.length) {
            return null;
        }
        for (CertRevocCaMBean certRevocCaMBean : certRevocCaMBeanArray) {
            X500Principal x500Principal2;
            String string;
            if (null == certRevocCaMBean || null == (string = certRevocCaMBean.getDistinguishedName()) || 0 == string.length()) continue;
            try {
                x500Principal2 = new X500Principal(string);
            }
            catch (Exception exception) {
                continue;
            }
            if (!x500Principal.equals(x500Principal2)) continue;
            return certRevocCaMBean;
        }
        return null;
    }

    private void logParsingException(String string, CertRevocCaMBean certRevocCaMBean, String string2, Exception exception) {
        if (this.isLoggable(Level.FINE)) {
            String string3 = null == certRevocCaMBean ? "CertRevocMBean" : "CertRevocCaMBean";
            this.log(Level.FINE, exception, "Invalid {0}.{1} value {2}", string3, string, string2);
        }
    }

    private void logUnexpectedNullMBean(String string) {
        if (this.isLoggable(Level.FINE)) {
            this.log(Level.FINE, "Unexpected null {0} for kernelId={1}.", string, kernelId);
        }
    }

    private File getServerSecurityBaseDir() {
        String string = this.getServerName();
        if (null == string || string.length() == 0) {
            if (this.isLoggable(Level.FINE)) {
                this.log(Level.FINE, "Server name is null or empty.", new Object[0]);
            }
            return null;
        }
        File file = new File(DomainDir.getSecurityDirForServer((String)string));
        return file;
    }

    private static String nameFrom(X500Principal x500Principal) {
        String string = x500Principal != null ? x500Principal.getName() : null;
        return string;
    }

    private static String stringFrom(CertRevocStatus certRevocStatus) {
        String string = certRevocStatus != null ? certRevocStatus.toString() : null;
        return string;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ExplicitTrustMethod {
        NONE,
        USE_SUBJECT,
        USE_ISSUER_SERIAL_NUMBER;

    }
}

