/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.principal;

import java.security.Principal;
import java.security.acl.Group;
import weblogic.security.acl.BasicRealm;
import weblogic.security.acl.Security;
import weblogic.security.acl.User;
import weblogic.security.principal.RealmAdapterUserInterface;
import weblogic.security.principal.WLSAbstractPrincipal;
import weblogic.security.spi.InvalidPrincipalException;
import weblogic.security.spi.WLSUser;

public final class RealmAdapterUser
extends WLSAbstractPrincipal
implements WLSUser,
RealmAdapterUserInterface {
    static final long serialVersionUID = 8241522729442054197L;

    public RealmAdapterUser(String string) {
        this.setName(string);
    }

    public RealmAdapterUser(String string, byte[] byArray, byte[] byArray2) {
        this.setName(string);
        this.setSalt(byArray);
        this.setSignature(byArray2);
    }

    public boolean isUserInGroup(String string) {
        BasicRealm basicRealm = Security.getRealm();
        if (basicRealm == null) {
            throw new SecurityException("Realm Adapter Realm Not Configured");
        }
        User user = basicRealm.getUser(this.getName());
        if (user == null) {
            throw new InvalidPrincipalException("Realm Adapter User " + this.getName() + " invalid in Realm Adapter realm " + basicRealm.getName());
        }
        Group group = basicRealm.getGroup(string);
        if (group == null) {
            return false;
        }
        return group.isMember((Principal)user);
    }
}

