/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.provider;

import com.bea.common.logger.spi.LoggerSpi;
import java.security.AccessController;
import java.security.Principal;
import weblogic.management.provider.ManagementService;
import weblogic.management.security.RealmMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.shared.LoggerWrapper;
import weblogic.security.spi.PrincipalValidator;

public class PrincipalValidatorImpl
implements PrincipalValidator {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static LoggerSpi log = new LoggerAdapter(LoggerWrapper.getInstance("SecurityAtn"));
    private com.bea.common.security.provider.PrincipalValidatorImpl delegate = null;

    public PrincipalValidatorImpl() {
        byte[] byArray = ManagementService.getRuntimeAccess(kernelId).getDomain().getSecurityConfiguration().getCredential().getBytes();
        RealmMBean realmMBean = ManagementService.getRuntimeAccess(kernelId).getDomain().getSecurityConfiguration().getDefaultRealm();
        boolean bl = realmMBean.isEnableWebLogicPrincipalValidatorCache();
        int n = 500;
        if (bl && (n = realmMBean.getMaxWebLogicPrincipalsInCache().intValue()) <= 0) {
            n = 500;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Initializing principal validator delegate");
        }
        this.delegate = new com.bea.common.security.provider.PrincipalValidatorImpl(log, byArray, bl, n);
    }

    public boolean validate(Principal principal) throws SecurityException {
        return this.delegate.validate(principal);
    }

    public boolean sign(Principal principal) {
        return this.delegate.sign(principal);
    }

    public Class getPrincipalBaseClass() {
        return this.delegate.getPrincipalBaseClass();
    }

    private static class LoggerAdapter
    implements LoggerSpi {
        private LoggerWrapper logger;

        LoggerAdapter(LoggerWrapper loggerWrapper) {
            this.logger = loggerWrapper;
        }

        public boolean isDebugEnabled() {
            return this.logger.isDebugEnabled();
        }

        public void debug(Object object) {
            this.logger.debug(object);
        }

        public void debug(Object object, Throwable throwable) {
            this.logger.debug(object, throwable);
        }

        public void info(Object object) {
            this.logger.info(object);
        }

        public void info(Object object, Throwable throwable) {
            this.logger.info(object, throwable);
        }

        public void warn(Object object) {
            this.logger.warn(object);
        }

        public void warn(Object object, Throwable throwable) {
            this.logger.warn(object, throwable);
        }

        public void error(Object object) {
            this.logger.error(object);
        }

        public void error(Object object, Throwable throwable) {
            this.logger.error(object, throwable);
        }

        public void severe(Object object) {
            this.logger.severe(object);
        }

        public void severe(Object object, Throwable throwable) {
            this.logger.severe(object, throwable);
        }
    }
}

