/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.services;

import java.io.Serializable;
import java.security.AccessController;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import weblogic.security.SecurityLogger;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.AdminResource;
import weblogic.security.service.AppContextHandler;
import weblogic.security.service.AuthorizationManager;
import weblogic.security.service.ChallengeContext;
import weblogic.security.service.ContextHandler;
import weblogic.security.service.InvalidParameterException;
import weblogic.security.service.PrincipalAuthenticator;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.security.services.AppChallengeContext;
import weblogic.security.services.AppContext;
import weblogic.security.shared.LoggerWrapper;
import weblogic.security.spi.IdentityAssertionException;
import weblogic.security.spi.Resource;

public final class Authentication {
    private static LoggerWrapper log = LoggerWrapper.getInstance("SecurityAtn");
    private static AuthenticatedSubject kernelID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public static Subject login(CallbackHandler callbackHandler) throws LoginException {
        return Authentication.login(callbackHandler, null);
    }

    public static Subject login(CallbackHandler callbackHandler, AppContext appContext) throws LoginException {
        PrincipalAuthenticator principalAuthenticator = SecurityServiceManager.getPrincipalAuthenticator((AuthenticatedSubject)kernelID, (String)"weblogicDEFAULT");
        return Authentication.doLogin(callbackHandler, appContext, principalAuthenticator);
    }

    public static Subject login(String string, CallbackHandler callbackHandler) throws LoginException {
        return Authentication.login(string, callbackHandler, null);
    }

    public static Subject login(String string, CallbackHandler callbackHandler, AppContext appContext) throws LoginException {
        PrincipalAuthenticator principalAuthenticator = SecurityServiceManager.getPrincipalAuthenticator((AuthenticatedSubject)kernelID, (String)string);
        return Authentication.doLogin(callbackHandler, appContext, principalAuthenticator);
    }

    private static Subject doLogin(CallbackHandler callbackHandler, AppContext appContext, PrincipalAuthenticator principalAuthenticator) throws LoginException {
        if (principalAuthenticator == null) {
            throw new InvalidParameterException(SecurityLogger.getSecurityServiceUnavailable());
        }
        AppContextHandler appContextHandler = AppContextHandler.getInstance((AppContext)appContext);
        AuthenticatedSubject authenticatedSubject = principalAuthenticator.authenticate(callbackHandler, (ContextHandler)appContextHandler);
        return authenticatedSubject.getSubject();
    }

    public static Subject assertIdentity(String string, Object object) throws LoginException {
        return Authentication.assertIdentity(string, object, null);
    }

    public static Subject assertIdentity(String string, Object object, AppContext appContext) throws LoginException {
        return Authentication.doAssertIdentity(string, object, appContext, "weblogicDEFAULT");
    }

    public static Subject assertIdentity(String string, String string2, Object object) throws LoginException {
        return Authentication.assertIdentity(string, string2, object, null);
    }

    public static Subject assertIdentity(String string, String string2, Object object, AppContext appContext) throws LoginException {
        return Authentication.doAssertIdentity(string2, object, appContext, string);
    }

    private static Subject doAssertIdentity(String string, Object object, AppContext appContext, String string2) throws LoginException {
        PrincipalAuthenticator principalAuthenticator = SecurityServiceManager.getPrincipalAuthenticator((AuthenticatedSubject)kernelID, (String)string2);
        if (principalAuthenticator == null) {
            throw new InvalidParameterException("Security Service Unavailable");
        }
        AuthorizationManager authorizationManager = SecurityServiceManager.getAuthorizationManager((AuthenticatedSubject)kernelID, (String)string2);
        if (authorizationManager != null) {
            AuthenticatedSubject authenticatedSubject = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)kernelID);
            AdminResource adminResource = new AdminResource("IdentityAssertion", string2, "assertIdentity");
            if (log.isDebugEnabled()) {
                log.debug(" isAccessAllowed:  checking Permission for: '" + adminResource + "', currentSubject: '" + SubjectUtils.displaySubject((AuthenticatedSubject)authenticatedSubject) + "'");
            }
            if (!authorizationManager.isAccessAllowed(authenticatedSubject, (Resource)adminResource, null)) {
                if (log.isDebugEnabled()) {
                    log.debug(" isAccessAllowed:  currentSubject: " + authenticatedSubject + " does not have permission to assert identity of type " + string + " in realm " + string2);
                }
                throw new SecurityException(" isAccessAllowed:  currentSubject: " + authenticatedSubject + " does not have permission to assert identity of type " + string + " in realm " + string2);
            }
            AppContextHandler appContextHandler = AppContextHandler.getInstance((AppContext)appContext);
            AuthenticatedSubject authenticatedSubject2 = principalAuthenticator.assertIdentity(string, object, (ContextHandler)appContextHandler);
            return authenticatedSubject2.getSubject();
        }
        throw new SecurityException("Security Service Unavailable");
    }

    public Object getChallengeToken(String string, AppContext appContext) throws LoginException {
        PrincipalAuthenticator principalAuthenticator = SecurityServiceManager.getPrincipalAuthenticator((AuthenticatedSubject)kernelID, (String)"weblogicDEFAULT");
        if (principalAuthenticator == null) {
            throw new InvalidParameterException("Security Service Unavailable");
        }
        Object object = null;
        AppContextHandler appContextHandler = AppContextHandler.getInstance((AppContext)appContext);
        try {
            object = principalAuthenticator.getChallengeToken(string, (ContextHandler)appContextHandler);
        }
        catch (IdentityAssertionException identityAssertionException) {
            new LoginException(identityAssertionException.getMessage());
        }
        return object;
    }

    public void continueChallengeIdentity(AppChallengeContext appChallengeContext, String string, Object object, AppContext appContext) throws LoginException {
        PrincipalAuthenticator principalAuthenticator = SecurityServiceManager.getPrincipalAuthenticator((AuthenticatedSubject)kernelID, (String)"weblogicDEFAULT");
        if (principalAuthenticator == null) {
            throw new InvalidParameterException("Security Service Unavailable");
        }
        AppContextHandler appContextHandler = AppContextHandler.getInstance((AppContext)appContext);
        ChallengeContext challengeContext = ((AppChallengeContextImpl)appChallengeContext).getChallengeContext();
        principalAuthenticator.continueChallengeIdentity(challengeContext, string, object, (ContextHandler)appContextHandler);
    }

    public AppChallengeContext assertChallengeIdentity(String string, Object object, AppContext appContext) throws LoginException {
        String string2 = "weblogicDEFAULT";
        PrincipalAuthenticator principalAuthenticator = SecurityServiceManager.getPrincipalAuthenticator((AuthenticatedSubject)kernelID, (String)string2);
        if (principalAuthenticator == null) {
            throw new InvalidParameterException("Security Service Unavailable");
        }
        AuthorizationManager authorizationManager = SecurityServiceManager.getAuthorizationManager((AuthenticatedSubject)kernelID, (String)string2);
        if (authorizationManager != null) {
            AuthenticatedSubject authenticatedSubject = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)kernelID);
            AdminResource adminResource = new AdminResource("IdentityAssertion", string2, "assertIdentity");
            if (log.isDebugEnabled()) {
                log.debug(" isAccessAllowed:  checking Permission for: '" + adminResource + "', currentSubject: '" + SubjectUtils.displaySubject((AuthenticatedSubject)authenticatedSubject) + "'");
            }
            if (!authorizationManager.isAccessAllowed(authenticatedSubject, (Resource)adminResource, null)) {
                if (log.isDebugEnabled()) {
                    log.debug(" isAccessAllowed:  currentSubject: " + authenticatedSubject + " does not have permission to assert identity of type " + string + " in realm " + string2);
                }
                throw new SecurityException(" isAccessAllowed:  currentSubject: " + authenticatedSubject + " does not have permission to assert identity of type " + string + " in realm " + string2);
            }
            AppContextHandler appContextHandler = AppContextHandler.getInstance((AppContext)appContext);
            ChallengeContext challengeContext = principalAuthenticator.assertChallengeIdentity(string, object, (ContextHandler)appContextHandler);
            return new AppChallengeContextImpl(challengeContext, log);
        }
        throw new SecurityException("Security Service Unavailable");
    }

    private final class AppChallengeContextImpl
    implements AppChallengeContext,
    Serializable {
        private static final long serialVersionUID = 5847810460507567453L;
        private ChallengeContext challengeContext;
        private LoggerWrapper log = null;

        public AppChallengeContextImpl(ChallengeContext challengeContext, LoggerWrapper loggerWrapper) {
            this.challengeContext = challengeContext;
            this.log = loggerWrapper;
        }

        public boolean hasChallengeIdentityCompleted() {
            return this.challengeContext.hasChallengeIdentityCompleted();
        }

        public Subject getAuthenticatedSubject() {
            if (!this.hasChallengeIdentityCompleted()) {
                throw new IllegalStateException(SecurityLogger.getChallengeNotCompleted());
            }
            AuthenticatedSubject authenticatedSubject = this.challengeContext.getAuthenticatedSubject();
            if (authenticatedSubject != null) {
                return authenticatedSubject.getSubject();
            }
            return null;
        }

        public Object getChallengeToken() {
            if (this.hasChallengeIdentityCompleted()) {
                throw new IllegalStateException(SecurityLogger.getChallengeHasCompleted());
            }
            return this.challengeContext.getChallengeToken();
        }

        public ChallengeContext getChallengeContext() {
            return this.challengeContext;
        }
    }
}

