/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.shared;

import java.util.HashMap;
import weblogic.security.shared.LoggerAdapter;
import weblogic.security.shared.RuntimeEnvironment;
import weblogic.security.shared.RuntimeUtilities;

public final class LoggerWrapper {
    Object logger = null;
    private static RuntimeUtilities runtimeUtilities = null;
    private static HashMap wrappers = new HashMap();
    private static LoggerWrapper nullWrapper = null;
    private static LoggerAdapter adapter = null;

    private LoggerWrapper() {
    }

    private LoggerWrapper(Object object) {
        this.logger = object;
    }

    public static synchronized LoggerWrapper getInstance(Class clazz) throws IllegalStateException {
        if (clazz != null) {
            return LoggerWrapper.getInstance(clazz.getName());
        }
        return LoggerWrapper.getInstance((String)null);
    }

    public static synchronized LoggerWrapper getInstance(String string) throws IllegalStateException {
        if (adapter == null) {
            runtimeUtilities = RuntimeEnvironment.getRuntimeUtilities();
            adapter = runtimeUtilities.getLoggerAdapter();
        }
        if (string != null) {
            LoggerWrapper loggerWrapper = (LoggerWrapper)wrappers.get(string);
            if (loggerWrapper != null) {
                return loggerWrapper;
            }
            loggerWrapper = new LoggerWrapper(adapter.getLogger(string));
            wrappers.put(string, loggerWrapper);
            return loggerWrapper;
        }
        if (nullWrapper == null) {
            nullWrapper = new LoggerWrapper(adapter.getLogger(null));
        }
        return nullWrapper;
    }

    public boolean isDebugEnabled() {
        if (adapter != null) {
            return adapter.isDebugEnabled(this.logger);
        }
        return false;
    }

    public void debug(Object object) {
        if (adapter != null) {
            adapter.debug(this.logger, object);
        }
    }

    public void debug(Object object, Throwable throwable) {
        if (adapter != null) {
            adapter.debug(this.logger, object, throwable);
        }
    }

    public void info(Object object) {
        if (adapter != null) {
            adapter.info(this.logger, object);
        }
    }

    public void info(Object object, Throwable throwable) {
        if (adapter != null) {
            adapter.info(this.logger, object, throwable);
        }
    }

    public void warn(Object object) {
        if (adapter != null) {
            adapter.warn(this.logger, object);
        }
    }

    public void warn(Object object, Throwable throwable) {
        if (adapter != null) {
            adapter.warn(this.logger, object, throwable);
        }
    }

    public void error(Object object) {
        if (adapter != null) {
            adapter.error(this.logger, object);
        }
    }

    public void error(Object object, Throwable throwable) {
        if (adapter != null) {
            adapter.error(this.logger, object, throwable);
        }
    }

    public void severe(Object object) {
        if (adapter != null) {
            adapter.severe(this.logger, object);
        }
    }

    public void severe(Object object, Throwable throwable) {
        if (adapter != null) {
            adapter.severe(this.logger, object, throwable);
        }
    }
}

