/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.unixrealm;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import weblogic.logging.LogOutputStream;
import weblogic.security.unixrealm.SubprocessException;
import weblogic.security.unixrealm.UnixRealm;
import weblogic.security.utils.Factory;

final class UnixDelegate {
    private Runtime runtime = Runtime.getRuntime();
    private String program;
    private Process proc;
    private BufferedReader in;
    private PrintWriter out;
    private int chatCount;
    private int maxChats;
    private UnixRealm owner;
    private LogOutputStream log;

    UnixDelegate(String string, int n, UnixRealm unixRealm) {
        this.program = string;
        this.maxChats = n;
        this.owner = unixRealm;
        this.log = unixRealm.log;
    }

    Chat chat(String[] stringArray) throws IOException {
        if (this.proc == null || this.chatCount > this.maxChats) {
            if (this.proc != null) {
                if (this.log != null) {
                    this.log.debug("killing old subprocess");
                }
                this.close();
            }
            if (this.log != null) {
                this.log.debug("starting new subprocess");
            }
            this.proc = this.runtime.exec(this.program);
            this.in = new BufferedReader(new InputStreamReader(this.proc.getInputStream()));
            this.out = new PrintWriter(this.proc.getOutputStream());
        }
        if (this.log != null) {
            StringBuffer stringBuffer = new StringBuffer();
            if (stringArray.length > 0) {
                for (int i = 0; i < stringArray.length - 1; ++i) {
                    stringBuffer.append("\"" + stringArray[i] + "\", ");
                }
                stringBuffer.append("\"" + stringArray[stringArray.length - 1] + "\"");
            }
            this.log.debug("chat: sending {" + stringBuffer + "}");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            this.out.println(stringArray[i]);
        }
        if (this.out.checkError()) {
            throw new SubprocessException("subprocess failed");
        }
        ++this.chatCount;
        return new Chat();
    }

    void close() {
        this.out.close();
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.proc.destroy();
        this.out = null;
        this.in = null;
        this.proc = null;
        this.chatCount = 0;
    }

    protected void finalize() {
        this.close();
    }

    static class DFactory
    implements Factory {
        String program;
        int maxChats;
        UnixRealm owner;

        DFactory(String string, int n, UnixRealm unixRealm) {
            this.program = string;
            this.maxChats = n;
            this.owner = unixRealm;
        }

        public Object newInstance() throws InvocationTargetException {
            if (this.owner.log != null) {
                this.owner.log.debug("new instance");
            }
            return new UnixDelegate(this.program, this.maxChats, this.owner);
        }

        public void destroyInstance(Object object) {
            if (this.owner.log != null) {
                this.owner.log.debug("destroy instance");
            }
            ((UnixDelegate)object).close();
        }
    }

    class Chat {
        Chat() {
        }

        String read() throws IOException {
            String string = UnixDelegate.this.in.readLine();
            if (UnixDelegate.this.log != null) {
                UnixDelegate.this.log.debug("read \"" + string + "\"");
            }
            return string;
        }

        boolean expect(String string) throws IOException {
            String string2 = this.read();
            boolean bl = string2.equals(string);
            if (UnixDelegate.this.log != null) {
                UnixDelegate.this.log.debug("expected \"" + string + "\": " + (bl ? "matched" : "no match"));
            }
            return bl;
        }

        void require(String string) throws IOException {
            String string2 = this.read();
            if (UnixDelegate.this.log != null) {
                UnixDelegate.this.log.debug("requiring \"" + string + "\"");
            }
            if (!string2.equals(string)) {
                throw new SubprocessException("request failed: " + string2);
            }
        }
    }
}

