/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.unixrealm;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import weblogic.logging.LogOutputStream;
import weblogic.management.configuration.UnixRealmMBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.AbstractListableRealm;
import weblogic.security.acl.ClosableEnumeration;
import weblogic.security.acl.DebuggableRealm;
import weblogic.security.acl.User;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.unixrealm.SubprocessException;
import weblogic.security.unixrealm.UnixDelegate;
import weblogic.security.unixrealm.UnixGroup;
import weblogic.security.unixrealm.UnixUser;
import weblogic.security.utils.Factory;
import weblogic.security.utils.Pool;

public class UnixRealm
extends AbstractListableRealm
implements DebuggableRealm {
    private UnixRealm thisRealm = this;
    private static final int MAX_REQUESTS = 500;
    private static final int POOL_SIZE = 6;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private Pool delegatePool;
    LogOutputStream log;

    public UnixRealm() {
        super("Unix Realm");
        UnixRealmMBean unixRealmMBean = (UnixRealmMBean)ManagementService.getRuntimeAccess(kernelId).getDomain().getSecurity().getRealm().getCachingRealm().getBasicRealm();
        this.delegatePool = new Pool((Factory)new UnixDelegate.DFactory(unixRealmMBean.getAuthProgram(), 500, this), 6);
        this.setDebug(ManagementService.getRuntimeAccess(kernelId).getServer().getServerDebug().getDebugSecurityRealm());
    }

    private UnixDelegate getDelegate() {
        try {
            return (UnixDelegate)this.delegatePool.getInstance();
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new SubprocessException("could not get subprocess", invocationTargetException);
        }
    }

    public User getUser(String string) {
        if (this.log != null) {
            this.log.debug("getUser(\"" + string + "\")");
        }
        UnixDelegate unixDelegate = this.getDelegate();
        try {
            UnixDelegate.Chat chat = unixDelegate.chat(new String[]{"user_exists", string});
            if (chat.expect("0")) {
                UnixUser unixUser = new UnixUser(string, this);
                return unixUser;
            }
            User user = null;
            return user;
        }
        catch (IOException iOException) {
            unixDelegate = null;
            throw new SubprocessException("auth process failed", iOException);
        }
        finally {
            if (unixDelegate != null) {
                this.delegatePool.returnInstance((Object)unixDelegate);
            }
        }
    }

    protected User authUserPassword(String string, String string2) {
        if (this.log != null) {
            this.log.debug("authUserPassword(\"" + string + "\")");
        }
        UnixUser unixUser = null;
        UnixDelegate unixDelegate = this.getDelegate();
        try {
            UnixDelegate.Chat chat = unixDelegate.chat(new String[]{"user_auth", string, string2});
            chat.require("0");
            if (chat.expect("0")) {
                unixUser = new UnixUser(string, this);
            }
        }
        catch (IOException iOException) {
            unixDelegate = null;
            throw new SubprocessException("auth process failed", iOException);
        }
        finally {
            if (unixDelegate != null) {
                this.delegatePool.returnInstance((Object)unixDelegate);
            }
        }
        return unixUser;
    }

    protected Hashtable getGroupMembersInternal(String string) {
        if (this.log != null) {
            this.log.debug("getGroup(\"" + string + "\")");
        }
        UnixDelegate unixDelegate = this.getDelegate();
        try {
            UnixDelegate.Chat chat = unixDelegate.chat(new String[]{"group_members", string});
            if (chat.expect("0")) {
                Hashtable hashtable = this.readGroupMembers(chat);
                return hashtable;
            }
            Hashtable hashtable = null;
            return hashtable;
        }
        catch (IOException iOException) {
            unixDelegate = null;
            throw new SubprocessException("auth process failed", iOException);
        }
        finally {
            if (unixDelegate != null) {
                this.delegatePool.returnInstance((Object)unixDelegate);
            }
        }
    }

    public Group getGroup(String string) {
        Hashtable hashtable = this.getGroupMembersInternal(string);
        return hashtable != null ? new UnixGroup(string, this, hashtable) : null;
    }

    private Hashtable readGroupMembers(UnixDelegate.Chat chat) throws IOException {
        String string;
        Hashtable<String, UnixUser> hashtable = new Hashtable<String, UnixUser>();
        while ((string = chat.read()).length() != 0) {
            hashtable.put(string, new UnixUser(string, this));
        }
        return hashtable;
    }

    public Enumeration getUsers() {
        if (this.log != null) {
            this.log.debug("getUsers()");
        }
        UnixDelegate unixDelegate = this.getDelegate();
        try {
            UnixDelegate.Chat chat = unixDelegate.chat(new String[]{"user_list"});
            chat.require("0");
            ChatEnumeration chatEnumeration = new ChatEnumeration(unixDelegate, chat, new ChatNextHandler(){

                public Object handle(String string, UnixDelegate.Chat chat) {
                    return new UnixUser(string, UnixRealm.this.thisRealm);
                }

                public void skip(String string, UnixDelegate.Chat chat) throws IOException {
                }
            });
            unixDelegate = null;
            ChatEnumeration chatEnumeration2 = chatEnumeration;
            return chatEnumeration2;
        }
        catch (IOException iOException) {
            unixDelegate = null;
            throw new SubprocessException("auth process failed", iOException);
        }
        finally {
            if (unixDelegate != null) {
                this.delegatePool.returnInstance((Object)unixDelegate);
            }
        }
    }

    public Enumeration getGroups() {
        if (this.log != null) {
            this.log.debug("getGroups()");
        }
        UnixDelegate unixDelegate = this.getDelegate();
        try {
            UnixDelegate.Chat chat = unixDelegate.chat(new String[]{"group_list"});
            if (chat.expect("0")) {
                ChatEnumeration chatEnumeration = new ChatEnumeration(unixDelegate, chat, new ChatNextHandler(){

                    public Object handle(String string, UnixDelegate.Chat chat) throws IOException {
                        Hashtable hashtable = UnixRealm.this.thisRealm.readGroupMembers(chat);
                        return new UnixGroup(string, UnixRealm.this.thisRealm, hashtable);
                    }

                    public void skip(String string, UnixDelegate.Chat chat) throws IOException {
                        String string2 = null;
                        while ((string2 = chat.read()).length() > 0) {
                        }
                    }
                });
                unixDelegate = null;
                ChatEnumeration chatEnumeration2 = chatEnumeration;
                return chatEnumeration2;
            }
            Enumeration enumeration = null;
            return enumeration;
        }
        catch (IOException iOException) {
            unixDelegate = null;
            throw new SubprocessException("auth process failed", iOException);
        }
        finally {
            if (unixDelegate != null) {
                this.delegatePool.returnInstance((Object)unixDelegate);
            }
        }
    }

    public void setDebug(boolean bl) {
        if (bl && this.log == null) {
            this.log = new LogOutputStream("UnixRealm");
        }
        if (!bl) {
            this.log = null;
        }
    }

    public LogOutputStream getDebugLog() {
        return this.log;
    }

    private class ChatEnumeration
    implements ClosableEnumeration {
        boolean closed = false;
        String current;
        UnixDelegate delegate;
        UnixDelegate.Chat chat;
        ChatNextHandler handler;

        ChatEnumeration(UnixDelegate unixDelegate, UnixDelegate.Chat chat, ChatNextHandler chatNextHandler) {
            this.delegate = unixDelegate;
            this.chat = chat;
            this.handler = chatNextHandler;
            this.increment();
        }

        private void handleIOException(IOException iOException) {
            this.closed = true;
            this.delegate = null;
            throw new SubprocessException("auth process failed", iOException);
        }

        private void increment() {
            try {
                this.current = this.chat.read();
                if (this.current.length() == 0) {
                    this.close();
                }
            }
            catch (IOException iOException) {
                this.handleIOException(iOException);
            }
        }

        public boolean hasMoreElements() {
            return !this.closed;
        }

        public Object nextElement() {
            if (this.closed) {
                throw new NoSuchElementException("ChatEnumeration.nextElement");
            }
            try {
                Object object = this.handler.handle(this.current, this.chat);
                this.increment();
                return object;
            }
            catch (IOException iOException) {
                this.handleIOException(iOException);
                return null;
            }
        }

        public void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            try {
                while (this.delegate != null && this.current.length() > 0) {
                    this.handler.skip(this.current, this.chat);
                    this.current = this.chat.read();
                }
            }
            catch (IOException iOException) {
                this.delegate = null;
            }
            if (this.delegate != null) {
                UnixRealm.this.delegatePool.returnInstance((Object)this.delegate);
            }
        }
    }

    private static interface ChatNextHandler {
        public Object handle(String var1, UnixDelegate.Chat var2) throws IOException;

        public void skip(String var1, UnixDelegate.Chat var2) throws IOException;
    }
}

