/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.utils;

import java.security.AccessController;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.net.ssl.SSLSocket;
import weblogic.management.configuration.SSLMBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.SecurityLogger;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.pk.CertPathValidatorParameters;
import weblogic.security.service.ContextElement;
import weblogic.security.service.ContextHandler;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.security.shared.LoggerWrapper;
import weblogic.security.utils.TrustManagerEnvironment;

public final class CertPathTrustManagerUtils {
    public static final int CERT_PATH_VAL_IF_CONFIGURED = 0;
    public static final int CERT_PATH_VAL_ALWAYS = 1;
    public static final int CERT_PATH_VAL_NEVER = 2;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static boolean running = false;
    private static LoggerWrapper log = LoggerWrapper.getInstance("SecurityCertPath");
    private static String CLIENT_CERTS_ENFORCED = "weblogic.security.ClientCertificatesEnforced";

    public static synchronized void start() {
        running = true;
    }

    public static synchronized void stop() {
        running = false;
    }

    public static synchronized void halt() {
        running = false;
    }

    private static boolean isDebug() {
        return log.isDebugEnabled();
    }

    private static void debug(String string, String string2) {
        String string3 = "CertPathTrustManagerUtils." + string + ": " + string2;
        if (log.isDebugEnabled()) {
            log.debug(string3);
        }
        System.out.println(string3);
    }

    public static boolean certificateCallback(int n, X509Certificate[] x509CertificateArray, int n2) {
        SSLMBean sSLMBean;
        int n3;
        String string = "certificateCallback";
        if (CertPathTrustManagerUtils.isDebug()) {
            CertPathTrustManagerUtils.debug(string, "certPathValStype = " + n);
            CertPathTrustManagerUtils.debug(string, "validateErr = " + n2);
            for (n3 = 0; x509CertificateArray != null && n3 < x509CertificateArray.length; ++n3) {
                CertPathTrustManagerUtils.debug(string, "chain[" + n3 + "] = " + x509CertificateArray[n3]);
            }
        }
        n3 = 0;
        n3 = Boolean.getBoolean("weblogic.security.dontValidateIfSSLErrors");
        if (n3 != 0 && n2 != 0) {
            if (CertPathTrustManagerUtils.isDebug()) {
                CertPathTrustManagerUtils.debug(string, "returning false because of built-in SSL validation errors");
            }
            return false;
        }
        if (0 == n2 && (x509CertificateArray == null || x509CertificateArray.length < 1)) {
            if (CertPathTrustManagerUtils.isDebug()) {
                CertPathTrustManagerUtils.debug(string, "returning true because there is no chain and the chain is not required");
            }
            return true;
        }
        if (!CertPathTrustManagerUtils.doCertPathValidation(n)) {
            boolean bl;
            boolean bl2 = bl = n2 == 0;
            if (CertPathTrustManagerUtils.isDebug()) {
                CertPathTrustManagerUtils.debug(string, "returning " + bl + " because the CertPathValidators should not be called");
            }
            return bl;
        }
        boolean bl = false;
        if (n3 == 0 && (sSLMBean = ManagementService.getRuntimeAccess(kernelId).getServer().getSSL()).isClientCertificateEnforced()) {
            bl = true;
        }
        boolean bl3 = CertPathTrustManagerUtils.performCertPathValidation(x509CertificateArray, n2, bl);
        if (CertPathTrustManagerUtils.isDebug()) {
            CertPathTrustManagerUtils.debug(string, "returning results of CertPathValidators = " + bl3);
        }
        return bl3;
    }

    private static boolean doCertPathValidation(int n) {
        String string;
        String string2 = "doCertPathValidation";
        if (CertPathTrustManagerUtils.isDebug()) {
            CertPathTrustManagerUtils.debug(string2, "");
        }
        if (!running) {
            if (CertPathTrustManagerUtils.isDebug()) {
                CertPathTrustManagerUtils.debug(string2, "returning false because cert path validation is not yet available in this server");
            }
            return false;
        }
        if (n == 1) {
            if (CertPathTrustManagerUtils.isDebug()) {
                CertPathTrustManagerUtils.debug(string2, "returning true because configured to always call the cert path validators");
            }
            return true;
        }
        if (n == 2) {
            if (CertPathTrustManagerUtils.isDebug()) {
                CertPathTrustManagerUtils.debug(string2, "returning false because configured to never call the cert path validators");
            }
            return false;
        }
        if (CertPathTrustManagerUtils.isDebug()) {
            CertPathTrustManagerUtils.debug(string2, "configured to defer to the admin");
        }
        boolean bl = TrustManagerEnvironment.getSSLSocket().getUseClientMode();
        if (CertPathTrustManagerUtils.isDebug()) {
            CertPathTrustManagerUtils.debug(string2, "outbound = " + bl);
        }
        SSLMBean sSLMBean = ManagementService.getRuntimeAccess(kernelId).getServer().getSSL();
        String string3 = string = bl ? sSLMBean.getOutboundCertificateValidation() : sSLMBean.getInboundCertificateValidation();
        if (CertPathTrustManagerUtils.isDebug()) {
            CertPathTrustManagerUtils.debug(string2, "style = " + string);
        }
        boolean bl2 = "BuiltinSSLValidationAndCertPathValidators".equals(string);
        if (CertPathTrustManagerUtils.isDebug()) {
            CertPathTrustManagerUtils.debug(string2, "returning " + bl2);
        }
        return bl2;
    }

    private static boolean performCertPathValidation(X509Certificate[] x509CertificateArray, int n, boolean bl) {
        String string = "performCertPathValidation";
        if (CertPathTrustManagerUtils.isDebug()) {
            CertPathTrustManagerUtils.debug(string, "");
        }
        try {
            int n2 = null == x509CertificateArray ? 0 : x509CertificateArray.length;
            ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>(n2);
            for (int i = 0; i < n2; ++i) {
                arrayList.add(x509CertificateArray[i]);
            }
            CertPath certPath = CertificateFactory.getInstance("X509").generateCertPath(arrayList);
            SSLSocket sSLSocket = TrustManagerEnvironment.getSSLSocket();
            CertPathValidatorParameters certPathValidatorParameters = new CertPathValidatorParameters(SecurityServiceManager.getDefaultRealmName(), TrustManagerEnvironment.getTrustedCAs(), new SSLPrevalidationContextParams(sSLSocket.getPort(), sSLSocket.getInetAddress().toString(), n, bl));
            CertPathValidator certPathValidator = CertPathValidator.getInstance("WLSCertPathValidator");
            try {
                certPathValidator.validate(certPath, certPathValidatorParameters);
                if (CertPathTrustManagerUtils.isDebug()) {
                    CertPathTrustManagerUtils.debug(string, "the chain was validated by the cert path validators");
                }
                return true;
            }
            catch (CertPathValidatorException certPathValidatorException) {
                SecurityLogger.logSSLCertPathNotValidated((String)certPath.toString(), (Throwable)certPathValidatorException);
                if (CertPathTrustManagerUtils.isDebug()) {
                    CertPathTrustManagerUtils.debug(string, "the chain was not validated by the cert path validators:" + certPathValidatorException);
                }
                return false;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (CertPathTrustManagerUtils.isDebug()) {
                    CertPathTrustManagerUtils.debug(string, "the chain was not validated by the cert path validators:" + illegalArgumentException);
                }
                return false;
            }
        }
        catch (Exception exception) {
            if (CertPathTrustManagerUtils.isDebug()) {
                CertPathTrustManagerUtils.debug(string, "unexpected exception: " + exception);
            }
            throw new CertPathTrustManagerRuntimeException(exception);
        }
    }

    private static class SSLPrevalidationContextParams
    implements ContextHandler {
        ContextElement[] ctxElements = new ContextElement[4];

        public SSLPrevalidationContextParams(int n, String string, int n2, boolean bl) {
            this.ctxElements[0] = new ContextElement("com.bea.contextelement.security.ChainPrevailidatedBySSL", (Object)new Boolean(n2 == 0));
            this.ctxElements[1] = new ContextElement("com.bea.contextelement.channel.RemotePort", (Object)new Integer(n));
            this.ctxElements[2] = new ContextElement("com.bea.contextelement.channel.RemoteAddress", (Object)string);
            this.ctxElements[3] = new ContextElement(CLIENT_CERTS_ENFORCED, (Object)new Boolean(bl));
        }

        public int size() {
            return this.ctxElements.length;
        }

        public String[] getNames() {
            String[] stringArray = new String[this.ctxElements.length];
            for (int i = 0; i < this.ctxElements.length; ++i) {
                stringArray[i] = this.ctxElements[i].getName();
            }
            return stringArray;
        }

        public Object getValue(String string) {
            for (int i = 0; i < this.ctxElements.length; ++i) {
                if (!this.ctxElements[i].getName().equals(string)) continue;
                return this.ctxElements[i].getValue();
            }
            return null;
        }

        public ContextElement[] getValues(String[] stringArray) {
            ArrayList<ContextElement> arrayList = new ArrayList<ContextElement>(this.ctxElements.length);
            block0: for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                for (int j = 0; j < this.ctxElements.length; ++j) {
                    if (!this.ctxElements[j].getName().equals(stringArray[i])) continue;
                    arrayList.add(this.ctxElements[j]);
                    continue block0;
                }
            }
            return arrayList.toArray(new ContextElement[arrayList.size()]);
        }
    }

    private static final class CertPathTrustManagerRuntimeException
    extends RuntimeException {
        public CertPathTrustManagerRuntimeException(Throwable throwable) {
            super(throwable);
        }
    }
}

