/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.utils;

import weblogic.security.SecurityMessagesTextFormatter;
import weblogic.security.utils.KeyStoreConfiguration;
import weblogic.security.utils.KeyStoreConfigurationHelper;
import weblogic.security.utils.KeyStoreInfo;

public class ClientKeyStoreConfiguration
implements KeyStoreConfiguration {
    private String keystores;
    private static ClientKeyStoreConfiguration theInstance;

    public static synchronized ClientKeyStoreConfiguration getInstance() {
        if (theInstance == null) {
            theInstance = new ClientKeyStoreConfiguration();
        }
        return theInstance;
    }

    private String getProperty(String string) {
        return System.getProperty(string);
    }

    private ClientKeyStoreConfiguration() {
        Object object;
        boolean bl = false;
        String string = this.getProperty("weblogic.security.TrustKeyStore");
        String string2 = this.getProperty("weblogic.security.CustomTrustKeyStoreFileName");
        if ("DemoTrust".equals(string)) {
            this.keystores = "DemoIdentityAndDemoTrust";
        } else if ("JavaStandardTrust".equals(string)) {
            this.keystores = "CustomIdentityAndJavaStandardTrust";
        } else if ("CustomTrust".equals(string)) {
            object = this.getProperty("weblogic.security.CustomTrustKeyStoreFileName");
            if (object == null || ((String)object).length() < 1) {
                bl = true;
            }
            this.keystores = "CustomIdentityAndCustomTrust";
        } else {
            if (string != null && string.length() > 0) {
                bl = true;
            }
            this.keystores = "CustomIdentityAndJavaStandardTrust";
        }
        if (bl) {
            object = SecurityMessagesTextFormatter.getInstance();
            String string3 = object.getSSLClientTrustKeyStoreConfigError();
            String string4 = object.getSSLClientTrustKeyStoreSyntax();
            throw new RuntimeException(string3 + "\n\n" + string4);
        }
    }

    public String getKeyStores() {
        return this.keystores;
    }

    public String getCustomIdentityKeyStoreFileName() {
        return null;
    }

    public String getCustomIdentityKeyStoreType() {
        return null;
    }

    public String getCustomIdentityKeyStorePassPhrase() {
        return null;
    }

    public String getCustomIdentityAlias() {
        return null;
    }

    public String getCustomIdentityPrivateKeyPassPhrase() {
        return null;
    }

    public String getOutboundPrivateKeyAlias() {
        return null;
    }

    public String getOutboundPrivateKeyPassPhrase() {
        return null;
    }

    public String getCustomTrustKeyStoreFileName() {
        return this.getProperty("weblogic.security.CustomTrustKeyStoreFileName");
    }

    public String getCustomTrustKeyStoreType() {
        return this.getProperty("weblogic.security.CustomTrustKeyStoreType");
    }

    public String getCustomTrustKeyStorePassPhrase() {
        return this.getProperty("weblogic.security.CustomTrustKeyStorePassPhrase");
    }

    public String getJavaStandardTrustKeyStorePassPhrase() {
        return this.getProperty("weblogic.security.JavaStandardTrustKeyStorePassPhrase");
    }

    public static void main(String[] stringArray) {
        KeyStoreConfigurationHelper keyStoreConfigurationHelper = new KeyStoreConfigurationHelper(ClientKeyStoreConfiguration.getInstance());
        KeyStoreInfo[] keyStoreInfoArray = keyStoreConfigurationHelper.getTrustKeyStores();
        for (int i = 0; keyStoreInfoArray != null && i < keyStoreInfoArray.length; ++i) {
            System.out.println("TrustKeyStore[" + i + "]=" + keyStoreInfoArray[i]);
        }
    }
}

