/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.utils;

import java.io.IOException;
import java.io.InputStream;
import weblogic.security.shared.LoggerWrapper;

public class ContextElementMessageStream
extends InputStream
implements weblogic.security.service.ContextElementMessageStream {
    private static LoggerWrapper LOGGER = LoggerWrapper.getInstance("SecurityAuditor");
    private boolean resetCalled = false;
    private int readLimit = Integer.MAX_VALUE;
    private InputStream realStream = null;

    private ContextElementMessageStream() {
    }

    public ContextElementMessageStream(InputStream inputStream, int n) {
        this.realStream = inputStream;
        this.readLimit = n;
    }

    public void resetToStart() {
        if (this.resetCalled) {
            try {
                this.realStream.reset();
            }
            catch (IOException iOException) {
                LOGGER.debug("Failure while resetting ContextElementMessageStream", iOException);
            }
            this.resetCalled = true;
        }
        this.realStream.mark(this.readLimit);
    }

    public int available() throws IOException {
        return this.realStream.available();
    }

    public void close() throws IOException {
    }

    public void mark(int n) {
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        return this.realStream.read();
    }

    public int read(byte[] byArray) throws IOException {
        return this.realStream.read(byArray);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.realStream.read(byArray, n, n2);
    }

    public void reset() throws IOException {
        throw new IOException("Reset not supported on InputStream");
    }

    public long skip(long l) throws IOException {
        return this.realStream.skip(l);
    }
}

