/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.utils;

import java.security.Principal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.Subject;
import weblogic.entitlement.engine.ESubject;
import weblogic.security.SecurityLogger;
import weblogic.security.principal.RealmAdapterUser;
import weblogic.security.spi.InvalidPrincipalException;
import weblogic.security.spi.WLSGroup;

public class ESubjectImpl
implements ESubject {
    public static final String EVERYONE_GROUP = "everyone";
    public static final String USERS_GROUP = "users";
    private Subject subject;
    private Map users;
    private Map groups;
    private Map roles;
    private Map notGroups;
    private RealmAdapterUser realmAdapter;

    public ESubjectImpl(Subject subject) {
        this(subject, null);
    }

    public ESubjectImpl(Subject subject, Map map) {
        if (subject == null) {
            throw new NullPointerException(SecurityLogger.getNullSubject());
        }
        this.subject = subject;
        this.users = new HashMap();
        this.groups = new HashMap();
        this.roles = map;
        for (Principal principal : subject.getPrincipals()) {
            String string = principal.getName();
            if (principal instanceof WLSGroup) {
                this.groups.put(string, string);
                continue;
            }
            this.users.put(string, string);
            if (this.realmAdapter != null || !(principal instanceof RealmAdapterUser)) continue;
            this.realmAdapter = (RealmAdapterUser)((Object)principal);
            this.notGroups = new HashMap();
        }
        if (this.users.size() > 0 || this.groups.size() > 0) {
            this.groups.put(USERS_GROUP, USERS_GROUP);
        }
        this.groups.put(EVERYONE_GROUP, EVERYONE_GROUP);
    }

    public Subject getSubject() {
        return this.subject;
    }

    public boolean isUser(String string) {
        return this.users.containsKey(string);
    }

    public boolean isMemberOf(String string) {
        boolean bl = this.groups.containsKey(string);
        if (this.realmAdapter != null && !bl && !this.notGroups.containsKey(string)) {
            try {
                bl = this.realmAdapter.isUserInGroup(string);
            }
            catch (InvalidPrincipalException invalidPrincipalException) {
                bl = false;
            }
            catch (SecurityException securityException) {
                bl = false;
            }
            if (bl) {
                this.groups.put(string, string);
            } else {
                this.notGroups.put(string, string);
            }
        }
        return bl;
    }

    public boolean isInRole(String string) {
        return this.roles != null && this.roles.containsKey(string);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[Users: ").append(this.toString(this.users.keySet().iterator()));
        stringBuffer.append("|Groups: ").append(this.toString(this.groups.keySet().iterator()));
        stringBuffer.append("|Roles: ").append(this.roles == null ? "null" : "not null");
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private String toString(Iterator iterator) {
        StringBuffer stringBuffer = new StringBuffer();
        if (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
        }
        while (iterator.hasNext()) {
            stringBuffer.append(",").append(iterator.next());
        }
        return stringBuffer.toString();
    }
}

