/*
 * Decompiled with CFR 0.152.
 */
package weblogic.security.utils;

import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import netscape.ldap.LDAPCache;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import weblogic.ldap.EmbeddedLDAP;
import weblogic.ldap.EmbeddedLDAPConnection;
import weblogic.management.configuration.EmbeddedLDAPMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.security.shared.LoggerWrapper;
import weblogic.security.utils.Factory;
import weblogic.security.utils.LDAPConnectionHelper;
import weblogic.security.utils.LDAPServerInfo;
import weblogic.security.utils.Pool;

public final class EmbeddedLDAPConnectionPool {
    private static AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final int LDAP_VERSION = 3;
    private LDAPServerInfo serverInfo;
    private Pool pool;
    private static final int POOL_SIZE = 6;
    private static final String OBJECTCLASS_ATTR = "objectclass";
    private boolean ignoreCertPathValidators = false;
    private static LoggerWrapper log = LoggerWrapper.getInstance("DebugEmbeddedLDAP");

    private boolean isDebug() {
        return log.isDebugEnabled();
    }

    private void _debug(String string) {
        if (log.isDebugEnabled()) {
            log.debug(string);
        }
    }

    private void debug(String string, String string2) {
        this._debug("EmbeddedLDAPConnectdionPool." + string + ": " + string2);
    }

    public EmbeddedLDAPConnectionPool(LoggerWrapper loggerWrapper) {
        this(loggerWrapper, false);
    }

    public EmbeddedLDAPConnectionPool(LoggerWrapper loggerWrapper, boolean bl) {
        String string = "constructor";
        this.ignoreCertPathValidators = bl;
        this.initializeServerInfo();
        this.initializePool();
        if (loggerWrapper != null) {
            log = loggerWrapper;
        }
        if (this.isDebug()) {
            this.debug(string, "succeeded.  Pool = " + this);
        }
    }

    private void initializeServerInfo() {
        final EmbeddedLDAP embeddedLDAP = EmbeddedLDAP.getEmbeddedLDAP();
        final EmbeddedLDAPMBean embeddedLDAPMBean = embeddedLDAP.getEmbeddedLDAPMBean();
        SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)kernelId, (PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                1 v0 = this;
                1 v1 = this;
                1 v2 = this;
                EmbeddedLDAPConnectionPool.this.serverInfo = new LDAPServerInfo(true, v0.embeddedLDAP.getEmbeddedLDAPHost(), v1.embeddedLDAP.getEmbeddedLDAPPort(), v2.embeddedLDAP.getEmbeddedLDAPUseSSL(), "cn=Admin", 1, embeddedLDAPMBean);
                return null;
            }
        });
    }

    private void initializePool() {
        int n = 6;
        try {
            String string = System.getProperty("weblogic.security.providers.utils.EmbeddedLDAPDelegatePoolSize");
            if (string != null && string.length() > 0) {
                n = new Integer(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.pool = new Pool((Factory)new MyLDAPFactory(), n);
    }

    public LDAPConnectionHelper getReadOnlyConnection() {
        return new LDAPConnectionHelper(this.pool, false, log);
    }

    public LDAPConnectionHelper getReadWriteConnection() {
        return new LDAPConnectionHelper(this.pool, true, log);
    }

    private class MyLDAPFactory
    implements Factory {
        private MyLDAPFactory() {
        }

        private void debug(String string, String string2) {
            EmbeddedLDAPConnectionPool.this._debug("EmbeddedLDAPDelegate.MyLDAPFactory" + string + ": " + string2);
        }

        public Object newInstance() throws InvocationTargetException {
            String string = "newInstance";
            try {
                EmbeddedLDAPConnection embeddedLDAPConnection = new EmbeddedLDAPConnection(false, false, EmbeddedLDAPConnectionPool.this.ignoreCertPathValidators);
                if (EmbeddedLDAPConnectionPool.this.isDebug()) {
                    this.debug(string, "created new LDAP connection " + (Object)((Object)embeddedLDAPConnection));
                }
                if (EmbeddedLDAPConnectionPool.this.isDebug()) {
                    embeddedLDAPConnection.setProperty("com.netscape.ldap.trace", "+ldap_trace.log");
                }
                embeddedLDAPConnection.connect(EmbeddedLDAPConnectionPool.this.serverInfo.getHost(), EmbeddedLDAPConnectionPool.this.serverInfo.getPort());
                embeddedLDAPConnection.bind(3, EmbeddedLDAPConnectionPool.this.serverInfo.getPrincipal(), EmbeddedLDAPConnectionPool.this.serverInfo.getCredential());
                if (EmbeddedLDAPConnectionPool.this.serverInfo.getCacheEnabled() && EmbeddedLDAPConnectionPool.this.serverInfo.getCacheTTL() > 0 && EmbeddedLDAPConnectionPool.this.serverInfo.getCacheSize() > 0) {
                    embeddedLDAPConnection.setCache(new LDAPCache((long)EmbeddedLDAPConnectionPool.this.serverInfo.getCacheTTL(), (long)(EmbeddedLDAPConnectionPool.this.serverInfo.getCacheSize() * 1024)));
                }
                if (EmbeddedLDAPConnectionPool.this.isDebug()) {
                    this.debug(string, "connection succeeded");
                }
                return embeddedLDAPConnection;
            }
            catch (LDAPException lDAPException) {
                if (EmbeddedLDAPConnectionPool.this.isDebug()) {
                    this.debug(string, "connection failed " + (Object)((Object)lDAPException));
                }
                throw new InvocationTargetException(lDAPException);
            }
        }

        public void destroyInstance(Object object) {
            String string = "destroyInstance";
            try {
                if (EmbeddedLDAPConnectionPool.this.isDebug()) {
                    this.debug(string, "destroy LDAP connection " + object);
                }
                ((LDAPConnection)object).disconnect();
            }
            catch (LDAPException lDAPException) {
                // empty catch block
            }
        }
    }
}

